/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscUpdatePaidResultService;
import com.tydic.pfscext.api.busi.bo.FscSupplierNotificationInvoiceResultAbilityReqBO;
import com.tydic.pfscext.api.busi.bo.FscSupplierNotificationInvoiceResultAbilityRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayConfigDetailMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayConfigDetail;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApproveStatus;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscUpdatePaidResultService.class)
public class FscUpdatePaidResultServiceImpl
implements FscUpdatePaidResultService {
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayConfigDetailMapper payConfigDetailMapper;
    private static final String PENMGDING = "01";
    private static final String ORDER_STATUS_SUCCESS = "01";
    private static final Integer PAYABLE_LAGGED = 15;

    public FscSupplierNotificationInvoiceResultAbilityRspBO dealResult(FscSupplierNotificationInvoiceResultAbilityReqBO reqBO) {
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayStatus("01");
        List<ApplyPayInfoPO> list = this.applyPayInfoMapper.getList(applyPayInfoPO);
        if (!CollectionUtils.isEmpty(list) && list.size() > 0) {
            ArrayList<String> payableNos = new ArrayList<String>(list.size());
            ArrayList<String> payNos = new ArrayList<String>(list.size());
            list.forEach(PO -> {
                payNos.add(PO.getPayno());
                List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(PO.getPayno());
                applyDetails.forEach(applyDetail -> payableNos.add(applyDetail.getPayableNo()));
            });
            this.updatePaymentStatus(payNos, payableNos);
        }
        FscSupplierNotificationInvoiceResultAbilityRspBO fscSupplierNotificationInvoiceResultAbilityRspBO = new FscSupplierNotificationInvoiceResultAbilityRspBO();
        return fscSupplierNotificationInvoiceResultAbilityRspBO;
    }

    private void updatePaymentStatus(List<String> payNos, List<String> payableNos) {
        String payStatus = PayResultStatus.SUCCESS.getCode();
        String payableStatus = PayableStatus.SUCCESS.getCode();
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayStatus(payStatus);
        applyPayInfoPO.setPayNos(payNos);
        int i = this.applyPayInfoMapper.updateStatusBatch(applyPayInfoPO);
        if (i != payNos.size()) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4ed8\u6b3e\u5355\u72b6\u6001\u6570\u636e\u51fa\u9519");
        }
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNos(payNos);
        applyDetail.setStatus(payStatus);
        int i1 = this.applyDetailMapper.updateStatusBatch(applyDetail);
        if (i1 != payNos.size()) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4ed8\u6b3e\u5355\u8be6\u60c5\u72b6\u6001\u6570\u636e\u51fa\u9519");
        }
        for (String payableNo : payableNos) {
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableNo(payableNo);
            payableDetailPO.setPayableStatus(payableStatus);
            int i2 = this.payableDetailMapper.updateCallBackResultByNo(payableDetailPO);
            if (i2 < 0) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5e94\u4ed8\u5355\u72b6\u6001\u51fa\u9519");
            }
            PayableDetailPO model = this.payableDetailMapper.getModelById(payableNo);
            if (model.getPayableType().equals(PayableType.EXPIRE.getCode())) {
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setOrderId(model.getOrderId());
                payPurchaseOrderInfo.setPayStatus("01");
                this.payPurchaseOrderInfoMapper.updatePayStatusByOrderId(payPurchaseOrderInfo);
                PayConfigDetail payConfigDetail = new PayConfigDetail();
                payConfigDetail.setExceptId(payableDetailPO.getPayOrgId());
                payConfigDetail.setPaymentAmount(payableDetailPO.getPaidAmt());
                this.payConfigDetailMapper.updateByOrgIdAndSupplierId(payConfigDetail);
            }
            if (null == model.getApproveStatus() || !ApproveStatus.OVERDUEAPPROVE.equals(model.getApproveStatus())) continue;
            model.setPayableNo(this.getPayInfoId(model.getPayableType()));
            model.setPayableType(PAYABLE_LAGGED);
            model.setPaidDate(null);
            this.payableDetailMapper.insert(model);
        }
    }

    private String getPayInfoId(Integer payableType) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String prefix = "YFDH";
            if (payableType == 2) {
                prefix = "DH";
            } else if (payableType == 3) {
                prefix = "YS";
            }
            String maxNum = this.payableDetailMapper.selectMaxPayNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

