/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.AdvanceReceiveExtMapper;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.RecAmtConfirmMapper;
import com.tydic.pfscext.dao.RecvAmtDetailMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.AdvanceReceiveExtPO;
import com.tydic.pfscext.dao.po.InquiryPayOrder;
import com.tydic.pfscext.dao.po.InquiryPayOrderExt;
import com.tydic.pfscext.dao.po.RecAmtConfirm;
import com.tydic.pfscext.dao.po.RecvAmtDetail;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.dao.vo.RecvAmtDetailVO;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.InquiryPaymentStatus;
import com.tydic.pfscext.enums.RecAmtConfirmStatus;
import com.tydic.pfscext.service.atom.FscCancelSupPayReceiptOrderAtomService;
import com.tydic.pfscext.service.atom.bo.FscCancelSupPayReceiptOrderAtomReqBO;
import com.tydic.pfscext.service.atom.bo.FscCancelSupPayReceiptOrderAtomRspBO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscCancelSupPayReceiptOrderAtomService")
public class FscCancelSupPayReceiptOrderAtomServiceImpl
implements FscCancelSupPayReceiptOrderAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscCancelSupPayReceiptOrderAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private RecvAmtDetailMapper recvAmtDetailMapper;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    private RecAmtConfirmMapper recAmtConfirmMapper;
    private AdvanceReceiveExtMapper advanceReceiveExtMapper;

    @Autowired
    public FscCancelSupPayReceiptOrderAtomServiceImpl(RecvAmtDetailMapper recvAmtDetailMapper, AdvanceReceiveMapper advanceReceiveMapper, InquiryPayOrderMapper inquiryPayOrderMapper, RecAmtConfirmMapper recAmtConfirmMapper, AdvanceReceiveExtMapper advanceReceiveExtMapper) {
        this.recvAmtDetailMapper = recvAmtDetailMapper;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.inquiryPayOrderMapper = inquiryPayOrderMapper;
        this.recAmtConfirmMapper = recAmtConfirmMapper;
        this.advanceReceiveExtMapper = advanceReceiveExtMapper;
    }

    @Override
    public FscCancelSupPayReceiptOrderAtomRspBO cancelSupPayReceiptOrder(FscCancelSupPayReceiptOrderAtomReqBO reqBO) {
        int delete;
        FscCancelSupPayReceiptOrderAtomRspBO rspBO = new FscCancelSupPayReceiptOrderAtomRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        Long docNum = reqBO.getDocNum();
        InquiryPayOrderExt payExt = new InquiryPayOrderExt();
        payExt.setDocNum(docNum);
        payExt.setPaymentStatus(InquiryPaymentStatus.REC_CONFIRMED.getCode());
        List<InquiryPayOrder> inquiryPayOrderList = this.inquiryPayOrderMapper.getList(payExt);
        if (!CollectionUtils.isEmpty(inquiryPayOrderList)) {
            for (InquiryPayOrder inquiryPayOrder : inquiryPayOrderList) {
                RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
                recvAmtDetailVO.setPayOrderNo(inquiryPayOrder.getPayOrderNo());
                recvAmtDetailVO.setDocNum(docNum);
                List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
                if (!CollectionUtils.isEmpty(recvAmtDetailList)) {
                    for (RecvAmtDetail recvAmtDetail : recvAmtDetailList) {
                        int update;
                        AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey(recvAmtDetail.getAdvRecvSeq());
                        if (advanceReceive != null) {
                            AdvanceReceiveVO updateAdvance = new AdvanceReceiveVO();
                            updateAdvance.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
                            updateAdvance.setSeq(advanceReceive.getSeq());
                            updateAdvance.setWriteoffAmt(advanceReceive.getWriteoffAmt().subtract(recvAmtDetail.getAmount()));
                            AdvanceReceive updateAdvancePo = new AdvanceReceive();
                            BeanUtils.copyProperties((Object)updateAdvance, (Object)updateAdvancePo);
                            update = this.advanceReceiveMapper.updateByPrimaryKeySelective(updateAdvancePo);
                            if (update >= 1) continue;
                            rspBO.setRespCode("18006");
                            rspBO.setRespDesc("\u53d6\u6d88\u4f9b\u5e94\u5546\u7f34\u8d39\u751f\u6210\u7684\u6536\u6b3e\u5355\u5931\u8d25");
                            return rspBO;
                        }
                        AdvanceReceiveExtPO advancePO = this.advanceReceiveExtMapper.selectByPrimaryKey(recvAmtDetail.getAdvRecvSeq());
                        if (advancePO == null) continue;
                        AdvanceReceiveExtPO updateAdvanceExt = new AdvanceReceiveExtPO();
                        updateAdvanceExt.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
                        updateAdvanceExt.setSeq(advancePO.getSeq());
                        updateAdvanceExt.setWriteoffAmt(advancePO.getWriteoffAmt().subtract(recvAmtDetail.getAmount()));
                        update = this.advanceReceiveExtMapper.updateByPrimaryKeySelective(updateAdvanceExt);
                        if (update >= 1) continue;
                        rspBO.setRespCode("18006");
                        rspBO.setRespDesc("\u53d6\u6d88\u4f9b\u5e94\u5546\u7f34\u8d39\u751f\u6210\u7684\u6536\u6b3e\u5355\u5931\u8d25");
                        return rspBO;
                    }
                }
                InquiryPayOrderExt updateInquiry = new InquiryPayOrderExt();
                updateInquiry.setDocNum(null);
                updateInquiry.setPaymentStatus(inquiryPayOrder.getPaymentStatusOld());
                updateInquiry.setPayOrderNo(inquiryPayOrder.getPayOrderNo());
                updateInquiry.setPaymentStatusOld(null);
                int update = this.inquiryPayOrderMapper.updateStateByPayOrderNo(updateInquiry);
                if (update >= 1) continue;
                rspBO.setRespCode("18006");
                rspBO.setRespDesc("\u53d6\u6d88\u4f9b\u5e94\u5546\u7f34\u8d39\u751f\u6210\u7684\u6536\u6b3e\u5355\u5931\u8d25");
                return rspBO;
            }
        }
        if ((delete = this.recvAmtDetailMapper.deleteByDocNum(docNum)) < 1) {
            rspBO.setRespCode("18006");
            rspBO.setRespDesc("\u53d6\u6d88\u4f9b\u5e94\u5546\u7f34\u8d39\u751f\u6210\u7684\u6536\u6b3e\u5355\u5931\u8d25");
            return rspBO;
        }
        RecAmtConfirm recAmtConfirm = new RecAmtConfirm();
        recAmtConfirm.setDocNum(docNum);
        recAmtConfirm.setStatus(RecAmtConfirmStatus.INVALID.getCode());
        recAmtConfirm.setUpdateDate(new Date());
        int update = this.recAmtConfirmMapper.updateByPrimaryKeySelective(recAmtConfirm);
        if (update < 1) {
            rspBO.setRespCode("18006");
            rspBO.setRespDesc("\u53d6\u6d88\u4f9b\u5e94\u5546\u7f34\u8d39\u751f\u6210\u7684\u6536\u6b3e\u5355\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53d6\u6d88\u4f9b\u5e94\u5546\u7f34\u8d39\u751f\u6210\u7684\u6536\u6b3e\u5355\u6210\u529f");
        return rspBO;
    }

    private String validateArg(FscCancelSupPayReceiptOrderAtomReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getDocNum()) {
            return "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

