/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiElecQryRefundItemsService;
import com.tydic.pfscext.api.busi.bo.BusiElecQryRefundItemsReqBO;
import com.tydic.pfscext.api.busi.bo.BusiElecQryRefundItemsRspBO;
import com.tydic.pfscext.api.busi.vo.ElecAllowRefundItemVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.ElecRefundService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiElecQryRefundItemsServiceImpl
implements BusiElecQryRefundItemsService {
    private static final Logger logger = LoggerFactory.getLogger(BusiElecQryRefundItemsServiceImpl.class);
    @Autowired
    private ElecRefundService elecRefundService;

    public BusiElecQryRefundItemsRspBO queryRefundItems(BusiElecQryRefundItemsReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u529b\u4e13\u533a\u9000\u8d27\u67e5\u8be2,reqBo=" + reqBO);
        }
        String saleOrdId = reqBO.getSaleOrderId();
        String inspId = reqBO.getInspectionId();
        String operUnitNo = reqBO.getOperUnitNo();
        String purchaseNo = reqBO.getPurchaseNo();
        if (!StringUtils.hasText((String)operUnitNo)) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u673a\u6784\u65e0\u6548(operUnitNo)");
        }
        if (!StringUtils.hasText((String)purchaseNo)) {
            throw new PfscExtBusinessException("0001", "\u65e0\u6cd5\u786e\u5b9a\u91c7\u8d2d\u5355\u4f4d\u7684\u673a\u6784(purchaseNo)");
        }
        if (!StringUtils.hasText((String)saleOrdId)) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165(saleOrderId)");
        }
        if (!StringUtils.hasText((String)inspId)) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u5fc5\u987b\u8f93\u5165(inspectionId)");
        }
        BusiElecQryRefundItemsRspBO rsp = new BusiElecQryRefundItemsRspBO();
        rsp.setSaleOrderId(saleOrdId);
        rsp.setInspectionId(inspId);
        rsp.setItems(new ArrayList());
        try {
            List<SaleItemInfoVO> items = this.elecRefundService.queryAllowRefundItems(saleOrdId, inspId, purchaseNo, operUnitNo, false);
            logger.debug("\u4e13\u533a\u53ef\u9000\u6b3e\u5546\u54c1\u67e5\u8be2,\u5339\u914d\u6570\u91cf=" + items.size());
            for (SaleItemInfoVO item : items) {
                if (item.getPaySeq() == null) {
                    logger.warn("\u4e13\u533a\u53ef\u9000\u6b3e\u5546\u54c1\u67e5\u8be2,\u53d1\u73b0\u7f3a\u5c11\u91c7\u8d2d\u5173\u8054\u7684\u5546\u54c1,purchaseId=" + item.getPurchaseOrderId() + ",inspectionId=" + item.getInspectionId() + ",PURCHASE_ITEM_NO=" + item.getPurchaseItemNo());
                    continue;
                }
                if (item.getQuantity().compareTo(BigDecimal.ZERO) <= 0) continue;
                ElecAllowRefundItemVO vo = new ElecAllowRefundItemVO();
                rsp.getItems().add(vo);
                vo.setSkuId("" + item.getSkuId());
                vo.setSaleItemNo("" + item.getItemNo());
            }
            logger.debug("\u4e13\u533a\u53ef\u9000\u8d27\u5546\u54c1\u67e5\u8be2,\u53ef\u9000\u8d27\u6570\u91cf=" + rsp.getItems().size());
        }
        catch (Exception e) {
            logger.error("\u4e13\u533a\u53ef\u9000\u8d27\u5546\u54c1\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        return rsp;
    }
}

