/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.deal.FscPayableOrderTimeoutTaskService;
import com.tydic.pfscext.api.deal.bo.FscPayableOrderTimeoutTaskReqBO;
import com.tydic.pfscext.api.deal.bo.FscPayableOrderTimeoutTaskRspBO;
import com.tydic.pfscext.dao.PayConfigDetailMapper;
import com.tydic.pfscext.dao.PayConfigMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayConfig;
import com.tydic.pfscext.dao.po.PayConfigDetail;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayableOrderTimeoutTaskService.class)
public class FscPayableOrderTimeoutTaskServiceImpl
implements FscPayableOrderTimeoutTaskService {
    private static final Logger logger = LoggerFactory.getLogger(FscPayableOrderTimeoutTaskServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayConfigDetailMapper payConfigDetailMapper;
    @Autowired
    private PayConfigMapper payConfigMapper;

    public FscPayableOrderTimeoutTaskRspBO dealTimeoutOrder(FscPayableOrderTimeoutTaskReqBO reqBO) {
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectToBePaidList();
        FscPayableOrderTimeoutTaskRspBO rspBo = new FscPayableOrderTimeoutTaskRspBO();
        if (payableDetailPOS.size() == 0) {
            logger.debug("\u65e0\u672a\u4ed8\u6b3e\u8ba2\u5355\uff01");
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u65e0\u672a\u4ed8\u6b3e\u8ba2\u5355\uff01");
            return rspBo;
        }
        logger.debug("\u672a\u4ed8\u6b3e\u8ba2\u5355\uff1a" + payableDetailPOS.toString());
        HashSet<Long> payOrgIdSet = new HashSet<Long>();
        ArrayList<Long> payOrgIdList = new ArrayList<Long>();
        for (PayableDetailPO payableDetail : payableDetailPOS) {
            payOrgIdSet.add(payableDetail.getPayOrgId());
        }
        payOrgIdList.addAll(payOrgIdSet);
        List<PayConfigDetail> payConfigDetails = this.payConfigDetailMapper.selectPayConfigDetailList(payOrgIdList);
        logger.debug("\u652f\u4ed8\u914d\u7f6e\u8be6\u60c5PAY_CONFIG_DETAIL\uff1a" + payConfigDetails.toString());
        HashMap<Long, PayConfigDetail> payConfigDetailMap = new HashMap<Long, PayConfigDetail>(16);
        if (payConfigDetails.size() != 0) {
            for (PayConfigDetail payConfigDetail : payConfigDetails) {
                payConfigDetailMap.put(payConfigDetail.getExceptId(), payConfigDetail);
            }
        }
        List<PayConfig> payConfigs = this.payConfigMapper.selectPayConfigList();
        logger.debug("\u652f\u4ed8\u914d\u7f6ePAY_CONFIG\uff1a" + payConfigs.toString());
        ArrayList<PayableDetailPO> toBePaidPayableList = new ArrayList<PayableDetailPO>();
        Date now = new Date();
        for (PayableDetailPO payableDetail : payableDetailPOS) {
            Date paidDate = payableDetail.getPaidDate();
            if (now.getTime() <= paidDate.getTime()) continue;
            int overdueDays = (int)((now.getTime() - paidDate.getTime()) / 86400000L);
            BigDecimal payableAmt = payableDetail.getPayableAmt();
            BigDecimal overdueRate = null;
            PayConfigDetail payConfigDetail = (PayConfigDetail)payConfigDetailMap.get(payableDetail.getPayOrgId());
            if (payConfigDetail != null) {
                overdueRate = payConfigDetail.getOverdueRate();
            } else {
                PayConfig payConfig = payConfigs.get(0);
                overdueRate = payConfig.getOverdueRate();
            }
            BigDecimal interestPerDay = payableAmt.multiply(overdueRate);
            BigDecimal interest = interestPerDay.multiply(new BigDecimal(overdueDays));
            payableDetail.setOverduePenalty(interest);
            payableDetail.setOverdueDays(overdueDays);
            toBePaidPayableList.add(payableDetail);
            this.payableDetailMapper.updateToBePaidPayable(payableDetail);
        }
        logger.debug("\u66f4\u65b0\u5b8c\u6210\uff1a" + ((Object)toBePaidPayableList).toString());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

