/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.tydic.pfscext.api.busi.FscApplyPaySubmitService;
import com.tydic.pfscext.api.busi.FscCreateDoubleLinkApplyService;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayRspBO;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderSubmitReqBo;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.ApproveStatus;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscApplyPaySubmitService.class)
public class FscApplyPaySubmitServiceImpl
implements FscApplyPaySubmitService {
    private static final Logger logger = LoggerFactory.getLogger(FscApplyPaySubmitServiceImpl.class);
    private static final String OVERDUEAPPROVE = "2";
    private static final String WAITAPPROVE = "0";
    private static final String FAILUREAPPROVE = "3";
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FscCreateDoubleLinkApplyService fscCreateDoubleLinkApplyService;

    public BusiApplyPayRspBO submit(BusiApplyPayReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u4e2d\u5fc3\u4ed8\u6b3e\u7533\u8bf7\u670d\u52a1 \u5165\u53c2\uff1a" + JSON.toString((Object)reqBO));
        }
        this.initParam(reqBO);
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListByIds(reqBO.getPayableNos());
        List<BigDecimal> AmtSums = this.checkPayable(payableDetailPOS, reqBO);
        Long payNo = this.billSNService.getSn(BillType.PAY_APPLICATION);
        this.writeApplyPayInfo(payableDetailPOS.get(0), AmtSums, reqBO, payNo);
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            this.writeApplyDetail(payableDetailPO, reqBO, payNo);
        }
        BusiApplyPayRspBO busiApplyPayRspBO = new BusiApplyPayRspBO();
        busiApplyPayRspBO.setPayNo(String.valueOf(payNo));
        return busiApplyPayRspBO;
    }

    private void writeApplyDetail(PayableDetailPO payableDetailPO, BusiApplyPayReqBO reqBO, Long payno) {
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payno.toString());
        applyDetail.setPayableNo(payableDetailPO.getPayableNo());
        applyDetail.setOperatorId(reqBO.getOperatorId());
        applyDetail.setSource(payableDetailPO.getSource());
        applyDetail.setSupplierId(payableDetailPO.getSupplierId());
        applyDetail.setStatus(ApplyPayStatus.APPLYING.getCode());
        applyDetail.setAmt(payableDetailPO.getPayableAmt());
        applyDetail.setCompanyId(payableDetailPO.getOperatorId());
        this.applyDetailMapper.insert(applyDetail);
        PayableDetailPO forUpdate = new PayableDetailPO();
        forUpdate.setPayableStatus(PayableStatus.PAYINGS.getCode());
        forUpdate.setPendingAmt(payableDetailPO.getPayableAmt());
        forUpdate.setPayableNo(payableDetailPO.getPayableNo());
        int i1 = this.payableDetailMapper.updatePayAmount(forUpdate);
        if (i1 != 1) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u5e94\u4ed8\u5355\u72b6\u6001\u5931\u8d25");
        }
    }

    private void writeApplyPayInfo(PayableDetailPO payableDetailPO, List<BigDecimal> amtSum, BusiApplyPayReqBO reqBO, Long payno) {
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayAmt(amtSum.get(0));
        applyPayInfoPO.setPayableAtm(amtSum.get(1));
        applyPayInfoPO.setLiquidatedAmt(amtSum.get(2));
        applyPayInfoPO.setPayno(payno.toString());
        applyPayInfoPO.setSource(payableDetailPO.getSource());
        applyPayInfoPO.setApplyDate(new Date());
        applyPayInfoPO.setOperatorId(reqBO.getUserId());
        applyPayInfoPO.setPayStatus(ApplyPayStatus.APPLYING.getCode());
        applyPayInfoPO.setSupplierId(payableDetailPO.getSupplierId());
        applyPayInfoPO.setCompanyId(reqBO.getCompanyId());
        applyPayInfoPO.setCompanyName(reqBO.getCompanyName());
        int i = this.applyPayInfoMapper.insert(applyPayInfoPO);
        ApplyPayInfoPO modelById = this.applyPayInfoMapper.getModelById(applyPayInfoPO.getPayno());
        FscPayApplyOrderSubmitReqBo fscPayApplyOrderSubmitReqBo = new FscPayApplyOrderSubmitReqBo();
        fscPayApplyOrderSubmitReqBo.setPayno(modelById.getPayno());
        fscPayApplyOrderSubmitReqBo.setPayOrgId(modelById.getPayOrgId());
        fscPayApplyOrderSubmitReqBo.setRecOrgId(modelById.getRecOrgId());
        fscPayApplyOrderSubmitReqBo.setOperatorId(modelById.getOperatorId());
        this.fscCreateDoubleLinkApplyService.createDoubleLinkApplyOrder(fscPayApplyOrderSubmitReqBo);
    }

    private List<BigDecimal> checkPayable(List<PayableDetailPO> payableDetailPOS, BusiApplyPayReqBO reqBO) {
        ArrayList<BigDecimal> bigDecimals = new ArrayList<BigDecimal>();
        if (CollectionUtils.isEmpty(payableDetailPOS) || payableDetailPOS.size() != reqBO.getPayableNos().size()) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u65e0\u6548\u5e94\u4ed8\u5355\u53f7");
        }
        BigDecimal payAmtSum = new BigDecimal(0);
        BigDecimal payableAmtSum = new BigDecimal(0);
        BigDecimal liquidatedAmt = new BigDecimal(0);
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            if (null == payableDetailPO.getPayableType() || !payableDetailPOS.get(0).getPayableType().equals(payableDetailPO.getPayableType())) {
                throw new PfscExtBusinessException("18000", "\u5408\u5e76\u652f\u4ed8\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u76f8\u540c");
            }
            if (null == payableDetailPO.getRecOrgId() || !payableDetailPOS.get(0).getRecOrgId().equals(payableDetailPO.getRecOrgId())) {
                throw new PfscExtBusinessException("18000", "\u5408\u5e76\u652f\u4ed8\u5fc5\u987b\u6536\u6b3e\u65b9\u76f8\u540c");
            }
            if (null == payableDetailPO.getPaidDate() || payableDetailPO.getPaidDate().after(new Date()) != payableDetailPOS.get(0).getPaidDate().after(new Date())) {
                throw new PfscExtBusinessException("18000", "\u5df2\u8fc7\u671f\u5e94\u4ed8\u5355\u4e0d\u53ef\u4ee5\u4e8e\u672a\u5230\u671f\u5e94\u4ed8\u5355\u5408\u5e76\u652f\u4ed8");
            }
            if (!PayableStatus.PENDING.getCode().equals(payableDetailPO.getPayableStatus())) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u72b6\u6001\u4e0d\u662f\u5f85\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u53d1\u8d77\u4ed8\u6b3e");
            }
            if (null == payableDetailPO.getPayableAmt() || payableDetailPO.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            if (null != payableDetailPO.getPendingAmt() && payableDetailPO.getPendingAmt().compareTo(BigDecimal.ZERO) > 0) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u3010" + payableDetailPO.getPayableNo() + "\u3011\u5904\u4e8e\u4ed8\u6b3e\u4e2d\uff0c\u8bf7\u5f85\u4ed8\u6b3e\u5b8c\u6210\u518d\u8fdb\u884c\u64cd\u4f5c");
            }
            payableAmtSum = payableAmtSum.add(payableDetailPO.getPayableAmt());
            if (payableDetailPO.getOverduePenalty().compareTo(BigDecimal.ZERO) > 0 && (WAITAPPROVE.equals((Object)ApproveStatus.getInstance(payableDetailPO.getApproveStatus().toString())) || FAILUREAPPROVE.equals((Object)ApproveStatus.getInstance(payableDetailPO.getApproveStatus().toString())))) {
                payableDetailPO.setPayableAmt(payableDetailPO.getPayableAmt().add(payableDetailPO.getOverduePenalty()));
            }
            liquidatedAmt = liquidatedAmt.add(null != payableDetailPO.getOverduePenalty() ? payableDetailPO.getOverduePenalty() : BigDecimal.ZERO);
            payAmtSum = payAmtSum.add(payableDetailPO.getPayableAmt());
        }
        bigDecimals.add(payAmtSum);
        bigDecimals.add(payableAmtSum);
        bigDecimals.add(liquidatedAmt);
        return bigDecimals;
    }

    private void initParam(BusiApplyPayReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPayableNos()) || reqBO.getPayableNos().size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5e94\u4ed8\u5355\u53f7\u4e3a\u7a7a");
        }
    }
}

