/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscApprovePayApplyOrderService;
import com.tydic.pfscext.api.busi.bo.FscApprovePayApplyOrderReqBO;
import com.tydic.pfscext.api.busi.bo.FscApprovePayApplyOrderRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.ApproveResult;
import com.tydic.pfscext.enums.ApproveStatus;
import com.tydic.pfscext.enums.AuditObjType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscApprovePayApplyOrderService.class)
public class FscApprovePayApplyOrderServiceImpl
implements FscApprovePayApplyOrderService {
    private static final Logger logger = LoggerFactory.getLogger(FscApprovePayApplyOrderServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;

    public FscApprovePayApplyOrderRspBO dealApprove(FscApprovePayApplyOrderReqBO reqBO) {
        logger.debug("\u5165\u53c2\uff1a" + reqBO.toString());
        this.verification(reqBO);
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.getApprovalResult(reqBO);
        if (!"0000".equals(auditRspBO.getRespCode())) {
            logger.error("\u8c03\u7528\u5ba1\u6279\u5ba1\u6279\u4e2d\u5fc3\u51fa\u9519\uff1a" + auditRspBO.getRespDesc());
            throw new PfscExtBusinessException("18000", "\u8c03\u7528\u5ba1\u6279\u5ba1\u6279\u4e2d\u5fc3\u51fa\u9519");
        }
        try {
            UacNoneInstanceBO noneInstanceBO = auditRspBO.getNoneInstanceBO();
            if (noneInstanceBO.getStepId().equals(reqBO.getStepId())) {
                String auditResult = noneInstanceBO.getAuditResult();
                Boolean finish = noneInstanceBO.getFinish();
                if ("0".equals(auditResult) && finish.equals(Boolean.TRUE)) {
                    this.applyPayInfoMapper.updateByPayNo(noneInstanceBO.getStepId(), reqBO.getPayNo(), ApproveStatus.PLATFORM_APPROVED.getCode(), ApplyPayStatus.PENDING_PAYMENT.getCode());
                    this.applyDetailMapper.updateStatusByApplyNo(reqBO.getPayNo(), ApplyPayStatus.PENDING_PAYMENT.getCode());
                } else if ("0".equals(auditResult) && finish.equals(Boolean.FALSE)) {
                    this.applyPayInfoMapper.updateByPayNo(noneInstanceBO.getStepId(), reqBO.getPayNo(), ApproveStatus.PLATFORM_APPROVING.getCode(), ApplyPayStatus.APPROVING.getCode());
                } else {
                    this.applyPayInfoMapper.updateByPayNo(noneInstanceBO.getStepId(), reqBO.getPayNo(), ApproveStatus.APPROVAL_REJECTED.getCode(), ApplyPayStatus.FAILED.getCode());
                    this.applyDetailMapper.updateStatusByApplyNo(reqBO.getPayNo(), ApplyPayStatus.FAILED.getCode());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4ed8\u6b3e\u5355\u72b6\u6001\u5931\u8d25\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4ed8\u6b3e\u5355\u72b6\u6001\u5931\u8d25");
        }
        FscApprovePayApplyOrderRspBO rspBO = new FscApprovePayApplyOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return null;
    }

    private void verification(FscApprovePayApplyOrderReqBO reqBO) {
        if (reqBO == null) {
            logger.error("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayNo() == null || "".equals(reqBO.getPayNo())) {
            logger.error("\u4ed8\u6b3e\u5355\u53f7\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u5355\u53f7\u4e3a\u7a7a");
        }
        if (reqBO.getApproveResult() == null || "".equals(reqBO.getApproveResult())) {
            logger.error("\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a");
        }
        if (reqBO.getStepId() == null || "".equals(reqBO.getStepId())) {
            logger.error("\u5f53\u524d\u6b65\u9aa4id\u4e0d\u80fd\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u5f53\u524d\u6b65\u9aa4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscApprovePayApplyOrderReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(Long.valueOf(reqBO.getPayNo()));
        auditReqBO.setObjId(objIdList);
        auditReqBO.setStepId(reqBO.getStepId());
        Integer auditStatus = ApproveResult.AGREE.getCode().equals(reqBO.getApproveResult()) ? 0 : 1;
        auditReqBO.setAuditResult(auditStatus);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setObjType(AuditObjType.RECEIPT_APPROVE_TYPE.getObjType());
        return this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
    }
}

