/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.FscCancelPayApplyOrderService;
import com.tydic.pfscext.api.busi.bo.FscCancelPayApplyOrderReqBO;
import com.tydic.pfscext.api.busi.bo.FscCancelPayApplyOrderRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiDeleteApplyPayInfoService;
import com.tydic.pfscext.external.api.BusiQueryApplyPayInfoService;
import com.tydic.pfscext.external.api.bo.BusiApplyPayInfoSubmitRspBo;
import com.tydic.pfscext.external.api.bo.BusiQueryApplyPayInfoReqBo;
import com.tydic.pfscext.external.api.bo.BusiQueryApplyPayInfoRspBo;
import com.tydic.pfscext.external.service.impl.BusiDeleteApplyPayInfoServiceImpl;
import com.tydic.pfscext.external.service.impl.BusiQueryApplyPayInfoServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscCancelPayApplyOrderService.class)
public class FscCancelPayApplyOrderServiceImpl
implements FscCancelPayApplyOrderService {
    private static final Logger logger = LoggerFactory.getLogger(FscCancelPayApplyOrderServiceImpl.class);
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    private BusiDeleteApplyPayInfoService busiDeleteApplyPayInfoService = new BusiDeleteApplyPayInfoServiceImpl();
    private BusiQueryApplyPayInfoService busiQueryApplyPayInfoService = new BusiQueryApplyPayInfoServiceImpl();

    public FscCancelPayApplyOrderRspBO cancelPayOrder(FscCancelPayApplyOrderReqBO reqBO) {
        FscCancelPayApplyOrderRspBO rspBO = new FscCancelPayApplyOrderRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u4ed8\u6b3e\u7533\u8bf7\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List payNos = reqBO.getPayNos();
        if (payNos == null || payNos.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4ed8\u6b3e\u7533\u8bf7\u5355\u3010PayNos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean flag = false;
        ArrayList<String> payAbleNos = new ArrayList<String>();
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        for (String payNo : payNos) {
            ApplyPayInfoPO modelById = this.applyPayInfoMapper.getModelById(payNo);
            if (PayResultStatus.APPLYING.getCode().equals(modelById.getPayStatus())) {
                BusiQueryApplyPayInfoReqBo busiQueryApplyPayInfoReqBo = new BusiQueryApplyPayInfoReqBo();
                busiQueryApplyPayInfoReqBo.setTradeId(modelById.getTradeId());
                busiQueryApplyPayInfoReqBo.setPayerAcctId(null);
                BusiApplyPayInfoSubmitRspBo busiApplyPayInfoSubmitRspBo = this.busiDeleteApplyPayInfoService.deleteApplyPayInfo(busiQueryApplyPayInfoReqBo);
                String reqStr = JSON.toJSONString((Object)busiQueryApplyPayInfoReqBo);
                String rspStr = JSON.toJSONString((Object)busiApplyPayInfoSubmitRspBo);
                this.savelog("BusiDeleteApplyPayInfoService", reqStr, rspStr);
                BusiQueryApplyPayInfoReqBo busiQueryApplyPayInfoReqBo1 = new BusiQueryApplyPayInfoReqBo();
                BeanUtils.copyProperties((Object)busiQueryApplyPayInfoReqBo, (Object)busiQueryApplyPayInfoReqBo1);
                BusiQueryApplyPayInfoRspBo busiQueryApplyPayInfoRspBo = this.busiQueryApplyPayInfoService.queryApplyPayInfo(busiQueryApplyPayInfoReqBo1);
                String reqStrs = JSON.toJSONString((Object)busiQueryApplyPayInfoReqBo1);
                String rspStrs = JSON.toJSONString((Object)busiQueryApplyPayInfoRspBo);
                this.savelog("BusiQueryApplyPayInfoService", reqStrs, rspStrs);
                if (busiQueryApplyPayInfoRspBo.getSuccess().booleanValue() && "DELETED".equals(busiQueryApplyPayInfoRspBo.getStatus())) {
                    flag = true;
                }
            }
            String applyNo = payNo;
            List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(applyNo);
            for (ApplyDetail applyDetail : applyDetails) {
                String payableNo = applyDetail.getPayableNo();
                payAbleNos.add(payableNo);
            }
            payableDetailVO.setPayableNos(payAbleNos);
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(payableDetailVO);
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                if (payableDetailPO.getPayableStatus().equals(PayableStatus.PAYING.getCode())) {
                    PayableDetailPO payableDetailPO1 = new PayableDetailPO();
                    payableDetailPO1.setApplyNo(payableDetailPO.getPayableNo());
                    payableDetailPO1.setPayableStatus(PayableStatus.PENDING.getCode());
                    this.payableDetailMapper.updateById(payableDetailPO1);
                    ApplyDetail applyDetail = new ApplyDetail();
                    applyDetail.setApplyNo(payNo);
                    applyDetail.setStatus(ApplyPayStatus.CANCEL_ORDER_STATUS.getCode());
                    this.applyDetailMapper.updateByApplyNo(applyDetail);
                    ApplyPayInfoPO modelByIds = this.applyPayInfoMapper.getModelById(payNo);
                    if (!ApplyPayStatus.APPLYING.getCode().equals(modelByIds.getPayStatus())) {
                        throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u72b6\u6001\u5fc5\u987b\u4e3a\u4ed8\u6b3e\u4e2d");
                    }
                    ApplyPayInfoPO applyPayInfoPo = new ApplyPayInfoPO();
                    applyPayInfoPo.setPayno(payNo);
                    applyPayInfoPo.setCancelMsg(reqBO.getCancelMsg());
                    applyPayInfoPo.setPayStatus(ApplyPayStatus.CANCEL_ORDER_STATUS.getCode());
                    int i = this.applyPayInfoMapper.updateStatus(applyPayInfoPo);
                    if (i <= 0 || !flag.booleanValue()) continue;
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    continue;
                }
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u72b6\u6001\u5fc5\u987b\u4e3a\u4ed8\u6b3e\u4e2d");
            }
        }
        return rspBO;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

