/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.tydic.pfscext.api.busi.FscCreateDoubleLinkApplyService;
import com.tydic.pfscext.api.busi.FscPayApplyOrderSubmitService;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderSubmitReqBo;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderSubmitRspBo;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayApplyOrderSubmitService.class)
public class FscPayApplyOrderSubmitServiceImpl
implements FscPayApplyOrderSubmitService {
    private static final Logger logger = LoggerFactory.getLogger(FscPayApplyOrderSubmitServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FscCreateDoubleLinkApplyService fscCreateDoubleLinkApplyService;

    public FscPayApplyOrderSubmitRspBo submit(FscPayApplyOrderSubmitReqBo reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u4e2d\u5fc3\u4ed8\u6b3e\u5355\u4ed8\u6b3e \u5165\u53c2\uff1a" + JSON.toString((Object)reqBo));
        }
        this.initParam(reqBo);
        this.updateApplyPayInfo(reqBo);
        FscPayApplyOrderSubmitRspBo rspBo = new FscPayApplyOrderSubmitRspBo();
        return rspBo;
    }

    private void updateServiceFeePayableStatus(List<PayableDetailPO> payableDetailPOS) {
        if (payableDetailPOS != null && payableDetailPOS.size() > 0) {
            ArrayList<String> payableNos = new ArrayList<String>();
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                payableNos.add(payableDetailPO.getPayableNo());
            }
            int i = this.payableDetailMapper.updateStatusByNos(payableNos, "05");
            if (i != 1) {
                throw new PfscExternalBusinessException("18000", "\u66f4\u65b0\u6210\u4ea4\u670d\u52a1\u8d39\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25");
            }
        }
    }

    private void updateApplyPayInfo(FscPayApplyOrderSubmitReqBo reqBo) {
        String payno = reqBo.getPayno();
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayno(payno);
        String payStatus = ApplyPayStatus.APPLYING.getCode();
        applyPayInfoPO.setPayStatus(payStatus);
        this.applyPayInfoMapper.updateStatuses(applyPayInfoPO);
        this.fscCreateDoubleLinkApplyService.createDoubleLinkApplyOrder(reqBo);
    }

    private void initParam(FscPayApplyOrderSubmitReqBo reqBo) {
        if (null == reqBo) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayno()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4ed8\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayType()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

