/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.FscQueryPayableWithPayItemService;
import com.tydic.pfscext.api.busi.bo.QueryPayableWithPayItemReqBo;
import com.tydic.pfscext.api.busi.bo.QueryPayableWithPayItemRspBo;
import com.tydic.pfscext.api.deal.bo.PayItemInfoBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscQueryPayableWithPayItemService.class)
public class FscQueryPayableWithPayItemServiceImpl
implements FscQueryPayableWithPayItemService {
    private static final Logger logger = LoggerFactory.getLogger(FscQueryPayableWithPayItemServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    public PfscExtRspPageBaseBO<QueryPayableWithPayItemRspBo> queryPayableWithPayItemListPage(QueryPayableWithPayItemReqBo reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5e94\u4ed8\u5355\u53ca\u5176\u652f\u4ed8\u5546\u54c1\u660e\u7ec6\u5165\u53c2\uff1a" + reqBo.toString());
        }
        if ("1".equals(reqBo.getIsProfessionalOrgExt())) {
            reqBo.setPurchaseNo(reqBo.getCompanyId());
        }
        if ("2".equals(reqBo.getIsProfessionalOrgExt())) {
            reqBo.setSupplierId(reqBo.getSupId());
        }
        PfscExtRspPageBaseBO rspBo = new PfscExtRspPageBaseBO();
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBo.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBo.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBo.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBo.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBo.getSortName() + " " + reqBo.getSortOrder();
        } else {
            orderBy = " CREATE_DATE desc";
        }
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List<PayableDetailPO> payableDetailListPageByTerms = this.payableDetailMapper.getPayableDetailListPageByTerms(reqBo, (Page<Map<String, Object>>)page, orderBy);
        ArrayList<Long> orderIds = new ArrayList<Long>();
        ArrayList<QueryPayableWithPayItemRspBo> rspRows = new ArrayList<QueryPayableWithPayItemRspBo>();
        for (PayableDetailPO payableDetailPO : payableDetailListPageByTerms) {
            if (payableDetailPO.getOrderId() != null) {
                orderIds.add(payableDetailPO.getOrderId());
            }
            QueryPayableWithPayItemRspBo rspRow = new QueryPayableWithPayItemRspBo();
            BeanUtils.copyProperties((Object)payableDetailPO, (Object)rspRow);
            logger.debug("getPayableStatus\uff1a" + payableDetailPO.getPayableStatus());
            PayableStatus payableEnum = PayableStatus.getInstance(payableDetailPO.getPayableStatus());
            rspRow.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
            String supplierStr = this.organizationInfoService.querySupplierName(rspRow.getSupplierId());
            rspRow.setSupplierName(supplierStr);
            BigDecimal unpaidAmt = new BigDecimal(0);
            unpaidAmt = payableDetailPO.getPayableAmt().subtract(payableDetailPO.getPaidAmt());
            rspRow.setUnpaidAmt(unpaidAmt);
            rspRows.add(rspRow);
        }
        List<QueryPayableWithPayItemRspBo> queryPayableWithPayItemRspBos = this.qryPayItemInfo(orderIds, rspRows);
        rspBo.setRows(queryPayableWithPayItemRspBos);
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBo;
    }

    public List<QueryPayableWithPayItemRspBo> qryPayItemInfo(List<Long> orderIds, List<QueryPayableWithPayItemRspBo> rspRows) {
        List<PayItemInfo> payItemInfos = this.payItemInfoMapper.selectListByOrderIdList(orderIds);
        for (QueryPayableWithPayItemRspBo queryPayableWithPayItemRspBo : rspRows) {
            ArrayList<PayItemInfoBO> payItemInfoBOS = new ArrayList<PayItemInfoBO>();
            BigDecimal commDealServiceFee = new BigDecimal(0);
            for (PayItemInfo payItemInfo : payItemInfos) {
                PayItemInfoBO payItemInfoBO = new PayItemInfoBO();
                if (!payItemInfo.getOrderId().equals(queryPayableWithPayItemRspBo.getOrderId())) continue;
                BeanUtils.copyProperties((Object)payItemInfo, (Object)payItemInfoBO);
                BigDecimal commDealServiceFeeRate = payItemInfoBO.getCommDealServiceFeeRate();
                commDealServiceFee = commDealServiceFeeRate.multiply(payItemInfoBO.getAmount());
                payItemInfoBO.setCommDealServiceFee(commDealServiceFee);
                payItemInfoBOS.add(payItemInfoBO);
            }
            queryPayableWithPayItemRspBo.setPayItemInfoBOS(payItemInfoBOS);
        }
        return rspRows;
    }
}

