/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.task.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.FscUpdatePaidResultService;
import com.tydic.pfscext.api.busi.bo.FscSupplierNotificationInvoiceResultAbilityReqBO;
import com.tydic.pfscext.api.busi.bo.FscSupplierNotificationInvoiceResultAbilityRspBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.external.api.BusiQueryApplyPayInfoService;
import com.tydic.pfscext.external.api.bo.BusiQueryApplyPayInfoReqBo;
import com.tydic.pfscext.external.api.bo.BusiQueryApplyPayInfoRspBo;
import com.tydic.pfscext.external.service.impl.BusiQueryApplyPayInfoServiceImpl;
import com.tydic.pfscext.service.busi.impl.FscUpdatePaidResultServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;

public class FscUpdatePaidResultTaskServiceimpl
implements FscUpdatePaidResultService {
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscUpdatePaidResultServiceImpl fscUpdatePaidResultService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    private BusiQueryApplyPayInfoService busiQueryApplyPayInfoService = new BusiQueryApplyPayInfoServiceImpl();

    public FscSupplierNotificationInvoiceResultAbilityRspBO dealResult(FscSupplierNotificationInvoiceResultAbilityReqBO reqBO) {
        ApplyPayInfoPO applyPayInfoPO1 = new ApplyPayInfoPO();
        applyPayInfoPO1.setPayStatus(PayResultStatus.APPLYING.getCode());
        List<ApplyPayInfoPO> ApplyPayInfoPOs = this.applyPayInfoMapper.getList(applyPayInfoPO1);
        BusiQueryApplyPayInfoRspBo busiQueryApplyPayInfoRspBo = null;
        if (!CollectionUtils.isEmpty(ApplyPayInfoPOs) && ApplyPayInfoPOs.size() > 0) {
            for (ApplyPayInfoPO applyPayInfoPo : ApplyPayInfoPOs) {
                String tradeId = applyPayInfoPo.getTradeId();
                String signData = applyPayInfoPo.getSignData();
                BusiQueryApplyPayInfoReqBo busiQueryApplyPayInfoReqBo = new BusiQueryApplyPayInfoReqBo();
                busiQueryApplyPayInfoReqBo.setTradeId(tradeId);
                busiQueryApplyPayInfoReqBo.setPayerAcctId(null);
                busiQueryApplyPayInfoRspBo = this.busiQueryApplyPayInfoService.queryApplyPayInfo(busiQueryApplyPayInfoReqBo);
                String reqStr = JSON.toJSONString((Object)busiQueryApplyPayInfoReqBo);
                String rspStr = JSON.toJSONString((Object)busiQueryApplyPayInfoRspBo);
                this.savelog("BusiQueryApplyPayInfoService", reqStr, rspStr);
                if (!busiQueryApplyPayInfoRspBo.getStatus().equals("success")) continue;
                this.fscUpdatePaidResultService.dealResult(applyPayInfoPo);
            }
        }
        FscSupplierNotificationInvoiceResultAbilityRspBO fscSupplierNotificationInvoiceResultAbilityRspBO = new FscSupplierNotificationInvoiceResultAbilityRspBO();
        return fscSupplierNotificationInvoiceResultAbilityRspBO;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

