/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.BusiBalanceSubmitService;
import com.tydic.pfscext.api.busi.FscPayableOrderCreateService;
import com.tydic.pfscext.api.busi.bo.BalanceSubmitReqBo;
import com.tydic.pfscext.api.busi.bo.BalanceSubmitRspBo;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderCreateReqBO;
import com.tydic.pfscext.dao.BalanceChngLogMapper;
import com.tydic.pfscext.dao.BalanceMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.Balance;
import com.tydic.pfscext.dao.po.BalanceChngLog;
import com.tydic.pfscext.dao.po.BalanceChngLogPo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.ItemType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiBalanceSubmitService.class)
public class BusiBalanceSubmitServiceImpl
implements BusiBalanceSubmitService {
    private static final Logger logger = LoggerFactory.getLogger(BusiBalanceSubmitServiceImpl.class);
    @Autowired
    private BalanceMapper balanceMapper;
    @Autowired
    private FscPayableOrderCreateService fscPayableOrderCreateService;
    @Autowired
    private BalanceChngLogMapper balanceChngLogMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Value(value="${OPE_ID}")
    private Long OPE_ID;

    public BalanceSubmitRspBo balanceSubmit(BalanceSubmitReqBo reqBo) {
        Balance balance;
        if (ItemType.DEPOSIT.getCode().equals(reqBo.getItemType())) {
            balance = new Balance();
            balance.setObjId(reqBo.getSupId());
            balance.setObjType("00");
            Balance balance1 = this.balanceMapper.selectByBalance(balance);
            BalanceChngLog record = new BalanceChngLog();
            if (balance1 == null) {
                Balance balance2 = new Balance();
                balance2.setBalanceId(Sequence.getInstance().nextId());
                balance2.setObjId(reqBo.getSupId());
                balance2.setObjType("00");
                balance2.setBalanceType("00");
                balance2.setBalance(reqBo.getItemAmt());
                balance2.setUsedAmt(BigDecimal.ZERO);
                balance2.setAvailableBalance(BigDecimal.ZERO);
                balance2.setLockBalance(BigDecimal.ZERO);
                balance2.setCreateTime(new Date());
                balance2.setCreatorId(reqBo.getPayId());
                balance2.setUpdateTime(new Date());
                balance2.setUpdatorId(reqBo.getPayId());
                record.setBalanceId(balance2.getBalanceId());
                this.balanceMapper.insert(balance2);
            } else {
                record.setBalanceId(balance1.getBalanceId());
            }
            BigDecimal balances = BigDecimal.ZERO;
            balances = balance1.getBalance().add(reqBo.getItemAmt());
            BigDecimal twoHundredThousand = new BigDecimal("200000");
            if (balances.compareTo(twoHundredThousand) == 1) {
                throw new PfscExtBusinessException("18001", "\u4fdd\u8bc1\u91d1\u603b\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u4e8c\u5341\u4e07\u5143\uff0c\u8bf7\u786e\u8ba4\u7533\u8bf7\u7f34\u7eb3\u91d1\u989d");
            }
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableType(14);
            payableDetailPO.setPayOrgId(reqBo.getSupId());
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getList(payableDetailPO);
            BigDecimal allBalance = balance1.getBalance();
            for (PayableDetailPO payableDetailPO1 : payableDetailPOS) {
                allBalance = allBalance.add(payableDetailPO1.getPayableAmt());
            }
            if (allBalance.compareTo(twoHundredThousand) == 1) {
                throw new PfscExtBusinessException("18001", "\u5c1a\u6709\u672a\u4ed8\u6b3e\u5b8c\u6210\u7684\u7f34\u7eb3\u4fdd\u8bc1\u91d1\uff0c\u4e14\u603b\u989d\u5927\u4e8e\u4e8c\u5341\u4e07");
            }
            FscPayableOrderCreateReqBO fscPayableOrderCreateReqBO = new FscPayableOrderCreateReqBO();
            fscPayableOrderCreateReqBO.setSupplierId(reqBo.getSupId());
            fscPayableOrderCreateReqBO.setRecOrgId(reqBo.getSupId());
            fscPayableOrderCreateReqBO.setPayableAmt(reqBo.getItemAmt());
            fscPayableOrderCreateReqBO.setPayableType("14");
            this.fscPayableOrderCreateService.createPayableOrder(fscPayableOrderCreateReqBO);
            long l = Sequence.getInstance().nextId();
            String billNo = new Long(l).toString();
            record.setBillNo(billNo);
            record.setLogId(Sequence.getInstance().nextId());
            BeanUtils.copyProperties((Object)reqBo, (Object)record);
            record.setRecId(this.OPE_ID);
            record.setPayId(reqBo.getSupId());
            this.balanceChngLogMapper.insert(record);
        } else if (ItemType.REFUND_OF_DEPOSIT.getCode().equals(reqBo.getItemType())) {
            if (reqBo.getReturnAmtStatus().equals("1")) {
                balance = new Balance();
                balance.setObjId(reqBo.getSupId());
                balance.setObjType("00");
                Balance balance1 = this.balanceMapper.selectByBalance(balance);
                if (balance1 == null) {
                    throw new PfscExtBusinessException("18001", "\u8d44\u91d1\u6c60\u4e0d\u5b58\u5728");
                }
                FscPayableOrderCreateReqBO fscPayableOrderCreateReqBO = new FscPayableOrderCreateReqBO();
                fscPayableOrderCreateReqBO.setSupplierId(reqBo.getSupId());
                fscPayableOrderCreateReqBO.setRecOrgId(reqBo.getSupId());
                fscPayableOrderCreateReqBO.setPayableAmt(balance1.getBalance());
                fscPayableOrderCreateReqBO.setBondAmt(reqBo.getCurrentBalance());
                fscPayableOrderCreateReqBO.setPayableType("24");
                this.fscPayableOrderCreateService.createPayableOrder(fscPayableOrderCreateReqBO);
                BalanceChngLog record = new BalanceChngLog();
                long l = Sequence.getInstance().nextId();
                String billNo = new Long(l).toString();
                record.setBillNo(billNo);
                record.setLogId(Sequence.getInstance().nextId());
                BeanUtils.copyProperties((Object)reqBo, (Object)record);
                record.setRecId(reqBo.getSupId());
                record.setPayId(this.OPE_ID);
                this.balanceChngLogMapper.insert(record);
            } else {
                FscPayableOrderCreateReqBO fscPayableOrderCreateReqBO = new FscPayableOrderCreateReqBO();
                fscPayableOrderCreateReqBO.setSupplierId(reqBo.getSupId());
                fscPayableOrderCreateReqBO.setRecOrgId(reqBo.getSupId());
                fscPayableOrderCreateReqBO.setPayableAmt(reqBo.getItemAmt());
                fscPayableOrderCreateReqBO.setBondAmt(reqBo.getCurrentBalance());
                fscPayableOrderCreateReqBO.setPayableType("24");
                this.fscPayableOrderCreateService.createPayableOrder(fscPayableOrderCreateReqBO);
                BalanceChngLog record = new BalanceChngLog();
                long l = Sequence.getInstance().nextId();
                String billNo = new Long(l).toString();
                record.setBillNo(billNo);
                record.setLogId(Sequence.getInstance().nextId());
                BeanUtils.copyProperties((Object)reqBo, (Object)record);
                this.balanceChngLogMapper.insert(record);
            }
        } else if (ItemType.PROJECT_QUOTA_OCCUPATION.getCode().equals(reqBo.getItemType())) {
            BalanceChngLog balanceChngLog = new BalanceChngLog();
            BeanUtils.copyProperties((Object)reqBo, (Object)balanceChngLog);
            Long payId = reqBo.getPayId();
            Balance balance2 = new Balance();
            balance2.setObjId(payId);
            Balance balance1 = this.balanceMapper.selectByBalance(balance2);
            if (null == balance1) {
                throw new PfscExtBusinessException("18001", "\u5f53\u524d\u7528\u6237\u4fdd\u8bc1\u91d1\u6c60\u4e0d\u5b58\u5728");
            }
            BigDecimal afterBalance = BigDecimal.ZERO;
            BigDecimal balance22 = balance1.getBalance();
            if (balance22.compareTo(reqBo.getItemAmt()) == 1) {
                afterBalance = balance22.subtract(reqBo.getItemAmt());
                balance1.setBalance(afterBalance);
                balance1.setLockBalance(reqBo.getItemAmt());
                int i = this.balanceMapper.updateByPrimaryKeySelective(balance1);
                if (i != 1) {
                    throw new PfscExtBusinessException("18001", "\u5bfb\u6e90\u9879\u76ee\u51bb\u7ed3\u8d44\u91d1\u5931\u8d25");
                }
            } else {
                throw new PfscExtBusinessException("18001", "\u6263\u9664\u5bfb\u6e90\u9879\u76ee\u8d44\u91d1\u4e0d\u8db3");
            }
            balanceChngLog.setBalanceId(balance1.getBalanceId());
            balanceChngLog.setChngType("2");
            balanceChngLog.setCreateTime(new Date());
            balanceChngLog.setLogId(Sequence.getInstance().nextId());
            balanceChngLog.setCreatorId(reqBo.getCompanyId());
            this.balanceChngLogMapper.insert(balanceChngLog);
        } else {
            throw new PfscExtBusinessException("18001", "\u9879\u76ee\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        BalanceSubmitRspBo balanceSubmitRspBo = new BalanceSubmitRspBo();
        return balanceSubmitRspBo;
    }

    private void initParam(BalanceSubmitReqBo reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7f34\u7eb3\u4fdd\u8bc1\u91d1\u63d0\u4ea4\u5165\u53c2\uff1a" + reqBo.toString());
        }
        if (ItemType.DEPOSIT.getCode().equals(reqBo.getItemType()) && reqBo.getSupId() == null) {
            throw new PfscExtBusinessException("18001", "\u975e\u4f9b\u5e94\u5546\u4e0d\u80fd\u5145\u503c");
        }
        if (ItemType.REFUND_OF_DEPOSIT.getCode().equals(reqBo.getItemType())) {
            PayableDetailVO payableDetailVO = new PayableDetailVO();
            payableDetailVO.setPayableType(11);
            payableDetailVO.setPayableStatus("01");
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(payableDetailVO);
            PayableDetailVO payableDetailVO1 = new PayableDetailVO();
            ArrayList<Integer> payableTypes = new ArrayList<Integer>();
            payableTypes.add(13);
            payableTypes.add(23);
            payableDetailVO1.setPayableTypes(payableTypes);
            payableDetailVO1.setPayableStatus("01");
            List<PayableDetailPO> payableDetailPOS1 = this.payableDetailMapper.selectList(payableDetailVO1);
            if (payableDetailPOS1 != null && payableDetailPOS != null) {
                throw new PfscExtBusinessException("18001", "\u6709\u5c1a\u672a\u6e05\u5206\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u6216\u672a\u7f34\u7eb3\u7684\u7f5a\u6b3e\uff0c\u8bf7\u786e\u8ba4\u7533\u8bf7\u9000\u8fd8\u91d1\u989d\uff01");
            }
            BalanceChngLogPo balanceChngLogPo1 = new BalanceChngLogPo();
            balanceChngLogPo1.setSupId(reqBo.getSupId());
            balanceChngLogPo1.setProjectFlag("2");
            List<BalanceChngLog> listByTerms1 = this.balanceMapper.getListByTerms(balanceChngLogPo1);
            if (listByTerms1 != null) {
                throw new PfscExtBusinessException("18001", "\u60a8\u6709\u8fdb\u884c\u4e2d\u7684\u5bfb\u6e90\u9879\u76ee\uff0c\u8bf7\u786e\u8ba4\u7533\u8bf7\u9000\u8fd8\u91d1\u989d\uff01");
            }
            BalanceChngLogPo balanceChngLogPo = new BalanceChngLogPo();
            balanceChngLogPo.setSupId(reqBo.getSupId());
            balanceChngLogPo.setItemType("06");
            balanceChngLogPo.setProjectFlag("2");
            List<BalanceChngLog> listByTerms = this.balanceMapper.getListByTerms(balanceChngLogPo);
            if (listByTerms != null) {
                throw new PfscExtBusinessException("18001", "\u60a8\u6709\u5c65\u7ea6\u4e2d\u7684\u5408\u540c\u6216\u8ba2\u5355\uff0c\u8bf7\u5c65\u7ea6\u5b8c\u6210\u540e\u7533\u8bf7\u9000\u8fd8\u4fdd\u8bc1\u91d1\uff01");
            }
        }
    }
}

