/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryReceiptInfoListByEntryNoService;
import com.tydic.pfscext.api.busi.bo.BusiQryReceiptInfoListByEntryNoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryReceiptInfoListByEntryNoRspBO;
import com.tydic.pfscext.api.busi.bo.ReceiptInfoBO;
import com.tydic.pfscext.dao.EntryInfoMapper;
import com.tydic.pfscext.dao.ReceiptInfoMapper;
import com.tydic.pfscext.dao.po.EntryInfoPO;
import com.tydic.pfscext.dao.po.ReceiptInfoPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiQryReceiptInfoListByEntryNoService.class)
public class BusiQryReceiptInfoListByEntryNoServiceImpl
implements BusiQryReceiptInfoListByEntryNoService {
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public BusiQryReceiptInfoListByEntryNoRspBO qryReceiptInfoListByEntryNo(BusiQryReceiptInfoListByEntryNoReqBO reqBO) {
        if (reqBO.getEntryNo() == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5165\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BusiQryReceiptInfoListByEntryNoRspBO rspBO = new BusiQryReceiptInfoListByEntryNoRspBO();
        EntryInfoPO entryInfoPO = this.entryInfoMapper.getModelById(reqBO.getEntryNo());
        if (entryInfoPO != null) {
            BeanUtils.copyProperties((Object)entryInfoPO, (Object)rspBO);
        }
        List<Object> rtList = new ArrayList();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
        receiptInfoPO.setEntryNo(reqBO.getEntryNo());
        List<ReceiptInfoPO> listPO = null;
        try {
            listPO = this.receiptInfoMapper.getListPage(receiptInfoPO, (Page<Map<String, Object>>)page, "t.ENTRY_DATE");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("\u5931\u8d25", e.getMessage());
        }
        if (!CollectionUtils.isEmpty(listPO)) {
            rtList = listPO.stream().map(detail -> {
                ReceiptInfoBO receiptInfoBO = new ReceiptInfoBO();
                BeanUtils.copyProperties((Object)detail, (Object)receiptInfoBO);
                receiptInfoBO.setQuantity(detail.getQuantity().intValue());
                return receiptInfoBO;
            }).collect(Collectors.toList());
        }
        String purchaseName = this.organizationInfoService.querySupplierName(entryInfoPO.getPurchaseId());
        rspBO.setPurchaseName(purchaseName);
        rspBO.setRows(rtList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

