/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiUpdatePayConfigUsedQuotaService;
import com.tydic.pfscext.api.busi.bo.UpdatePayConfigUsedQuotaFscReqBo;
import com.tydic.pfscext.api.busi.bo.UpdatePayConfigUsedQuotaFscRspBo;
import com.tydic.pfscext.api.busi.bo.UpdatePayConfigUsedQuotaInfoBo;
import com.tydic.pfscext.dao.PayConfigMapper;
import com.tydic.pfscext.dao.PayTypeConfigMapper;
import com.tydic.pfscext.dao.po.PayConfig;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiUpdatePayConfigUsedQuotaService.class)
public class BusiUpdatePayConfigUsedQuotaServiceImpl
implements BusiUpdatePayConfigUsedQuotaService {
    private static final Logger log = LoggerFactory.getLogger(BusiUpdatePayConfigUsedQuotaServiceImpl.class);
    @Autowired
    private PayConfigMapper payConfigMapper;
    @Autowired
    private PayTypeConfigMapper payTypeConfigMapper;

    public UpdatePayConfigUsedQuotaFscRspBo updatePayConfigUsedQuota(UpdatePayConfigUsedQuotaFscReqBo updatePayConfigFscReqBo) {
        UpdatePayConfigUsedQuotaFscRspBo rspBo = new UpdatePayConfigUsedQuotaFscRspBo();
        String validateArgsResult = this.validateArgs(updatePayConfigFscReqBo);
        if (!StringUtils.isEmpty((Object)validateArgsResult)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(validateArgsResult);
            throw new PfscExtBusinessException("18000", validateArgsResult);
        }
        for (UpdatePayConfigUsedQuotaInfoBo quotaInfoBo : updatePayConfigFscReqBo.getUsedQuotaInfoBos()) {
            Long supplierId = quotaInfoBo.getSupplierId();
            BigDecimal useQuota = quotaInfoBo.getUseQuota();
            PayConfig payConfigCondition = new PayConfig();
            payConfigCondition.setExceptName(updatePayConfigFscReqBo.getOrgName());
            payConfigCondition.setSupplierId(supplierId);
            PayConfig payConfig = this.payConfigMapper.selectByPrimary(payConfigCondition);
            if (payConfig == null) {
                log.debug("\u4f9b\u5e94\u5546id\uff1a{} \u5bf9\u5e94\u8bbe\u7f6e\u4e0d\u5b58\u5728", (Object)supplierId);
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u4f9b\u5e94\u5546\uff1a" + supplierId + " \u672a\u7ed9\u91c7\u8d2d\u5355\u4f4d\u914d\u7f6e\u652f\u4ed8\u53c2\u6570");
                throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546\uff1a" + supplierId + " \u672a\u7ed9\u91c7\u8d2d\u5355\u4f4d\u914d\u7f6e\u652f\u4ed8\u53c2\u6570");
            }
            int useCompareBalance = payConfig.getBalance().compareTo(useQuota);
            if (useCompareBalance < 0) {
                log.debug("\u652f\u4ed8\u914d\u7f6e\uff1a{} \u53ef\u900f\u652f\u4f59\u989d\u4e0d\u8db3\uff01", (Object)payConfig.getPayConfigId());
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u91c7\u8d2d\u5355\u4f4d\u5728\u4f9b\u5e94\u5546\uff1a" + supplierId + " \u53ef\u900f\u652f\u4f59\u989d\u4e0d\u8db3");
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u5728\u4f9b\u5e94\u5546\uff1a" + supplierId + " \u53ef\u900f\u652f\u4f59\u989d\u4e0d\u8db3");
            }
            BigDecimal usedQuota = payConfig.getUsedQuota().add(useQuota);
            payConfig.setUsedQuota(usedQuota);
            BigDecimal balance = payConfig.getOverdraftQuota().subtract(usedQuota);
            payConfig.setBalance(balance);
            int i = this.payConfigMapper.updateByPrimaryKeySelective(payConfig);
            if (i == 1) continue;
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u652f\u4ed8\u914d\u7f6e\uff1a" + payConfig.getPayConfigId() + "\u66f4\u65b0\u5931\u8d25\uff01");
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u914d\u7f6e\uff1a" + payConfig.getPayConfigId() + "\u66f4\u65b0\u5931\u8d25\uff01");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u4fdd\u5b58\u6210\u529f");
        return rspBo;
    }

    private String validateArgs(UpdatePayConfigUsedQuotaFscReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2'reqBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUsedQuotaInfoBos())) {
            return "\u5165\u53c2'reqBo'\u4e2d\u5c5e\u6027'usedQuotaInfoBos'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (UpdatePayConfigUsedQuotaInfoBo quotaInfoBo : reqBo.getUsedQuotaInfoBos()) {
            if (quotaInfoBo.getSupplierId() == null) {
                return "\u5165\u53c2'reqBo'\u4e2d\u5c5e\u6027'usedQuotaInfoBos'\u7684'supplierId'\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (BigDecimal.ZERO.compareTo(quotaInfoBo.getUseQuota()) < 0) continue;
            return "\u5165\u53c2'reqBo'\u4e2d\u5c5e\u6027'usedQuotaInfoBos'\u7684'useQuota'\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0";
        }
        return null;
    }
}

