/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.FscApplyPayOrderCreateService;
import com.tydic.pfscext.api.busi.bo.FscApplyPayOrderCreateBO;
import com.tydic.pfscext.api.busi.bo.FscApplyPayOrderCreateReqBO;
import com.tydic.pfscext.api.busi.bo.FscApplyPayOrderCreateRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.ApproveStatus;
import com.tydic.pfscext.enums.AuditObjType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscApplyPayOrderCreateService.class)
public class FscApplyPayOrderCreateServiceImpl
implements FscApplyPayOrderCreateService {
    private static final Logger logger = LoggerFactory.getLogger(FscApplyPayOrderCreateServiceImpl.class);
    private final String PAYNO_PREFIX = "FKDH";
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String CALL_PRC_SYS_CODE;
    private static final String APPROVAL_KEY = "FKSQSP";

    public FscApplyPayOrderCreateRspBO createPayApplyOrder(FscApplyPayOrderCreateReqBO reqBO) {
        List filterByStatus;
        int i;
        logger.debug("\u521b\u5efa\u4ed8\u6b3e\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        this.verification(reqBO);
        Date now = new Date();
        FscApplyPayOrderCreateRspBO rspBO = new FscApplyPayOrderCreateRspBO();
        List fscApplyPayOrderCreateBOList = reqBO.getFscApplyPayOrderCreateBOList();
        List<String> payableNOList = fscApplyPayOrderCreateBOList.stream().map(FscApplyPayOrderCreateBO::getPayableNo).collect(Collectors.toList());
        Map<String, BigDecimal> payAmtMap = fscApplyPayOrderCreateBOList.stream().collect(Collectors.toMap(FscApplyPayOrderCreateBO::getPayableNo, FscApplyPayOrderCreateBO::getPayAmt));
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectListByNos(payableNOList);
        for (i = 0; i < payableDetailPOS.size(); ++i) {
            BigDecimal payAmt = payAmtMap.get(payableDetailPOS.get(i).getPayableNo());
            BigDecimal payableAmt = payableDetailPOS.get(i).getPayableAmt();
            BigDecimal pendingAmt = payableDetailPOS.get(i).getPendingAmt();
            BigDecimal paidAmt = payableDetailPOS.get(i).getPaidAmt();
            BigDecimal allTotolsPayAmt = BigDecimal.ZERO;
            if (payableAmt.compareTo(allTotolsPayAmt = allTotolsPayAmt.add(payAmt).add(pendingAmt).add(paidAmt)) == -1) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u8d85\u8fc7\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u91d1\u989d");
            }
            if (payableAmt.compareTo(allTotolsPayAmt) == 0) {
                pendingAmt = pendingAmt.add(payAmt);
                payableDetailPOS.get(i).setPendingAmt(pendingAmt);
                payableDetailPOS.get(i).setPayableStatus(PayableStatus.PAYINGS.getCode());
                continue;
            }
            pendingAmt = pendingAmt.add(payAmt);
            payableDetailPOS.get(i).setPendingAmt(pendingAmt);
            payableDetailPOS.get(i).setPayableStatus(PayableStatus.PAYINGS.getCode());
        }
        i = this.payableDetailMapper.updateList(payableDetailPOS);
        if (i != 1) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u4fe1\u606f\u4fee\u6539 \u5931\u8d25");
        }
        List<PayableDetailPO> payableDetailPOList = this.payableDetailMapper.getListByIds(payableNOList);
        logger.debug("\u5e94\u4ed8\u5355\u53f7\u8be6\u60c5:" + payableDetailPOList.toString());
        if (payableDetailPOList.size() == 0) {
            logger.error("\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
            throw new PfscExtBusinessException("18000", "\u6240\u9009\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
        }
        Integer payableType = payableDetailPOList.get(0).getPayableType();
        List filterByPayableTypeList = payableDetailPOList.stream().filter(payableDetailPO -> payableDetailPO.getPayableType().equals(payableType)).collect(Collectors.toList());
        if (filterByPayableTypeList.size() != payableDetailPOList.size()) {
            logger.error("\u5e94\u4ed8\u7c7b\u578b\u4e0d\u4e00\u81f4");
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u4e00\u81f4");
        }
        if (payableType.equals(Integer.valueOf(PayableType.LAGGED.getCode())) && (filterByStatus = payableDetailPOList.stream().filter(payable -> payable.getPayableStatus().equals(PayableStatus.PENDING.getCode())).collect(Collectors.toList())).size() != payableDetailPOList.size()) {
            logger.error("\u5b58\u5728\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\u7684\u903e\u671f\u8fdd\u7ea6\u91d1");
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\u7684\u903e\u671f\u8fdd\u7ea6\u91d1");
        }
        Map<String, PayableDetailPO> payableDetailPOMap = payableDetailPOList.stream().collect(Collectors.toMap(PayableDetailPO::getPayableNo, PayableDetailPO2 -> PayableDetailPO2));
        BigDecimal payTotalAmt = BigDecimal.ZERO;
        for (BigDecimal bigDecimal : payAmtMap.values()) {
            logger.debug("==========================payTotalAmttest" + bigDecimal);
            if (!StringUtils.hasText((String)String.valueOf(bigDecimal))) continue;
            payTotalAmt = payTotalAmt.add(bigDecimal);
        }
        logger.debug("==========================payTotalAmt" + payTotalAmt);
        String payNO = this.getPayNO();
        Date maxDate = (Date)payableDetailPOList.stream().map(PayableDetailPO::getPaidDate).sorted().collect(Collectors.toList()).get(0);
        if (maxDate.getTime() > now.getTime()) {
            List overdueList = payableDetailPOList.stream().filter(payableDetailPO -> payableDetailPO.getPaidDate().getTime() > now.getTime()).collect(Collectors.toList());
            if (overdueList.size() == payableDetailPOList.size()) {
                maxDate = now;
            } else {
                logger.error("\u5e94\u4ed8\u5355\u4e2d\u5b58\u5728\u8d85\u671f\u8ba2\u5355");
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u8d85\u671f\u8ba2\u5355");
            }
        }
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayno(payNO);
        applyPayInfoPO.setPaidDate(maxDate);
        long approvalFlowCode = Sequence.getInstance().nextId();
        applyPayInfoPO.setApprovalFlowCode(approvalFlowCode);
        applyPayInfoPO.setRecOrgId(payableDetailPOList.get(0).getRecOrgId());
        applyPayInfoPO.setPayOrgId(payableDetailPOList.get(0).getPayOrgId());
        applyPayInfoPO.setPayAmt(payTotalAmt);
        applyPayInfoPO.setPayableAtm(payTotalAmt);
        applyPayInfoPO.setOperatorId(reqBO.getUserId());
        applyPayInfoPO.setSupplierId(payableDetailPOList.get(0).getSupplierId());
        applyPayInfoPO.setApplyDate(now);
        applyPayInfoPO.setSource(payableDetailPOList.get(0).getSource());
        if (reqBO.getApprovalType() == 1) {
            applyPayInfoPO.setApprovalType(1);
            applyPayInfoPO.setPayStatus(ApplyPayStatus.APPROVING.getCode());
            applyPayInfoPO.setApprovalStatus(ApproveStatus.OA_APPROVING.getCode());
            logger.debug("========================oa\u5ba1\u6279");
        } else if (reqBO.getApprovalType() == 0) {
            applyPayInfoPO.setApprovalType(0);
            if ("1".equals(reqBO.getApprovalFlow())) {
                logger.debug("========================\u5e73\u53f0\u5ba1\u6279");
                applyPayInfoPO.setPayStatus(ApplyPayStatus.APPROVING.getCode());
                applyPayInfoPO.setApprovalStatus(ApproveStatus.PLATFORM_APPROVING.getCode());
                UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.platformApproval(String.valueOf(approvalFlowCode), reqBO);
                if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                    throw new PfscExtBusinessException("18000", uacNoTaskAuditCreateRspBO.getRespDesc());
                }
                String stepId = uacNoTaskAuditCreateRspBO.getStepId();
                applyPayInfoPO.setStepId(stepId);
            } else {
                logger.debug("========================\u975e\u5e73\u53f0\u5ba1\u6279");
                if (String.valueOf(payableType).equals(PayableType.RETURN_MAERGIN.getCode())) {
                    applyPayInfoPO.setPayStatus(ApplyPayStatus.APPLYING.getCode());
                    applyPayInfoPO.setApprovalStatus(ApproveStatus.NO_APPROVAL.getCode());
                }
                applyPayInfoPO.setPayStatus(ApplyPayStatus.PENDING_PAYMENT.getCode());
                applyPayInfoPO.setApprovalStatus(ApproveStatus.NO_APPROVAL.getCode());
            }
        }
        ArrayList<ApplyDetail> applyDetailList = new ArrayList<ApplyDetail>();
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectByPayAbleNo(payableNOList);
        ArrayList applyDetailPayAbleNOList = new ArrayList();
        if (applyDetails != null) {
            applyDetailPayAbleNOList.addAll(applyDetails.stream().map(ApplyDetail::getPayableNo).collect(Collectors.toList()));
        }
        for (String payAbleNO : payableNOList) {
            ApplyDetail applyDetail = new ApplyDetail();
            if (applyDetailPayAbleNOList.contains(payAbleNO)) {
                BigDecimal totalPayAmt = payAmtMap.get(payAbleNO);
                BigDecimal totalAmt = applyDetails.stream().filter(applyDetail1 -> applyDetail1.getPayableNo().equals(payAbleNO)).filter(applyDet -> applyDet.getStatus().equals(ApplyPayStatus.APPLYING.getCode()) || applyDet.getStatus().equals(ApplyPayStatus.SUCCESS_PIDNG.getCode()) || applyDet.getStatus().equals(ApplyPayStatus.PAY_CONFIRMED.getCode())).map(ApplyDetail::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                if ((totalPayAmt = totalPayAmt.add(totalAmt)).compareTo(payableDetailPOMap.get(payAbleNO).getPayableAmt()) > 0) {
                    logger.error("\u652f\u4ed8\u603b\u91d1\u989d\u5927\u4e8e\u5e94\u4ed8\u5355[" + payAbleNO + "]\u603b\u4ef7");
                    throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payAbleNO + "]\u652f\u4ed8\u603b\u91d1\u989d\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d");
                }
            }
            applyDetail.setAmt(payAmtMap.get(payAbleNO));
            applyDetail.setApplyNo(payNO);
            applyDetail.setSource(payableDetailPOList.get(0).getSource());
            applyDetail.setOperatorId(payableDetailPOMap.get(payAbleNO).getOperatorId());
            applyDetail.setSupplierId(payableDetailPOMap.get(payAbleNO).getSupplierId());
            applyDetail.setStatus(applyPayInfoPO.getPayStatus());
            applyDetail.setPayableNo(payAbleNO);
            applyDetail.setCompanyId(reqBO.getCompanyId());
            applyDetailList.add(applyDetail);
        }
        logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6: " + ((Object)applyDetailList).toString());
        logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u8868\uff1a " + applyPayInfoPO.toString());
        try {
            this.applyDetailMapper.insertBatch(applyDetailList);
            this.applyPayInfoMapper.insert(applyPayInfoPO);
        }
        catch (Exception e) {
            logger.error("\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25" + e);
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25");
        }
        rspBO.setPayNo(payNO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void verification(FscApplyPayOrderCreateReqBO reqBO) {
        if (reqBO.getFscApplyPayOrderCreateBOList() == null || reqBO.getFscApplyPayOrderCreateBOList().size() == 0) {
            logger.error("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getApprovalType() == null) {
            logger.error("\u5ba1\u6279\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String getPayNO() {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.applyPayInfoMapper.selectMaxPayAbleNoNum(dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("FKDH").append(dateL).append(num);
            logger.info("=====\u4ed8\u6b3e\u5355\u53f7\u751f\u6210=====:" + sb.toString());
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7\u751f\u6210\u5931\u8d25");
        }
    }

    private UacNoTaskAuditCreateRspBO platformApproval(String payNO, FscApplyPayOrderCreateReqBO reqBO) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setProcDefKey(APPROVAL_KEY);
        uacNoTaskAuditCreateReqBO.setSysCode(this.CALL_PRC_SYS_CODE);
        uacNoTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(payNO);
        logger.info("=======\u521b\u5efa\u4ed8\u6b3e\u5ba1\u6279\u5355setObjId\uff1a{}" + payNO);
        approvalObjBO.setObjType(AuditObjType.RECEIPT_APPROVE_TYPE.getObjType());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setObjType(AuditObjType.RECEIPT_APPROVE_TYPE.getObjType());
        uacNoTaskAuditCreateInfoReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u521b\u5efa\u4ed8\u6b3e\u5355");
        uacReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacReqBO);
        logger.info("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = null;
        try {
            uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        }
        catch (Exception e) {
            logger.info("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u9519", (Throwable)e);
            throw new PfscExtBusinessException("\u5931\u8d25", "\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u9519");
        }
        logger.info("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        return uacNoTaskAuditCreateRspBO;
    }
}

