/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscPayApplyOrderMakeInvoiceApplyService;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderMakeInvoiceApplyReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderMakeInvoiceApplyRspBO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceInfoBO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceMailInfoBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayApplyOrderMakeInvoiceApplyService.class)
public class FscPayApplyOrderMakeInvoiceApplyServiceImpl
implements FscPayApplyOrderMakeInvoiceApplyService {
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    private static final Integer SUBMIT_INVOICE_SUBMIT = 1;

    public FscPayApplyOrderMakeInvoiceApplyRspBO makeInvoceApply(FscPayApplyOrderMakeInvoiceApplyReqBO reqBo) {
        this.initParam(reqBo);
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayNos(reqBo.getPayNos());
        List<ApplyPayInfoPO> list = this.applyPayInfoMapper.getList(applyPayInfoPO);
        BigDecimal amt = this.checkApplyPayInfoList(list);
        String applyNo = this.getBillApplyNo();
        ApplyPayInfoPO applyPayInfoPO1 = new ApplyPayInfoPO();
        applyPayInfoPO1.setNoticeApplyNo(applyNo);
        applyPayInfoPO1.setPayNos(reqBo.getPayNos());
        applyPayInfoPO1.setSubmitInvoice(SUBMIT_INVOICE_SUBMIT);
        int i = this.applyPayInfoMapper.updateApplicationBatch(applyPayInfoPO1);
        if (i != applyPayInfoPO1.getPayNos().size()) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4ed8\u6b3e\u5355\u72b6\u6001\u5931\u8d25");
        }
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setApplyNo(applyNo);
        billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
        if ("2".equals(reqBo.getIsProfessionalOrgExt())) {
            billApplyInfo.setBillStatus(BillStatus.APPLIED.getCode());
        }
        billApplyInfo.setSupplierNo(list.get(0).getSupplierId());
        billApplyInfo.setSupplierName(list.get(0).getSupplierName());
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectByApplyNo(list.get(0).getPayno());
        PayableDetailPO modelById = this.payableDetailMapper.getModelById(applyDetails.get(0).getPayableNo());
        billApplyInfo.setPayFeeType(modelById.getPayType());
        billApplyInfo.setApplyDate(new Date());
        billApplyInfo.setUserId(reqBo.getUserId());
        billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ORDER.getCode());
        billApplyInfo.setInvoiceClasses(reqBo.getInvoiceClasses());
        billApplyInfo.setAmt(amt);
        SaleInvoiceInfoBO invoiceInfo = reqBo.getInvoiceInfo();
        billApplyInfo.setInvoiceType(reqBo.getInvoiceType().toString());
        billApplyInfo.setInvoceName(invoiceInfo.getInvoceName());
        billApplyInfo.setTaxNo(invoiceInfo.getTaxNo());
        billApplyInfo.setAddr(invoiceInfo.getAddress());
        billApplyInfo.setPhone(invoiceInfo.getPhone());
        billApplyInfo.setBankName(invoiceInfo.getBankName());
        billApplyInfo.setBankAcctNo(invoiceInfo.getBankAcctNo());
        SaleInvoiceMailInfoBO mailAddrInfo = reqBo.getMailAddrInfo();
        if (InvoiceClasses.PAPER_INVOICE.getCode().equals(reqBo.getInvoiceClasses())) {
            billApplyInfo.setName(mailAddrInfo.getReceiver());
            billApplyInfo.setProvince(mailAddrInfo.getProvince());
            billApplyInfo.setCity(mailAddrInfo.getCity());
            billApplyInfo.setCounty(mailAddrInfo.getCounty());
            billApplyInfo.setTown(mailAddrInfo.getTown());
            billApplyInfo.setProvId(mailAddrInfo.getProvId());
            billApplyInfo.setCityId(mailAddrInfo.getCityId());
            billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo.setTownId(mailAddrInfo.getTownId());
            billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            billApplyInfo.setMobile(mailAddrInfo.getTel());
            billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
            billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
        } else {
            billApplyInfo.setReceiveInvoicePhone(reqBo.getReceiveInvoicePhone());
            billApplyInfo.setReceiveInvoiceEmail(reqBo.getReceiveInvoiceEmail());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.ELECTRONIC_INVOICE.getCode());
        }
        this.billApplyInfoMapper.insert(billApplyInfo);
        FscPayApplyOrderMakeInvoiceApplyRspBO rsp = new FscPayApplyOrderMakeInvoiceApplyRspBO();
        return rsp;
    }

    private BigDecimal checkApplyPayInfoList(List<ApplyPayInfoPO> list) {
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        for (ApplyPayInfoPO applyPayInfoPO : list) {
            if (!applyPayInfoPO.getPayOrgId().equals(list.get(0).getPayOrgId())) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u65b9\u4e0d\u540c\u7684\u4ed8\u6b3e\u5355");
            }
            if (!applyPayInfoPO.getPayOrgId().equals(list.get(0).getPayOrgId())) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u65b9\u4e0d\u540c\u7684\u4ed8\u6b3e\u5355");
            }
            if (!PayableStatus.SUCCESS.getCode().equals(applyPayInfoPO.getPayStatus())) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u5355\u672a\u4ed8\u6b3e");
            }
            invoiceAmount = invoiceAmount.add(applyPayInfoPO.getPayAmt());
        }
        return invoiceAmount;
    }

    private String getBillApplyNo() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateL = Long.valueOf(df.format(new Date())).toString();
        String prefix = "KPSQ";
        String maxNum = this.billApplyInfoMapper.selectMaxPayNoNum(prefix + dateL);
        String num = "000001";
        if (maxNum != null && !"".equals(maxNum)) {
            num = String.format("%06d", Integer.parseInt(maxNum) + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(dateL).append(num);
        return sb.toString();
    }

    private void initParam(FscPayApplyOrderMakeInvoiceApplyReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperType())) {
            throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPayNos())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || null == reqBO.getInvoiceInfo().getInvoceName()) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBO.getMailAddrInfo() || null == reqBO.getMailAddrInfo().getCompany()) {
            throw new PfscExtBusinessException("18000", "\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBO.getMailAddrInfo() || null == reqBO.getMailAddrInfo().getName()) {
            throw new PfscExtBusinessException("18000", "\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
    }
}

