/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.FscPayableOrderCreateService;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderCreateReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderCreateRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.PayAbleDateUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayableOrderCreateService.class)
public class FscPayableOrderCreateServiceImpl
implements FscPayableOrderCreateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscPayableOrderCreateServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayAbleDateUtil payAbleDateUtil;
    @Value(value="${ope.id:1234567}")
    private Long opeId;

    public FscPayableOrderCreateRspBO createPayableOrder(FscPayableOrderCreateReqBO reqBO) {
        LOGGER.debug("\u751f\u6210\u5e94\u4ed8\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayableType() == null || "".equals(reqBO.getPayableType())) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PayableType.EXPIRE.getCode().equals(reqBO.getPayableType())) {
            return this.invoicePosted(reqBO);
        }
        return this.otherPayableDetailOrder(reqBO);
    }

    private void verification(FscPayableOrderCreateReqBO reqBO) {
        if (reqBO.getRecOrgId() == null) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayOrgId() == null) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private FscPayableOrderCreateRspBO invoicePosted(FscPayableOrderCreateReqBO reqBO) {
        if (reqBO.getNotificationNos() == null || reqBO.getNotificationNos().size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNoBatch(reqBO.getNotificationNos());
        LOGGER.debug("\u8ba2\u5355\u8be6\u60c5\uff1a" + payPurchaseOrderInfos.toString());
        PayableDetailPO payableDetail = new PayableDetailPO();
        Date now = new Date();
        HashSet<Long> orderIdList = new HashSet<Long>();
        for (PayPurchaseOrderInfo purchaseOrderInfo : payPurchaseOrderInfos) {
            if (orderIdList.contains(purchaseOrderInfo.getOrderId())) continue;
            orderIdList.add(purchaseOrderInfo.getOrderId());
            try {
                String payAbleNo = this.getPayInfoId(reqBO.getPayableType());
                BigDecimal defaultValue = BigDecimal.ZERO;
                BigDecimal orderTotalAmt = payPurchaseOrderInfos.stream().filter(p -> p.getInspectionId().equals(purchaseOrderInfo.getInspectionId())).map(PayPurchaseOrderInfo::getOrderAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                int leastPayAbleDays = purchaseOrderInfo.getAccountingDays();
                payableDetail.setPurchaseOrderCode(purchaseOrderInfo.getPurchaseOrderCode());
                payableDetail.setPayableNo(payAbleNo);
                payableDetail.setOrderAmt(orderTotalAmt);
                payableDetail.setPayableAmt(orderTotalAmt);
                payableDetail.setOrderId(purchaseOrderInfo.getOrderId());
                payableDetail.setPaidDate(new Date(now.getTime() + (long)(leastPayAbleDays * 24 * 60 * 60 * 1000)));
                payableDetail.setPaidAmt(defaultValue);
                payableDetail.setPendingAmt(defaultValue);
                payableDetail.setNeedAgainstAmt(defaultValue);
                payableDetail.setOverduePenalty(defaultValue);
                payableDetail.setOverdueDays(0);
                payableDetail.setApproveStatus(0);
                payableDetail.setEffectiveStatus(1);
                payableDetail.setMemberId(reqBO.getUserId());
                payableDetail.setMemberName(reqBO.getName());
                payableDetail.setPayType(PayablePayType.PAY.getCode());
                payableDetail.setPayableStatus(PayableStatus.PENDING.getCode());
                payableDetail.setOperatorId(purchaseOrderInfo.getOperUnitNo());
                payableDetail.setPayableType(Integer.valueOf(reqBO.getPayableType()));
                payableDetail.setNotificationNo(purchaseOrderInfo.getNotificationNo());
                payableDetail.setNoticeApplyNo(purchaseOrderInfo.getNotificationNo());
                payableDetail.setRecOrgId(purchaseOrderInfo.getSupplierNo());
                payableDetail.setPayOrgId(purchaseOrderInfo.getPurchaseNo());
                payableDetail.setSupplierId(purchaseOrderInfo.getSupplierNo());
                payableDetail.setPurchaseNo(purchaseOrderInfo.getPurchaseNo());
                payableDetail.setPurchaseName(purchaseOrderInfo.getPurchaseName());
                payableDetail.setMobile(purchaseOrderInfo.getMobile());
                this.payableDetailMapper.insert(payableDetail);
                LOGGER.debug("\u751f\u6210\u5e94\u4ed8\u5355\uff1a" + payableDetail.toString());
                String payableType = PayableType.PURCH_SERVICE_FEE.getCode();
                this.createPurchServiceFee(payableDetail, payableType, reqBO);
            }
            catch (Exception e) {
                LOGGER.error("\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25");
            }
        }
        try {
            this.billNotificationInfoMapper.updateBillInvoiceStatus(reqBO.getNotificationNos(), BillStatus.ON_ACCOUNT.getCode());
        }
        catch (Exception e) {
            LOGGER.error("\u901a\u77e5\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        FscPayableOrderCreateRspBO rspBO = new FscPayableOrderCreateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscPayableOrderCreateRspBO createPurchServiceFee(PayableDetailPO payableDetails, String payableType, FscPayableOrderCreateReqBO reqBO) {
        List<PayItemInfo> payItemInfos = this.payItemInfoMapper.selectByOrderId(payableDetails.getOrderId());
        LOGGER.debug("\u8ba2\u5355\u8be6\u60c5\uff1a" + payItemInfos.toString());
        PayableDetailPO payableDetail = new PayableDetailPO();
        Date now = new Date();
        ArrayList<BigDecimal> rates = new ArrayList<BigDecimal>();
        for (PayItemInfo payItemInfo : payItemInfos) {
            if (payItemInfo.getCommDealServiceFeeRate() == null) continue;
            rates.add(payItemInfo.getCommDealServiceFeeRate());
            BigDecimal fee = payItemInfo.getCommDealServiceFeeRate().multiply(payItemInfo.getAmount());
            payItemInfo.setCommDealServiceFee(fee);
        }
        BigDecimal payableAmt = BigDecimal.ZERO;
        BigDecimal max = BigDecimal.ZERO;
        max = rates.size() > 0 ? (BigDecimal)Collections.max(rates) : new BigDecimal("0.015");
        for (PayItemInfo payItemInfo : payItemInfos) {
            if (payItemInfo.getCommDealServiceFee() == null || payItemInfo.getCommDealServiceFee().equals(BigDecimal.ZERO)) {
                BigDecimal fee = payItemInfo.getAmount().multiply(max);
                payItemInfo.setCommDealServiceFee(fee);
                payableAmt = payableAmt.add(payItemInfo.getCommDealServiceFee());
                continue;
            }
            payableAmt = payableAmt.add(payItemInfo.getCommDealServiceFee());
        }
        try {
            String payAbleNo = this.getPayInfoId(payableType);
            BigDecimal defaultValue = BigDecimal.ZERO;
            payableDetail.setPayableNo(payAbleNo);
            payableDetail.setOrderAmt(payableDetails.getPayableAmt());
            payableDetail.setPayableAmt(payableAmt);
            payableDetail.setOrderId(payableDetails.getOrderId());
            payableDetail.setPaidAmt(defaultValue);
            payableDetail.setPendingAmt(defaultValue);
            payableDetail.setNeedAgainstAmt(defaultValue);
            payableDetail.setOverduePenalty(defaultValue);
            payableDetail.setOverdueDays(0);
            payableDetail.setApproveStatus(0);
            payableDetail.setEffectiveStatus(1);
            payableDetail.setMemberId(reqBO.getUserId());
            payableDetail.setMemberName(reqBO.getName());
            payableDetail.setPayType(PayablePayType.PAY.getCode());
            payableDetail.setPayableStatus(PayableStatus.PENDING.getCode());
            payableDetail.setOperatorId(payableDetails.getOperatorId());
            payableDetail.setPayableType(Integer.valueOf(reqBO.getPayableType()));
            payableDetail.setNotificationNo(payableDetails.getNotificationNo());
            payableDetail.setNoticeApplyNo(payableDetails.getNotificationNo());
            payableDetail.setRecOrgId(payableDetails.getOperatorId());
            payableDetail.setPayOrgId(payableDetail.getSupplierId());
            payableDetail.setSupplierId(payableDetails.getSupplierId());
            payableDetail.setPurchaseNo(payableDetails.getPurchaseNo());
            payableDetail.setPurchaseName(payableDetails.getPurchaseName());
            payableDetail.setMobile(payableDetails.getMobile());
            this.payableDetailMapper.insert(payableDetail);
            LOGGER.debug("\u751f\u6210\u5e94\u4ed8\u5355\uff1a" + payableDetail.toString());
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25");
        }
        try {
            this.billNotificationInfoMapper.updateBillInvoiceStatus(reqBO.getNotificationNos(), BillStatus.ON_ACCOUNT.getCode());
        }
        catch (Exception e) {
            LOGGER.error("\u901a\u77e5\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        FscPayableOrderCreateRspBO rspBO = new FscPayableOrderCreateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscPayableOrderCreateRspBO otherPayableDetailOrder(FscPayableOrderCreateReqBO reqBO) {
        this.verification(reqBO);
        FscPayableOrderCreateRspBO rspBO = new FscPayableOrderCreateRspBO();
        Map<String, Integer> payAbleDateMap = this.payAbleDateUtil.getDateMap();
        Date now = new Date();
        BigDecimal payAbleAmt = BigDecimal.ZERO;
        if (PayableType.ACCOUNT_VERIFICATION.getCode().equals(reqBO.getPayableType())) {
            if (reqBO.getMobile() == null) {
                throw new PfscExtBusinessException("18000", "\u8d26\u6237\u9a8c\u771f\u65f6\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            int range = new Random().nextInt(11);
            payAbleAmt = payAbleAmt.add(new BigDecimal(range));
        } else {
            payAbleAmt = payAbleAmt.add(reqBO.getPayableAmt());
        }
        try {
            SimpleDateFormat sdf;
            Date date;
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            Date paidDate = null;
            LOGGER.info("--=======---==");
            if (PayableType.MAERGIN.getCode().equals(reqBO.getPayableType())) {
                LOGGER.info("--====1===---==");
                reqBO.setRecOrgId(reqBO.getRecOrgId());
                date = new Date();
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sdf.format(date);
                String paidDates = "";
                Calendar calc = Calendar.getInstance();
                try {
                    calc.setTime(sdf.parse(format));
                    calc.add(5, 3);
                    Date minDate = calc.getTime();
                    paidDates = sdf.format(minDate);
                    paidDate = sdf.parse(paidDates);
                    payableDetailPO.setPaidDate(paidDate);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else if (PayableType.RETURN_MAERGIN.getCode().equals(reqBO.getPayableType())) {
                LOGGER.info("--=======2---==");
                reqBO.setPayOrgId(reqBO.getPayOrgId());
                payableDetailPO.setBondAmt(reqBO.getBondAmt());
                date = new Date();
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sdf.format(date);
                String paidDates = "";
                Calendar calc = Calendar.getInstance();
                try {
                    calc.setTime(sdf.parse(format));
                    calc.add(2, 3);
                    Date minDate = calc.getTime();
                    paidDates = sdf.format(minDate);
                    paidDate = sdf.parse(paidDates);
                    payableDetailPO.setPaidDate(paidDate);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else if (PayableType.PT_BREACH.getCode().equals(reqBO.getPayableType()) || PayableType.DD_BREACH.getCode().equals(reqBO.getPayableType())) {
                LOGGER.info("--=======--3-==");
                reqBO.setPayOrgId(reqBO.getSupplierId());
                reqBO.setRecOrgId(reqBO.getRecOrgId());
                date = new Date();
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sdf.format(date);
                String paidDates = "";
                Calendar calc = Calendar.getInstance();
                try {
                    calc.setTime(sdf.parse(format));
                    calc.add(5, 2);
                    Date minDate = calc.getTime();
                    paidDates = sdf.format(minDate);
                    paidDate = sdf.parse(paidDates);
                    payableDetailPO.setPaidDate(paidDate);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else {
                LOGGER.info("--=====4==---==");
                LOGGER.info("-----map----" + JSON.toJSONString(payAbleDateMap));
                LOGGER.info("-----reqBO----" + JSON.toJSONString((Object)reqBO));
                Integer payableDate = payAbleDateMap.get(reqBO.getPayableType());
                paidDate = new Date(now.getTime() + (long)(payableDate * 24 * 60 * 60 * 1000));
            }
            LOGGER.info("----------------");
            String payAbleNo = this.getPayInfoId(reqBO.getPayableType());
            LOGGER.debug("\u5e94\u4ed8\u7f16\u53f7\uff1a" + payAbleNo);
            if (reqBO.getOutPurchaseOrderNo() != null) {
                payableDetailPO.setOutPurchaseOrderNo(reqBO.getOutPurchaseOrderNo());
            }
            if (reqBO.getPurchaseOrderCode() != null) {
                payableDetailPO.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
            }
            BigDecimal defaultValue = BigDecimal.ZERO;
            payableDetailPO.setPayableNo(payAbleNo);
            payableDetailPO.setPaidAmt(defaultValue);
            payableDetailPO.setPendingAmt(defaultValue);
            payableDetailPO.setNeedAgainstAmt(defaultValue);
            payableDetailPO.setOverduePenalty(defaultValue);
            payableDetailPO.setOverdueDays(0);
            payableDetailPO.setApproveStatus(0);
            payableDetailPO.setEffectiveStatus(1);
            payableDetailPO.setMemberId(reqBO.getUserId());
            payableDetailPO.setMemberName(reqBO.getName());
            payableDetailPO.setPayableAmt(payAbleAmt);
            payableDetailPO.setOrderAmt(payAbleAmt);
            payableDetailPO.setSupplierId(reqBO.getSupplierId());
            payableDetailPO.setOperatorId(reqBO.getOperatorId());
            payableDetailPO.setPurchaseNo(reqBO.getPurchaseNo());
            payableDetailPO.setRecOrgId(reqBO.getRecOrgId());
            payableDetailPO.setPayOrgId(reqBO.getPayOrgId());
            payableDetailPO.setPayableType(Integer.valueOf(reqBO.getPayableType()));
            payableDetailPO.setPaidDate(paidDate);
            payableDetailPO.setPayType(PayablePayType.PAY.getCode());
            payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
            payableDetailPO.setMobile(reqBO.getMobile());
            rspBO.setPayableNo(payAbleNo);
            if (PayableType.OPTIONAL_PREPAYMENT.getCode().equals(reqBO.getPayableType()) || PayableType.PREPAYMENT.equals(reqBO.getPayableType()) || PayableType.SELF_EXPIRE.getCode().equals(reqBO.getPayableType())) {
                this.createPurchServiceFee(payableDetailPO, reqBO.getPayableType(), reqBO);
            }
            this.payableDetailMapper.insert(payableDetailPO);
            LOGGER.debug("\u5e94\u4ed8\u5355\uff1a" + payableDetailPO.toString());
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff1a" + e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getPayInfoId(String payableType) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String prefix = "YFDH-DD";
            PayableType payAbleStatus = PayableType.getInstance(payableType);
            if (payAbleStatus != null) {
                prefix = payAbleStatus.getPayableNoPrefix();
            }
            String maxNum = this.payableDetailMapper.selectMaxPayAbleNoNum(prefix + "-" + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append("-").append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

