/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryBalanceService;
import com.tydic.pfscext.api.busi.bo.QueryBalanceReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBalanceRspBo;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.BalanceMapper;
import com.tydic.pfscext.dao.po.BalanceChngLog;
import com.tydic.pfscext.dao.po.BalanceChngLogPo;
import com.tydic.pfscext.enums.ItemType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryBalanceService.class)
public class QueryBalanceServiceImpl
implements QueryBalanceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryBalanceServiceImpl.class);
    @Autowired
    private BalanceMapper balanceMapper;

    public PfscExtRspPageBaseBO<QueryBalanceRspBo> queryBalanceList(QueryBalanceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4fdd\u8bc1\u91d1\u5217\u8868\uff1a" + reqBO.toString());
        }
        PfscExtRspPageBaseBO rspPageBaseBO = new PfscExtRspPageBaseBO();
        if (reqBO == null) {
            logger.error("\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new PfscExtBusinessException("18000", "\u4fdd\u8bc1\u91d1\u5217\u8868\u67e5\u8be2---\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BalanceChngLogPo balanceChngLogPo = new BalanceChngLogPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)balanceChngLogPo));
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        List<BalanceChngLog> BalanceChngLogs = this.balanceMapper.getListPageByTerms(balanceChngLogPo, (Page<Map<String, Object>>)page);
        ArrayList<QueryBalanceRspBo> queryBalanceRspBos = new ArrayList<QueryBalanceRspBo>();
        if (BalanceChngLogs.size() > 0) {
            for (BalanceChngLog balanceChngLog : BalanceChngLogs) {
                QueryBalanceRspBo queryBalanceRspBo = new QueryBalanceRspBo();
                BeanUtils.copyProperties((Object)balanceChngLog, (Object)queryBalanceRspBo);
                if (queryBalanceRspBo.getItemAmt() == null) {
                    throw new PfscExtBusinessException("18000", "\u6b3e\u9879\u7c7b\u578b\u4e0d\u5b58\u5728");
                }
                String itemType = queryBalanceRspBo.getItemType();
                String itemTypeStr = ItemType.getInstance(itemType).getDescr();
                queryBalanceRspBo.setItemTypeStr(itemTypeStr);
                if (queryBalanceRspBo.getChngType() != null) {
                    if ("1".equals(queryBalanceRspBo.getChngType())) {
                        queryBalanceRspBo.setChngTypeStr(queryBalanceRspBo.getRecName());
                    } else if ("2".equals(queryBalanceRspBo.getChngType())) {
                        queryBalanceRspBo.setChngTypeStr(queryBalanceRspBo.getPayName());
                    }
                } else {
                    throw new PfscExtBusinessException("18000", "\u6536\u5165\u652f\u51fa\u4e0d\u660e\u786e");
                }
                if (queryBalanceRspBo.getProjectFlag() != null) {
                    if ("1".equals(queryBalanceRspBo.getProjectFlag())) {
                        queryBalanceRspBo.setProjectFlagStr("\u5df2\u5b8c\u6210");
                    } else if ("2".equals(queryBalanceRspBo.getProjectFlag())) {
                        queryBalanceRspBo.setProjectFlagStr("\u672a\u5b8c\u6210");
                    }
                }
                queryBalanceRspBos.add(queryBalanceRspBo);
            }
        }
        rspPageBaseBO.setRows(queryBalanceRspBos);
        rspPageBaseBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBaseBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBaseBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBaseBO;
    }
}

