/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.QueryReturnBalanceService;
import com.tydic.pfscext.api.busi.bo.QueryReturnBalanceReqBo;
import com.tydic.pfscext.api.busi.bo.QueryReturnBalanceRspBo;
import com.tydic.pfscext.dao.BalanceMapper;
import com.tydic.pfscext.dao.po.Balance;
import com.tydic.pfscext.dao.po.BalanceChngLog;
import com.tydic.pfscext.dao.po.BalanceChngLogPo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryReturnBalanceService.class)
public class QueryReturnBalanceServiceImpl
implements QueryReturnBalanceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryReturnBalanceServiceImpl.class);
    @Autowired
    private BalanceMapper balanceMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public QueryReturnBalanceRspBo queryReturnBalanceBySupId(QueryReturnBalanceReqBo reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7533\u8bf7\u9000\u8fd8\u4fdd\u8bc1\u91d1\u8be6\u60c5\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + reqBo.toString());
        }
        if (reqBo.getSupId() == null) {
            throw new PfscExtBusinessException("18001", "\u4f9b\u5e94\u5546\u4fdd\u8bc1\u91d1\u7ba1\u7406\u7533\u8bf7\u9000\u8fd8\u4fdd\u8bc1\u91d1\u8be6\u60c5\u67e5\u8be2---\u8be5\u7528\u6237\u975e\u4f9b\u5e94\u5546");
        }
        QueryReturnBalanceRspBo rspBo = new QueryReturnBalanceRspBo();
        Balance balance = new Balance();
        balance.setObjId(reqBo.getSupId());
        balance.setObjType("00");
        Balance balance1 = this.balanceMapper.selectByBalance(balance);
        if (balance1 == null) {
            throw new PfscExtBusinessException("18001", "\u4f9b\u5e94\u5546\u4fdd\u8bc1\u91d1\u7ba1\u7406\u7533\u8bf7\u9000\u8fd8\u4fdd\u8bc1\u91d1\u8be6\u60c5\u67e5\u8be2---\u8be5\u7528\u6237\u6ca1\u6709\u4f59\u989d\u8d26\u6237");
        }
        rspBo.setBalance(balance1.getBalance());
        BalanceChngLogPo balanceChngLogPo = new BalanceChngLogPo();
        balanceChngLogPo.setSupId(reqBo.getSupId());
        balanceChngLogPo.setItemType("06");
        List<BalanceChngLog> listByTerms = this.balanceMapper.getListByTerms(balanceChngLogPo);
        if (listByTerms == null) {
            rspBo.setProjectAmt(BigDecimal.ZERO);
        } else {
            BigDecimal projectAmt = new BigDecimal(0);
            for (BalanceChngLog balanceChngLog : listByTerms) {
                BigDecimal itemAmt = balanceChngLog.getItemAmt();
                projectAmt = projectAmt.add(itemAmt);
            }
            rspBo.setProjectAmt(projectAmt);
            System.err.println(projectAmt);
        }
        String supplierStr = this.organizationInfoService.querySupplierName(reqBo.getSupId());
        rspBo.setRecName(supplierStr);
        return rspBo;
    }
}

