/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfscext.api.notify.SendPayResultService;
import com.tydic.pfscext.api.pay.CreatePayOrderService;
import com.tydic.pfscext.api.pay.bo.CreatePayOrderReqBO;
import com.tydic.pfscext.api.pay.bo.CreatePayOrderRspBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=CreatePayOrderService.class)
public class CreatePayOrderServiceImpl
implements CreatePayOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePayOrderServiceImpl.class);
    @Resource(name="payOrderSeq")
    private OrderSequence payOrderSeq;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    private String service_url;
    private Long openUnitNo;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private SendPayResultService sendPayResultService;

    public CreatePayOrderRspBO createPayOrder(CreatePayOrderReqBO reqBO) {
        CreatePayOrderRspBO rspBO = new CreatePayOrderRspBO();
        if (null == reqBO.getId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayMethod()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u96c6\u5408[pyMethod]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderNo = reqBO.getId();
        try {
            String busiCode = "";
            Long merchantId = null;
            StringBuffer payOrderNo = new StringBuffer();
            String payAmt = "0";
            String detailName = "";
            if (reqBO.getPaymentOrderType().equals("0")) {
                ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(orderNo);
                payOrderNo.append("PAYMENT-").append(applyPayInfoPO.getPayno());
                if (null == applyPayInfoPO.getPayAmt()) {
                    throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                }
                BigDecimal payAmtB = applyPayInfoPO.getPayAmt().multiply(new BigDecimal(100));
                payAmt = payAmtB.setScale(0, 1).toString();
                OrgMerchantConfigPO orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(applyPayInfoPO.getSupplierId());
                busiCode = orgMerchantConfigPO.getBusiCode();
                merchantId = orgMerchantConfigPO.getMerchantId();
                detailName = "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e";
            } else {
                PayOrderInfoPO payOrderInfoPO = this.payOrderInfoMapper.selectByPrimaryKey(Long.valueOf(orderNo));
                payOrderNo.append("SERVICE-FEE-").append(orderNo);
                if (null == payOrderInfoPO.getActualAmount()) {
                    throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                }
                BigDecimal payAmtC = payOrderInfoPO.getActualAmount().multiply(new BigDecimal(100));
                payAmt = payAmtC.setScale(0, 1).toString();
                OrgMerchantConfigPO orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(this.openUnitNo);
                busiCode = orgMerchantConfigPO.getBusiCode();
                merchantId = orgMerchantConfigPO.getMerchantId();
                detailName = "\u6210\u4ea4\u670d\u52a1\u8d39\u7f34\u8d39";
            }
            PaymentFlowInfo paymentFlowInfoPO = this.paymentFlowInfoMapper.selectByOutOrderId(payOrderNo.toString());
            if (null != paymentFlowInfoPO && "SUCCESS".equals(paymentFlowInfoPO.getPaymentStatus())) {
                logger.error("\u8ba2\u5355[" + paymentFlowInfoPO.getOutOrderId() + "]\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8ba2\u5355[" + paymentFlowInfoPO.getOutOrderId() + "]\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            this.savelog("CreatePayOrderService-248", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\uff1a" + e);
            this.savelog("CreatePayOrderService-252", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25:" + e);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

