/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class SignTool {
    public static void main(String[] args) throws Exception {
        String dataOk = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><R xml:lang=\"zh\"><E><I k=\"TransactionId\"><D>FE131227,FE131229</D></I><I k=\"bankAccountNumber\"><D>76790188000911468</D></I><I k=\"transactionType\"><D>\u94f6\u884c\u8d26\u6237\u7ed1\u5b9a</D></I><I k=\"userName\"><D>15238001835</D></I><I k=\"bankAccountName\"><D>\u8682\u8681\u533a\u5757\u94fe\u79d1\u6280\uff08\u4e0a\u6d77\uff09\u6709\u9650\u516c\u53f8</D></I><I k=\"companyIdNumber\"><D>91310101MA1FPCXA3G</D></I><I k=\"bankName\"><D>\u5149\u5927\u94f6\u884c</D></I><I k=\"contractHash\"><D></D></I><I k=\"accountId\"><D>20190814130100005893</D></I><I k=\"companyIdType\"><D>231</D></I><I k=\"companyName\"><D>\u8682\u8681\u533a\u5757\u94fe\u79d1\u6280(\u4e0a\u6d77)\u6709\u9650\u516c\u53f8</D></I><I k=\"role\"><D>2</D></I><V k=\"transTip\"><T>\u63d0\u793a:</T><D>\u60a8\u6b63\u5728\u53d1\u8d77\u8682\u8681\u91d1\u670d\u53cc\u94fe\u901a\u4ea4\u6613</D></V></E></R>";
        String signOk = "JLk8ACw/EX9x72Ib/XCPn/D9zhK0qVoRmFgdDrHst+tfsv4P/Izma7rknSonz64LoPGK1CTMdlyaeaqrOzOvGMR9YzzQoWN/ulyvgIQ4QhspEXDZF0aWBQZ/Lao7DD5krUlSkC2dFacAS4GOG/dvSr/1jFlExjziDA2g7h8sUIA=";
        String pubKeyOk = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC8aSY149au/fzuZEwnyjXqB5y8k156UNAvx+9+z8ZLgMKXnWiIvbW0CdDjciljPyb9h5A0+mXI5EgtmmIxKaaMGxE5C8aFIPj/ArTlNABaesbk0VGQjOxAwem8mjLJXGReOu7SDJA/YIV6+ldUwWbseOAlXIlTf7dpzw6o6oc1YQIDAQAB";
        System.out.println(SignTool.verifySignSha256WithRsa(dataOk, signOk, pubKeyOk));
        String dataError = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><R xml:lang=\"zh\"><E><I k=\"TransactionId\"><D>FE131227,FE131229</D></I><I k=\"bankAccountNumber\"><D>76620188011447421</D></I><I k=\"transactionType\"><D>\u94f6\u884c\u8d26\u6237\u7ed1\u5b9a</D></I><I k=\"userName\"><D>15062208720</D></I><I k=\"bankAccountName\"><D>\u4e1c\u53f0\u5e02\u65b0\u65ed\u73af\u4fdd\u79d1\u6280\u6709\u9650\u516c\u53f8</D></I><I k=\"companyIdNumber\"><D>91320981MA217WUM83</D></I><I k=\"bankName\"><D>\u5149\u5927\u94f6\u884c</D></I><I k=\"contractHash\"><D></D></I><I k=\"accountId\"><D>20210308130100055923</D></I><I k=\"companyIdType\"><D>231</D></I><I k=\"companyName\"><D>\u4e1c\u53f0\u5e02\u65b0\u65ed\u73af\u4fdd\u79d1\u6280\u6709\u9650\u516c\u53f8</D></I><I k=\"role\"><D>1</D></I><V k=\"transTip\"><T>\u63d0\u793a:</T><D>\u60a8\u6b63\u5728\u53d1\u8d77\u8682\u8681\u91d1\u670d\u53cc\u94fe\u901a\u4ea4\u6613</D></V></E></R>";
        String signError = "dVCHb1gAFhoO03hdr47PydSrWyhtOqFmg5Dzx3/25xrXda3SQWEwXb1qKkDP5G3nbnedHVi5Qke2TtltMljevbkCs5sAFJ04NDFjTUhNMqTb1keq9Es79hA9yuOw8ttcXrKuSQZy3a6xDwD6LT+6GOctlZycopwWaF8k3Zv2vyHpVBmTcEW0gr4BZuUyHKmpBSTFGsrp2D9ZCqF8aO+6Tateqn+ifTTOCD/OpTiJBXBXG3cmyv5Z2c7DL0ghHK2Mq72BZuSvSAlIFQq9S572gMKzOfAu9W42uo+T+jO/KYig6zF7EzEQW55TySUbiFDmskSvfBIJr72iLSaVcUwP/Q==";
        String pubKeyError = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1XiqFW4iVv0dWsx84Ip22uGD+20t1/Vlaqciu7szF69FNVX09xBhPA8Pt2EI2TPtu2zM762YbNWI6n56yW+8C7ZUutYBMXcE7tG+dZk4VDwCQ9bZcFYQelluxzIIMugwHtzh07MS8WUQ5xYcn7HgnzniDzoOGJ7qe5fGsH0lXr0BDknUXj+sDMVWGGgvY5tvMJe3g0DHbLRFYETzyS/U";
        System.out.println(SignTool.verifySignSha256WithRsa(dataError, signError, pubKeyError));
    }

    public static void test() throws Exception {
        String priKeySit;
        String openApiInputDev = "{\n\t\"biz_content\": {\n\t\t\"sys_param\": {\n\t\t\t\"partner\": \"SMART_PAY\",\n\t\t\t\"function\": \"PAY.ORDER.SUBMIT\",\n\t\t\t\"request_id\": \"2020122100049754\"\n\t\t},\n\t\t\"encoded_biz_param\": {\n\t\t\t\"trade_id\": \"2020122100049754\",\n\t\t\t\"sign_data\": \"PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+PFNpZ25EYXRhPjxUcmFkZVR5cGUgbmFtZT0iSW50cmFiYW5rVHJz77yaIj40PC9UcmFkZVR5cGU+PFRpbWVzdGFtcD4xNjA4NTM3OTk3Nzk4PC9UaW1lc3RhbXA+PEZpZWxkcz48YXJJZD4yMDIwMTIyMTEwMDAwMzMyOTI4ODwvYXJJZD48bWVtbz4tPC9tZW1vPjxyZWN2QmFua0FjY291bnROdW1iZXI+LTwvcmVjdkJhbmtBY2NvdW50TnVtYmVyPjxndWFyYW50b3I+MDA8L2d1YXJhbnRvcj48Y29udHJpYnV0b3JOYW1lPmVlPC9jb250cmlidXRvck5hbWU+PGlzc3Vlcj5iNGJmMDBiZDgwNGFiMzExZDA4MzcyMjU4YzlkNmNiNGQ1MjcxNTNlNjZlYWMxZDJhNjc3YmU4NmQ1Y2ZiOWZmPC9pc3N1ZXI+PGZhY3RvcmluZz5lNWEzMTQ4ZjNhMjgzZGU4YTUwZGRlOGE5ZGU0NTIyMTUxMTc4NTM4NDA3NTIxYTA1Nzc0ZjdiNTM4ZGIwMjRmPC9mYWN0b3Jpbmc+PHRvQ29tcGFueU5hbWU+c3M8L3RvQ29tcGFueU5hbWU+PG1hdHVyaXR5RGF0ZT4xNjA5MzI5NDM5MDAwPC9tYXR1cml0eURhdGU+PHN1cHBsaWVyPmY2ZTI4ODg5YmFkN2M2MGExM2EyOTczMzU4NWI1Y2Y0MDRlYmU4ZmE4MDI2NDJhNjQ4NTBmZTQ1ZjQ5MzdhZTk8L3N1cHBsaWVyPjxmcm9tPmI0YmYwMGJkODA0YWIzMTFkMDgzNzIyNThjOWQ2Y2I0ZDUyNzE1M2U2NmVhYzFkMmE2NzdiZTg2ZDVjZmI5ZmY8L2Zyb20+PGludm9pY2VObz4tPC9pbnZvaWNlTm8+PHBvbGljeT4xMzc8L3BvbGljeT48ZnJvbUNvbXBhbnlOYW1lPmNjPC9mcm9tQ29tcGFueU5hbWU+PGFzc2V0RXhwaXJlRGF5PjIwMjAvMTIvMjU8L2Fzc2V0RXhwaXJlRGF5PjxhbW91bnQ+MTAwMDA8L2Ftb3VudD48cmVjdkJhbmtOYW1lPi08L3JlY3ZCYW5rTmFtZT48Y29udHJhY3RIYXNoPi08L2NvbnRyYWN0SGFzaD48aXNzdWVyTmFtZT5pc3N1ZXJOYW1lPC9pc3N1ZXJOYW1lPjxyZWNlaXZhYmxlTm8+b3V0X29yZGVyX25vPC9yZWNlaXZhYmxlTm8+PHB1cmNoYXNlPm08L3B1cmNoYXNlPjx0cmFuc2FjdGlvblR5cGU+5bqU5LuY6LSm5qy+5b2V5YWl56Gu6K6kPC90cmFuc2FjdGlvblR5cGU+PGFtb3VudFU+6Zu25YWD5pW0PC9hbW91bnRVPjxjb250cmFjdElkPmNvbnRyYWN0SWQ8L2NvbnRyYWN0SWQ+PGFtb3VudEw+MC4wMDwvYW1vdW50TD48dG8+ZjZlMjg4ODliYWQ3YzYwYTEzYTI5NzMzNTg1YjVjZjQwNGViZThmYTgwMjY0MmE2NDg1MGZlNDVmNDkzN2FlOTwvdG8+PGZhY3RvcmluZ05hbWU+ZGQ8L2ZhY3RvcmluZ05hbWU+PHJlY3ZCYW5rQWNjb3VudE5hbWU+LTwvcmVjdkJhbmtBY2NvdW50TmFtZT48L0ZpZWxkcz48L1NpZ25EYXRhPg==\",\n\t\t\t\"sign_algorithm\": \"SHA256WithRSA\",\n\t\t\t\"pub_key\": \"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDV6jViPRzw/yKnD0Fo/UOiOqnVNHJnE7LOT7XerL/LuQQ9FO/1wYkptwROdgStMyPilklJ94+n9pWbnj1/NZgBE/A8HK0s+7VxOrqF0B4YjJxXMeJy23172VIBb547xyKmeN9XoNM5CKHzNYl9cgca5lDWuZ9mzPctyH+cZwwK3QIDAQAB\",\n\t\t\t\"signature\": \"Hqt0o1XzdkNAGuLTyvwJ+OsA/YOArD1XSXKeK+SGKQTMkPbjHIrzJmKz+0zYX0o1uHKTpx6b2LQkt9EdPEb+v1MCWam7CLvHBJqtokkY01xEBu1F0dPTutbC0wQJMLjQWTude1/jFUZkfkmCZ0pOKtN2x9DoaOMHQo3phz1g/xg=\"\n\t\t}\n\t}\n}";
        String openApiInputSit = "{\n\t\"biz_content\": {\n\t\t\"sys_param\": {\n\t\t\t\"partner\": \"SMART_PAY\",\n\t\t\t\"function\": \"PAY.ORDER.SUBMIT\",\n\t\t\t\"request_id\": \"2020122100049754\"\n\t\t},\n\t\t\"encoded_biz_param\": {\n\t\t\t\"trade_id\": \"2020122100049754\",\n\t\t\t\"sign_data\": \"PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+PFNpZ25EYXRhPjxUcmFkZVR5cGUgbmFtZT0iSW50cmFiYW5rVHJz77yaIj40PC9UcmFkZVR5cGU+PFRpbWVzdGFtcD4xNjA4NTM3OTk3Nzk4PC9UaW1lc3RhbXA+PEZpZWxkcz48YXJJZD4yMDIwMTIyMTEwMDAwMzMyOTI4ODwvYXJJZD48bWVtbz4tPC9tZW1vPjxyZWN2QmFua0FjY291bnROdW1iZXI+LTwvcmVjdkJhbmtBY2NvdW50TnVtYmVyPjxndWFyYW50b3I+MDA8L2d1YXJhbnRvcj48Y29udHJpYnV0b3JOYW1lPmVlPC9jb250cmlidXRvck5hbWU+PGlzc3Vlcj5iNGJmMDBiZDgwNGFiMzExZDA4MzcyMjU4YzlkNmNiNGQ1MjcxNTNlNjZlYWMxZDJhNjc3YmU4NmQ1Y2ZiOWZmPC9pc3N1ZXI+PGZhY3RvcmluZz5lNWEzMTQ4ZjNhMjgzZGU4YTUwZGRlOGE5ZGU0NTIyMTUxMTc4NTM4NDA3NTIxYTA1Nzc0ZjdiNTM4ZGIwMjRmPC9mYWN0b3Jpbmc+PHRvQ29tcGFueU5hbWU+c3M8L3RvQ29tcGFueU5hbWU+PG1hdHVyaXR5RGF0ZT4xNjA5MzI5NDM5MDAwPC9tYXR1cml0eURhdGU+PHN1cHBsaWVyPmY2ZTI4ODg5YmFkN2M2MGExM2EyOTczMzU4NWI1Y2Y0MDRlYmU4ZmE4MDI2NDJhNjQ4NTBmZTQ1ZjQ5MzdhZTk8L3N1cHBsaWVyPjxmcm9tPmI0YmYwMGJkODA0YWIzMTFkMDgzNzIyNThjOWQ2Y2I0ZDUyNzE1M2U2NmVhYzFkMmE2NzdiZTg2ZDVjZmI5ZmY8L2Zyb20+PGludm9pY2VObz4tPC9pbnZvaWNlTm8+PHBvbGljeT4xMzc8L3BvbGljeT48ZnJvbUNvbXBhbnlOYW1lPmNjPC9mcm9tQ29tcGFueU5hbWU+PGFzc2V0RXhwaXJlRGF5PjIwMjAvMTIvMjU8L2Fzc2V0RXhwaXJlRGF5PjxhbW91bnQ+MTAwMDA8L2Ftb3VudD48cmVjdkJhbmtOYW1lPi08L3JlY3ZCYW5rTmFtZT48Y29udHJhY3RIYXNoPi08L2NvbnRyYWN0SGFzaD48aXNzdWVyTmFtZT5pc3N1ZXJOYW1lPC9pc3N1ZXJOYW1lPjxyZWNlaXZhYmxlTm8+b3V0X29yZGVyX25vPC9yZWNlaXZhYmxlTm8+PHB1cmNoYXNlPm08L3B1cmNoYXNlPjx0cmFuc2FjdGlvblR5cGU+5bqU5LuY6LSm5qy+5b2V5YWl56Gu6K6kPC90cmFuc2FjdGlvblR5cGU+PGFtb3VudFU+6Zu25YWD5pW0PC9hbW91bnRVPjxjb250cmFjdElkPmNvbnRyYWN0SWQ8L2NvbnRyYWN0SWQ+PGFtb3VudEw+MC4wMDwvYW1vdW50TD48dG8+ZjZlMjg4ODliYWQ3YzYwYTEzYTI5NzMzNTg1YjVjZjQwNGViZThmYTgwMjY0MmE2NDg1MGZlNDVmNDkzN2FlOTwvdG8+PGZhY3RvcmluZ05hbWU+ZGQ8L2ZhY3RvcmluZ05hbWU+PHJlY3ZCYW5rQWNjb3VudE5hbWU+LTwvcmVjdkJhbmtBY2NvdW50TmFtZT48L0ZpZWxkcz48L1NpZ25EYXRhPg==\",\n\t\t\t\"sign_algorithm\": \"SHA256WithRSA\",\n\t\t\t\"pub_key\": \"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnlt0goZxEwQRE9+geNmu7aPB9BHHJGl9eNXiNNQZmDNyPJdxBTDJsfNUaLGhKv2t4AxUh7Nm7fNLOyfxWE11wcynA3lolKHnYqnxa2+q3jTaCLqJPdQd0DKkDulsoe8PLRpxRmXuwzAVJaVsZPbx2TFTm0FTYlB7CWL5UzqaLywIDAQAB\",\n\t\t\t\"signature\": \"Hqt0o1XzdkNAGuLTyvwJ+OsA/YOArD1XSXKeK+SGKQTMkPbjHIrzJmKz+0zYX0o1uHKTpx6b2LQkt9EdPEb+v1MCWam7CLvHBJqtokkY01xEBu1F0dPTutbC0wQJMLjQWTude1/jFUZkfkmCZ0pOKtN2x9DoaOMHQo3phz1g/xg=\"\n\t\t}\n\t}\n}";
        JSONObject jsonOpenApiInput = JSON.parseObject((String)openApiInputSit);
        String tradeId = "2021010500046645";
        String signDataBase64 = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+PFNpZ25EYXRhPjxUcmFkZVR5cGUgbmFtZT0iSW50cmFiYW5rVHJz77yaIj40PC9UcmFkZVR5cGU+PFRpbWVzdGFtcD4xNjA5ODU1Mjg5NDc3PC9UaW1lc3RhbXA+PEZpZWxkcz48YXJJZD4yMDIxMDEwNTEwMDAwMDExNjkwNDwvYXJJZD48bWVtbz4tPC9tZW1vPjxyZWN2QmFua0FjY291bnROdW1iZXI+LTwvcmVjdkJhbmtBY2NvdW50TnVtYmVyPjxndWFyYW50b3I+MDA8L2d1YXJhbnRvcj48Y29udHJpYnV0b3JOYW1lPmVlPC9jb250cmlidXRvck5hbWU+PGlzc3Vlcj40ZjZmMGQ4NmM4YjI4ZTlhMTVhMGYyOWE4ZDY1ODFhYWNiNzliNTA3NjQ2YjBlNjIzOGU0YmUzMTUzMWRkMGI1PC9pc3N1ZXI+PGZhY3RvcmluZz5mYjVjMGExMGM3MmE0NzVmMzU0MTYzMzQ2NTIyYmFhYTNlN2Y2NjRmMDliNjk3OTViMTA3YWY5MzEzMzgwYjJkPC9mYWN0b3Jpbmc+PHRvQ29tcGFueU5hbWU+6IGL5a+55bOw5aCw5pyJ6ZmQ5YWs5Y+4PC90b0NvbXBhbnlOYW1lPjxtYXR1cml0eURhdGU+MTYyOTMyOTQzOTAwMDwvbWF0dXJpdHlEYXRlPjxzdXBwbGllcj5jOTE2ZjU0NDZlMDFhZTQwNGYxMWNkNzkwNzFiNzM0Njk0YWU1MjdiZTFkMWMxOTI5MmFkYzIzOGI4YWU1N2ViPC9zdXBwbGllcj48ZnJvbT40ZjZmMGQ4NmM4YjI4ZTlhMTVhMGYyOWE4ZDY1ODFhYWNiNzliNTA3NjQ2YjBlNjIzOGU0YmUzMTUzMWRkMGI1PC9mcm9tPjxpbnZvaWNlTm8+LTwvaW52b2ljZU5vPjxwb2xpY3k+MTM3PC9wb2xpY3k+PGZyb21Db21wYW55TmFtZT55aXFpdXRlc3Q3MTwvZnJvbUNvbXBhbnlOYW1lPjxhc3NldEV4cGlyZURheT4yMDIxLzA4LzE5PC9hc3NldEV4cGlyZURheT48YW1vdW50PjIyMjI1MDwvYW1vdW50PjxyZWN2QmFua05hbWU+LTwvcmVjdkJhbmtOYW1lPjxjb250cmFjdEhhc2g+LTwvY29udHJhY3RIYXNoPjxpc3N1ZXJOYW1lPnlpcWl1dGVzdDcxPC9pc3N1ZXJOYW1lPjxyZWNlaXZhYmxlTm8+b3V0X29yZGVyX25vPC9yZWNlaXZhYmxlTm8+PHB1cmNoYXNlPuS7mOasvuWNleivtOaYjijpnZ7lv4XkvKApPC9wdXJjaGFzZT48dHJhbnNhY3Rpb25UeXBlPuW6lOS7mOi0puasvuW9leWFpeehruiupDwvdHJhbnNhY3Rpb25UeXBlPjxhbW91bnRVPui0sOWNg+i0sOS9sOi0sOaLvui0sOWFg+S8jeinkuaVtDwvYW1vdW50VT48Y29udHJhY3RJZD4yMDIxMDEwNTAwMDQ2NjQ1PC9jb250cmFjdElkPjxhbW91bnRMPjIsMjIyLjUwPC9hbW91bnRMPjx0bz5jOTE2ZjU0NDZlMDFhZTQwNGYxMWNkNzkwNzFiNzM0Njk0YWU1MjdiZTFkMWMxOTI5MmFkYzIzOGI4YWU1N2ViPC90bz48ZmFjdG9yaW5nTmFtZT7luLjlt57luILpmL\\/ph4zlt7Tlt7TppJDppa7nrqHnkIbmnInpmZDlhazlj7g8L2ZhY3RvcmluZ05hbWU+PHJlY3ZCYW5rQWNjb3VudE5hbWU+LTwvcmVjdkJhbmtBY2NvdW50TmFtZT48L0ZpZWxkcz48L1NpZ25EYXRhPg==".replaceAll("\\\\", "");
        String priKeyDev = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANXqNWI9HPD/IqcPQWj9Q6I6qdU0cmcTss5Ptd6sv8u5BD0U7/XBiSm3BE52BK0zI+KWSUn3j6f2lZuePX81mAET8DwcrSz7tXE6uoXQHhiMnFcx4nLbfXvZUgFvnjvHIqZ431eg0zkIofM1iX1yBxrmUNa5n2bM9y3If5xnDArdAgMBAAECgYA5moglnC9e9lVuhz0l+I1t8j4pm6Xy++r6g5yGCh7bzUbG7AxyMVuuUApo1n8L5OmU6sNxl6inok9HSKVmzBfSNHOVmiNzHygKFb8olONKyx0h5OIKP1JJcrh9xFSjJPlqwFYtK70oTTKmhCKX1Nqbr+r5vAmHGY3qAhgree9MAQJBAOqx0V/HRm99Z+DAIskl71lEjlh7Fnypsv9q4W5hYDXc6e9jpLxvFUfEk2xW7tijGKGAXdtxYv840agETjYXki0CQQDpVXsEe9+MDpb2Cx8ybk0yw4UMaE1DuPdt82s/3klw1D8QjHIcLRMf3VH+cnED4vTjAYk+rwOG4dGRBAtRSrlxAkBTYsxmQFI5SJBA3WM+npjU2bPNoiYSMuUjNOFVq4lYed4wLPIZ9UnVTvWmN5jzJbeZohc24alvzstG7Aix1VwdAkAiG6i74w+ufYN7u+x3hsAqJ4KPab/Boowoumh3EZtSrvP5C06y57Pf+I4/z6LNmqOJe3QAgbzWPrRPqnOtEmtBAkBccOn3BndoT0xxSVGNRkbV04GdFBk0TGIW3XYf7iV6iA3YZJifLHrPxZQnxrKwlRu16lsdARJDoWLWSB1vDNfO";
        String priKey = priKeySit = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAKeW3SChnETBBET36B42a7to8H0EcckaX141eI01BmYM3I8l3EFMMmx81RosaEq/a3gDFSHs2bt80s7J/FYTXXBzKcDeWiUoediqfFrb6reNNoIuok91B3QMqQO6Wyh7w8tGnFGZe7DMBUlpWxk9vHZMVObQVNiUHsJYvlTOpovLAgMBAAECgYEAlRvPpybjaPDrIYoJBkiZVeeqgTEhJDLIw4ODvO9+v/GVk++1potrGcd/u4fjSw5BSkhD1ylrGDuZPM/OKa+VI/O84oQ+7qgdmpgyarmT5NnBAlKUbSBUKifVBBKv+1UHTGtkiJ9q3F8IbdJd12guR/yGCwNT5tMr06eWEXd5cHECQQDjiQDPPLR6oN/3ZfA4PKNL9H/MG66HDihDVztBBPGZfPao68fnzHTYORkxyg0UvbToyMN8SvFNbHzV3zC6TQj9AkEAvI4L24N1aEJ8SY6lYcmIyxah7mGBXBzYxwOHwwhWs1dgLnO7VNKTxuPLuA4ufg4BtmANZ97Dbca1kpBbNNoGZwJAHBHpxKcziLFSD/5GbVmlt5gZL//2PvkTJIOdbr8CYzIUZ/B2f/UsMQSSRB8uD/H7YIBsBWhlbmzE1cmsBD++rQJBAJSJojWvfdJAbgDUatx6E1VJ4w8TqQCTiQJeeZje/M4TSyXM7gqISPopgdbg9SdAiYDOckEdb/8OxwNKzU75YokCQA2EBDotyBP0+IpPH131vlOyQgNldgH8o2zjjmymuAbUdR66MM/oQNv/Z1v4TziRc4m8ShcuPtHMwJ0geZDK2lY=";
        String signData = new String(Base64.getDecoder().decode(signDataBase64.replace("\r\n", "")), StandardCharsets.UTF_8);
        String sign = SignTool.signSha256WithRsa(signData, priKey);
        jsonOpenApiInput.getJSONObject("biz_content").getJSONObject("sys_param").put("request_id", (Object)tradeId);
        jsonOpenApiInput.getJSONObject("biz_content").getJSONObject("encoded_biz_param").put("trade_id", (Object)tradeId);
        jsonOpenApiInput.getJSONObject("biz_content").getJSONObject("encoded_biz_param").put("sign_data", (Object)signDataBase64);
        jsonOpenApiInput.getJSONObject("biz_content").getJSONObject("encoded_biz_param").put("signature", (Object)sign);
        System.out.println(jsonOpenApiInput.toJSONString());
    }

    public static String signSha256WithRsa(String data, String base64PriKey) throws Exception {
        PrivateKey priKey = SignTool.getPrivateKey(new ByteArrayInputStream(base64PriKey.getBytes()));
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initSign(priKey);
        if (StringUtils.isEmpty((CharSequence)"UTF-8")) {
            signature.update(data.getBytes());
        } else {
            signature.update(data.getBytes("UTF-8"));
        }
        byte[] signed = signature.sign();
        return new String(Base64.getEncoder().encode(signed));
    }

    private static PrivateKey getPrivateKey(InputStream ins) throws Exception {
        if (ins == null) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] encodedKey = IOUtils.toString((InputStream)ins).getBytes();
        encodedKey = Base64.getDecoder().decode(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static boolean verifySignSha256WithRsa(String rawData, String signature, String base64PubKey) {
        boolean verifySignSuccess = false;
        try {
            PublicKey publicKey = SignTool.getPublicKey(base64PubKey);
            Signature verifySign = Signature.getInstance("SHA256WithRSA");
            verifySign.initVerify(publicKey);
            verifySign.update(rawData.getBytes());
            verifySignSuccess = verifySign.verify(Base64.getDecoder().decode(signature));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return verifySignSuccess;
    }

    public static PublicKey getPublicKey(String key) {
        try {
            byte[] byteKey = Base64.getDecoder().decode(key);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byteKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

