/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiApplyMailRemailService;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailRemailReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscStringUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiApplyMailRemailService.class)
public class BusiApplyMailRemailServiceImpl
implements BusiApplyMailRemailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailRemailServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public PfscExtRspBaseBO process(BusiApplyMailRemailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8865\u6253\u91cd\u53d1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderName())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderProv())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u4eba\u6240\u5c5e\u7701\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderCity())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u4eba\u6240\u5c5e\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderAddr())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderPhone())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mailTicketNos = reqBO.getMailTicketNos();
        if (mailTicketNos == null || mailTicketNos.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setMailTicketNos(reqBO.getMailTicketNos());
            List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                map.put(saleInvoiceInfo.getMailTicketNo(), saleInvoiceInfo.getApplyNo());
            }
            for (String oldMailTicketNo : mailTicketNos) {
                List<SaleInvoiceMailInfo> expressInfos = this.saleInvoiceMailInfoMapper.selectByExpressNo(oldMailTicketNo);
                if (expressInfos.isEmpty()) {
                    pfscExtRspBaseBO.setRespCode("0001");
                    pfscExtRspBaseBO.setRespDesc("\u5feb\u9012\u5355\u53f7:" + oldMailTicketNo + "\u5f55\u5165\u4e0d\u6b63\u786e");
                    return pfscExtRspBaseBO;
                }
                SaleInvoiceMailInfo firstExpressInfo = expressInfos.get(0);
                if (InvoiceMailSentStatus.NOT_SENT.getCode().equals(firstExpressInfo.getMailStatus())) continue;
                pfscExtRspBaseBO.setRespCode("0001");
                pfscExtRspBaseBO.setRespDesc("\u5feb\u9012\u5355\u53f7:" + oldMailTicketNo + "\u72b6\u6001\u4e3a" + InvoiceMailSentStatus.getInstance(firstExpressInfo.getMailStatus()).getDescr() + "\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
                return pfscExtRspBaseBO;
            }
        }
        catch (Exception e) {
            logger.debug("\u8865\u6253\u91cd\u53d1\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u53d6\u6d88\u91cd\u53d1\u5931\u8d25", e);
        }
        return pfscExtRspBaseBO;
    }

    private void cancelAndRemail(SaleInvoiceMailInfo oldMail, BusiApplyMailRemailReqBO reqBO, String applyNo) {
        BillApplyInfo applyInfoPO = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        String province = FscStringUtils.valueOf(applyInfoPO.getProvince());
        String city = FscStringUtils.valueOf(applyInfoPO.getCity());
        String county = FscStringUtils.valueOf(applyInfoPO.getCounty());
        String town = FscStringUtils.valueOf(applyInfoPO.getTown());
        String addrDesc = FscStringUtils.valueOf(applyInfoPO.getAddrDesc());
        String addressStr = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
        Long outLogisticsOrderId = 0L;
    }
}

