/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiPushPayPurchaseOrderInfoService;
import com.tydic.pfscext.api.busi.bo.BusiPushPayPurchaseOrderInfoItemReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPushPayPurchaseOrderInfoOrderReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPushPayPurchaseOrderInfoReqBO;
import com.tydic.pfscext.api.notify.SendOrderAcceptanceService;
import com.tydic.pfscext.api.notify.bo.FscRemindReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.OrderStatus2;
import com.tydic.pfscext.enums.PurchaseSaleType;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiPushPayPurchaseOrderInfoService.class)
public class BusiPushPayPurchaseOrderInfoServiceImpl
implements BusiPushPayPurchaseOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPushPayPurchaseOrderInfoServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private SendOrderAcceptanceService sendOrderAcceptanceService;

    public PfscExtRspBaseBO add(BusiPushPayPurchaseOrderInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        final BusiPushPayPurchaseOrderInfoOrderReqBO orderInfo = reqBO.getOrderInfo();
        if (orderInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        final Long orderId = orderInfo.getOrderId();
        Long inspectionId = orderInfo.getInspectionId();
        if (orderId == null || orderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionId == null || inspectionId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList itemList = reqBO.getItemList();
        if (itemList == null || itemList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfo.getAccountingDays() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u3010accountingDays\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, BusiPushPayPurchaseOrderInfoItemReqBO> itemMap = new HashMap<Long, BusiPushPayPurchaseOrderInfoItemReqBO>(itemList.size() + 1);
        for (BusiPushPayPurchaseOrderInfoItemReqBO itemInfo : itemList) {
            if (!itemMap.containsKey(itemInfo.getItemNo())) {
                itemMap.put(itemInfo.getItemNo(), itemInfo);
                continue;
            }
            BusiPushPayPurchaseOrderInfoItemReqBO itemInMap = (BusiPushPayPurchaseOrderInfoItemReqBO)itemMap.get(itemInfo.getItemNo());
            itemInMap.setQuantity(itemInMap.getQuantity().add(itemInfo.getQuantity()));
            itemInMap.setAmount(itemInMap.getAmount().add(itemInfo.getAmount()));
        }
        itemList = new ArrayList(itemMap.values());
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setAccountingDays(orderInfo.getAccountingDays());
        payPurchaseOrderInfo.setInspectionId(inspectionId);
        payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setInspectionId(inspectionId);
        ArrayList<String> itemStatusNotIn = new ArrayList<String>();
        itemStatusNotIn.add(OrderStatus.NO_APPLY.getCode());
        payItemInfoVO.setItemStatusNotIn(itemStatusNotIn);
        int count = this.payItemInfoMapper.selectCount(payItemInfoVO);
        if (payPurchaseOrderInfo != null) {
            if (count > 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u3002");
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u3002");
            }
            PayItemInfo payItemInfo = new PayItemInfo();
            payItemInfo.setInspectionId(inspectionId);
            this.payItemInfoMapper.deleteBy(payItemInfo);
            payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setInspectionId(inspectionId);
            this.payPurchaseOrderInfoMapper.deleteBy(payPurchaseOrderInfo);
        }
        String source = orderInfo.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setOrderId(orderId);
            payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
            if (payPurchaseOrderInfo != null) {
                payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setOrderId(orderId);
                this.payPurchaseOrderInfoMapper.deleteBy(payPurchaseOrderInfo);
                PayItemInfo payItemInfo = new PayItemInfo();
                payItemInfo.setOrderId(orderId);
                this.payItemInfoMapper.deleteBy(payItemInfo);
            }
        }
        payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)payPurchaseOrderInfo);
        payPurchaseOrderInfo.setBusiModel(orderInfo.getBusiMode());
        String supplierName = this.organizationInfoService.querySupplierName(payPurchaseOrderInfo.getSupplierNo());
        payPurchaseOrderInfo.setSupplierName(supplierName);
        String orgName = this.organizationInfoService.queryOrgName(payPurchaseOrderInfo.getPurchaseNo());
        payPurchaseOrderInfo.setPurchaseName(orgName);
        orgName = this.organizationInfoService.queryOrgName(payPurchaseOrderInfo.getOperUnitNo());
        payPurchaseOrderInfo.setOperUnitName(orgName);
        payPurchaseOrderInfo.setNotificationNo(null);
        payPurchaseOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payPurchaseOrderInfo.setReconcilitionStatus(ReconciliationStatus.NOT_RECONCILED.getCode());
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            List<Long> childrenOrgIds = this.organizationInfoService.getChildrenOrgIds(payPurchaseOrderInfo.getOperUnitNo());
            if (childrenOrgIds != null && childrenOrgIds.contains(payPurchaseOrderInfo.getPurchaseNo())) {
                payPurchaseOrderInfo.setPurchaseSaleType(PurchaseSaleType.SELFUSE.getCode());
            } else {
                payPurchaseOrderInfo.setPurchaseSaleType(PurchaseSaleType.MINMARKET.getCode());
            }
        } else if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            Object branchCompany = this.organizationInfoService.queryBranchCompanyByAccountId(payPurchaseOrderInfo.getPurchaseProjectId());
            payPurchaseOrderInfo.setBranchCompany((Long)branchCompany);
        }
        if (null != payPurchaseOrderInfo.getPayType()) {
            switch (payPurchaseOrderInfo.getPayType()) {
                case "0": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BANK_RECEIVE.getCode());
                    break;
                }
                case "1": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BILL_AGREEMENT.getCode());
                    break;
                }
                case "2": {
                    payPurchaseOrderInfo.setPayType(SaleOrderPayType.BILL_RECEIVE.getCode());
                }
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3010payType\u3011");
        }
        payPurchaseOrderInfo.setPayStatus("00");
        this.payPurchaseOrderInfoMapper.insert(payPurchaseOrderInfo);
        ArrayList<PayItemInfo> payItemInfoList = new ArrayList<PayItemInfo>();
        for (BusiPushPayPurchaseOrderInfoItemReqBO itemInfo : itemList) {
            PayItemInfo payItemInfo = new PayItemInfo();
            BeanUtils.copyProperties((Object)itemInfo, (Object)payItemInfo);
            payItemInfo.setOrderId(orderId);
            payItemInfo.setPurchaseOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
            payItemInfo.setInspectionId(inspectionId);
            payItemInfo.setNotificationNo(null);
            payItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            if (!StringUtils.hasText((String)payItemInfo.getUnitName())) {
                payItemInfo.setUnitName("\u4e2a");
            }
            if (StringUtils.hasText((String)payItemInfo.getItemName()) && payItemInfo.getItemName().length() > 100) {
                payItemInfo.setItemName(payItemInfo.getItemName().substring(0, 100));
            }
            if (payItemInfo.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (null == payItemInfo.getTaxRate()) {
                payItemInfo.setTaxRate(this.enumsService.queryDefaultTaxRate());
            }
            BigDecimal taxAmt = payItemInfo.getAmount().divide(BigDecimal.ONE.add(payItemInfo.getTaxRate()), 5, 4).multiply(payItemInfo.getTaxRate()).setScale(2, 4);
            payItemInfo.setTaxAmt(taxAmt);
            payItemInfo.setUntaxAmt(payItemInfo.getAmount().subtract(payItemInfo.getTaxAmt()));
            if (null != payItemInfo.getSettleRate() && payItemInfo.getSettleRate().intValue() == 0) {
                payItemInfo.setSettleRate(null);
            }
            if (null != payItemInfo.getSettleRate()) {
                BigDecimal settleRate = null;
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    settleRate = payItemInfo.getSettleRate();
                    payItemInfo.setQuantitySale(itemInfo.getQuantity());
                    BigDecimal quantity = itemInfo.getQuantity().multiply(settleRate).setScale(6, 4);
                    payItemInfo.setQuantity(quantity);
                    payItemInfo.setPurchaseUnitPriceSale(itemInfo.getPurchaseUnitPrice());
                    payItemInfo.setPurchaseUnitPrice(itemInfo.getAmount().divide(quantity, 2, 4));
                    payItemInfo.setUnitNameSale(itemInfo.getUnitName());
                    if (!StringUtils.hasText((String)payItemInfo.getUnitNameSale())) {
                        payItemInfo.setUnitNameSale("\u4e2a");
                    }
                    payItemInfo.setUnitName(itemInfo.getSettleUnit());
                    if (!StringUtils.hasText((String)payItemInfo.getUnitName())) {
                        payItemInfo.setUnitName("\u4e2a");
                    }
                } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                    // empty if block
                }
            }
            payItemInfoList.add(payItemInfo);
        }
        if (payItemInfoList.isEmpty()) {
            logger.error("\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
        }
        this.payItemInfoMapper.insertBatch(payItemInfoList);
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            PayPurchaseOrderInfo purchaseOrderInfo = new PayPurchaseOrderInfo();
            purchaseOrderInfo.setPurchaseOrderCode(orderInfo.getPurchaseOrderCode());
            String orderStatus2 = orderInfo.getOrderStatus2();
            if ("4".equals(orderStatus2) || "5".equals(orderStatus2)) {
                orderStatus2 = OrderStatus2.PARTIAL_ACCEPTANCE.getCode();
            } else if ("6".equals(orderStatus2)) {
                orderStatus2 = OrderStatus2.FULL_ACCEPTANCE.getCode();
            }
            purchaseOrderInfo.setOrderStatus2(orderStatus2);
            this.payPurchaseOrderInfoMapper.updateByPurchaseOrderCode(purchaseOrderInfo);
        }
        final Long UserId = payPurchaseOrderInfo.getPurchaserId();
        new Thread(){

            @Override
            public void run() {
                FscRemindReqBO fscRemindReqBO = new FscRemindReqBO();
                fscRemindReqBO.setOrderId(orderInfo.getOrderId());
                fscRemindReqBO.setPurchaseOrderCode(orderInfo.getPurchaseOrderCode());
                fscRemindReqBO.setUserId(UserId);
                fscRemindReqBO.setSupplierNo(orderInfo.getSupplierNo());
                logger.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3,\u8ba2\u5355\u9a8c\u6536\u6210\u529f\u670d\u52a1,\u8fdb\u5165\u7ebf\u7a0b\u6210\u529f,\u8ba2\u5355\u7f16\u53f7\u4e3a:" + orderId + "\u64cd\u4f5c\u4ebaID\uff1a" + UserId);
                BusiPushPayPurchaseOrderInfoServiceImpl.this.sendOrderAcceptanceService.send(fscRemindReqBO);
            }
        }.start();
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

