/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiUpdatePayConfigService;
import com.tydic.pfscext.api.busi.bo.UpdatePayConfigFscReqBo;
import com.tydic.pfscext.api.busi.bo.UpdatePayConfigFscRspBo;
import com.tydic.pfscext.dao.PayConfigMapper;
import com.tydic.pfscext.dao.PayTypeConfigMapper;
import com.tydic.pfscext.dao.po.PayConfig;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiUpdatePayConfigService.class)
public class BusiUpdatePayConfigServiceImpl
implements BusiUpdatePayConfigService {
    private static final Logger log = LoggerFactory.getLogger(BusiUpdatePayConfigServiceImpl.class);
    @Autowired
    private PayConfigMapper payConfigMapper;
    @Autowired
    private PayTypeConfigMapper payTypeConfigMapper;

    public UpdatePayConfigFscRspBo updatePayConfig(UpdatePayConfigFscReqBo updatePayConfigFscReqBo) {
        int i;
        UpdatePayConfigFscRspBo updatePayConfigFscRspBo = new UpdatePayConfigFscRspBo();
        if (updatePayConfigFscReqBo.getPayConfigId() == null) {
            updatePayConfigFscRspBo.setRespCode("8888");
            updatePayConfigFscRspBo.setRespDesc("\u652f\u4ed8\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
            return updatePayConfigFscRspBo;
        }
        PayConfig payConfig = new PayConfig();
        BeanUtils.copyProperties((Object)updatePayConfigFscReqBo, (Object)payConfig);
        PayConfig oldPayConfig = this.payConfigMapper.selectByPrimaryKey(payConfig.getPayConfigId());
        if (oldPayConfig == null) {
            updatePayConfigFscRspBo.setRespCode("8888");
            updatePayConfigFscRspBo.setRespDesc("\u652f\u4ed8\u914d\u7f6eid\uff1a" + payConfig.getPayConfigId() + "\u4e0d\u5b58\u5728\uff01");
            return updatePayConfigFscRspBo;
        }
        int quotaCompareResult = updatePayConfigFscReqBo.getOverdraftQuota().subtract(oldPayConfig.getUsedQuota()).compareTo(BigDecimal.ZERO);
        if (quotaCompareResult < 0) {
            updatePayConfigFscRspBo.setRespCode("8888");
            updatePayConfigFscRspBo.setRespDesc("\u66f4\u65b0\u5931\u8d25\uff0c\u8bbe\u7f6e\u7684\u53ef\u900f\u652f\u91d1\u989d\u4f4e\u4e8e\u5df2\u4f7f\u7528\u91d1\u989d\uff01");
            return updatePayConfigFscRspBo;
        }
        payConfig.setUpdateTime(new Date());
        payConfig.setOverdraftQuota(updatePayConfigFscReqBo.getOverdraftQuota());
        payConfig.setBalance(updatePayConfigFscReqBo.getOverdraftQuota().subtract(oldPayConfig.getUsedQuota()));
        payConfig.setUpdateUserId(updatePayConfigFscReqBo.getUserId());
        payConfig.setUpdateUserName(updatePayConfigFscReqBo.getUsername());
        String overdueRate = updatePayConfigFscReqBo.getOverdueRate().replace("%", "");
        BigDecimal bigDecimal = new BigDecimal(overdueRate);
        payConfig.setOverdueRate(bigDecimal);
        List dayTypes = updatePayConfigFscReqBo.getDayTypes();
        if (dayTypes != null) {
            dayTypes.sort(String::compareTo);
            payConfig.setDayTypes(dayTypes.toString());
        }
        if ((i = this.payConfigMapper.updateByPrimaryKeySelective(payConfig)) != 1) {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u914d\u7f6e\u66f4\u65b0\u5931\u8d25");
        }
        updatePayConfigFscRspBo.setPayConfigId(updatePayConfigFscReqBo.getPayConfigId());
        updatePayConfigFscRspBo.setRespCode("0000");
        updatePayConfigFscRspBo.setRespDesc("\u4fdd\u5b58\u6210\u529f");
        return updatePayConfigFscRspBo;
    }
}

