/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.FscApprovePayApplyOrderService;
import com.tydic.pfscext.api.busi.bo.FscApprovePayApplyOrderReqBO;
import com.tydic.pfscext.api.busi.bo.FscApprovePayApplyOrderRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.ApproveResult;
import com.tydic.pfscext.enums.ApproveStatus;
import com.tydic.pfscext.enums.AuditObjType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscApprovePayApplyOrderService.class)
public class FscApprovePayApplyOrderServiceImpl
implements FscApprovePayApplyOrderService {
    private static final Logger logger = LoggerFactory.getLogger(FscApprovePayApplyOrderServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;

    public FscApprovePayApplyOrderRspBO dealApprove(FscApprovePayApplyOrderReqBO reqBO) {
        logger.debug("\u5165\u53c2\uff1a" + reqBO.toString());
        this.verification(reqBO);
        ApplyPayInfoPO modelById = this.applyPayInfoMapper.getModelById(reqBO.getPayNo());
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setObjId(String.valueOf(modelById.getApprovalFlowCode()));
        uacQryAuditLogReqBO.setObjType(AuditObjType.RECEIPT_APPROVE_TYPE.getObjType());
        logger.info("\u67e5\u8be2\u65e5\u5fd7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO logRspBO = null;
        try {
            logRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ba1\u6279\u65e5\u5fd7\u51fa\u9519", (Throwable)e);
            throw new PfscExtBusinessException("\u5931\u8d25", "\u67e5\u8be2\u5ba1\u6279\u65e5\u5fd7\u51fa\u9519");
        }
        logger.info("\u67e5\u8be2\u65e5\u5fd7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)logRspBO));
        if (!"0000".equals(logRspBO.getRespCode())) {
            logger.error("\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u51fa\u9519\uff1a" + logRspBO.getRespDesc());
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u51fa\u9519\uff1a" + logRspBO.getRespDesc());
        }
        List rows = logRspBO.getRows();
        Map<String, ApprovalLogBO> stepMap = rows.stream().collect(Collectors.toMap(ApprovalLogBO::getNextStepId, approvalLogBO -> approvalLogBO));
        logger.info("stepMap=========" + JSON.toJSONString(stepMap));
        ApprovalLogBO approvalLogBO2 = stepMap.get(reqBO.getStepId());
        if (approvalLogBO2.getAuditResult() != null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f53\u524d\u6b65\u9aa4\u5df2\u88ab\u5ba1\u6279\uff0c\u5ba1\u6279\u7ed3\u679c\u4e3a\uff1a " + (approvalLogBO2.getAuditResult() == 0 ? "\u3010\u901a\u8fc7\u3011" : "\u3010\u9a73\u56de\u3011"));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.getApprovalResult(reqBO);
        if (!"0000".equals(auditRspBO.getRespCode())) {
            logger.error("\u8c03\u7528\u5ba1\u6279\u5ba1\u6279\u4e2d\u5fc3\u51fa\u9519\uff1a{}", (Object)auditRspBO.getRespDesc());
            throw new PfscExtBusinessException("18000", "\u8c03\u7528\u5ba1\u6279\u5ba1\u6279\u4e2d\u5fc3\u51fa\u9519");
        }
        UacNoneInstanceBO noneInstanceBO = auditRspBO.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        if ("0".equals(auditResult) && finish.equals(Boolean.TRUE)) {
            try {
                this.applyPayInfoMapper.updateByPayNo(approvalLogBO2.getNextStepId(), reqBO.getPayNo(), ApproveStatus.PLATFORM_APPROVED.getCode(), ApplyPayStatus.PENDING_PAYMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0applyPayInfo\u8868\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u53d8\u66f4\u72b6\u6001\u5931\u8d25");
            }
            try {
                this.applyDetailMapper.updateStatusByApplyNo(reqBO.getPayNo(), ApplyPayStatus.PENDING_PAYMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0applyDetail\u8868\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u53d8\u66f4\u72b6\u6001\u5931\u8d25");
            }
        }
        if ("0".equals(auditResult) && finish.equals(Boolean.FALSE)) {
            try {
                this.applyPayInfoMapper.updateByPayNo(approvalLogBO2.getNextStepId(), reqBO.getPayNo(), ApproveStatus.PLATFORM_APPROVING.getCode(), ApplyPayStatus.APPROVING.getCode());
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0applyPayInfo\u8868\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("\u5931\u8d25", "\u53d8\u66f4\u72b6\u6001\u5931\u8d25");
            }
        }
        try {
            this.applyPayInfoMapper.updateByPayNo(approvalLogBO2.getNextStepId(), reqBO.getPayNo(), ApproveStatus.APPROVAL_REJECTED.getCode(), ApplyPayStatus.FAILED.getCode());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0applyPayInfo\u8868\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d8\u66f4\u72b6\u6001\u5931\u8d25");
        }
        try {
            this.applyDetailMapper.updateStatusByApplyNo(reqBO.getPayNo(), ApplyPayStatus.FAILED.getCode());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0applyDetail\u8868\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d8\u66f4\u72b6\u6001\u5931\u8d25");
        }
        FscApprovePayApplyOrderRspBO rspBO = new FscApprovePayApplyOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void verification(FscApprovePayApplyOrderReqBO reqBO) {
        if (reqBO.getPayNo() == null || "".equals(reqBO.getPayNo())) {
            logger.error("\u4ed8\u6b3e\u5355\u53f7\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u5355\u53f7\u4e3a\u7a7a");
        }
        if (reqBO.getApproveResult() == null || "".equals(reqBO.getApproveResult())) {
            logger.error("\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a");
        }
        if (reqBO.getStepId() == null || "".equals(reqBO.getStepId())) {
            logger.error("\u5f53\u524d\u6b65\u9aa4id\u4e0d\u80fd\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u5f53\u524d\u6b65\u9aa4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscApprovePayApplyOrderReqBO reqBO) {
        logger.info("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5ba1\u6279:{}" + JSON.toJSONString((Object)reqBO));
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        ApplyPayInfoPO payInfoPO = this.applyPayInfoMapper.getModelById(reqBO.getPayNo());
        objIdList.add(payInfoPO.getApprovalFlowCode());
        auditReqBO.setObjId(objIdList);
        logger.info("=========\u5ba1\u6838\u5ba1\u6279===========");
        logger.info("auditReqBO.setStepId\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        auditReqBO.setStepId(reqBO.getStepId());
        Integer auditStatus = ApproveResult.AGREE.getCode().equals(reqBO.getApproveResult()) ? 0 : 1;
        auditReqBO.setAuditResult(auditStatus);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setObjType(AuditObjType.RECEIPT_APPROVE_TYPE.getObjType());
        logger.info("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = null;
        try {
            uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5ba1\u6279\u51fa\u9519", (Throwable)e);
            throw new PfscExtBusinessException("\u5931\u8d25", "\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u9519");
        }
        logger.info("\u8c03\u7528\u5ba1\u6279\u4e2d\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        return uacNoTaskAuditOrderAuditRspBO;
    }
}

