/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.tydic.pfscext.api.busi.FscApplyPaySubmitService;
import com.tydic.pfscext.api.busi.FscCreateDoubleLinkApplyService;
import com.tydic.pfscext.api.busi.FscPayApplyOrderSubmitService;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayRspBO;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderSubmitReqBo;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderSubmitRspBo;
import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayApplyOrderSubmitService.class)
public class FscPayApplyOrderSubmitServiceImpl
implements FscPayApplyOrderSubmitService {
    private static final Logger logger = LoggerFactory.getLogger(FscPayApplyOrderSubmitServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private FscCreateDoubleLinkApplyService fscCreateDoubleLinkApplyService;
    @Autowired
    private FscApplyPaySubmitService fscApplyPaySubmitService;

    public FscPayApplyOrderSubmitRspBo submit(FscPayApplyOrderSubmitReqBo reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u4e2d\u5fc3\u4ed8\u6b3e\u5355\u4ed8\u6b3e \u5165\u53c2\uff1a" + JSON.toString((Object)reqBo));
        }
        this.initParam(reqBo);
        logger.debug("==================================+\u8fdb\u5165\u4e86service");
        this.updateApplyPayInfo(reqBo);
        FscPayApplyOrderSubmitRspBo rspBo = new FscPayApplyOrderSubmitRspBo();
        return rspBo;
    }

    private List<PayableDetailPO> updateServiceFeePayableStatus(List<PayableDetailPO> payableDetailPOS) {
        if (payableDetailPOS != null && payableDetailPOS.size() > 0) {
            ArrayList<Long> orderIds = new ArrayList<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                orderIds.add(payableDetailPO.getOrderId());
            }
            PayableDetailVO payableDetailVO = new PayableDetailVO();
            payableDetailVO.setOrderIdList(orderIds);
            payableDetailVO.setPayableType(11);
            payableDetailVO.setPayableStatus("01");
            ArrayList<Long> serviceFeeOrderIds = new ArrayList<Long>();
            List<PayableDetailPO> payableDetailPOS1 = this.payableDetailMapper.selectList(payableDetailVO);
            if (payableDetailPOS1.size() > 0 && payableDetailPOS1 != null) {
                for (PayableDetailPO payableDetailPO : payableDetailPOS1) {
                    if (payableDetailPO.getOrderId() == null) continue;
                    serviceFeeOrderIds.add(payableDetailPO.getOrderId());
                }
                logger.debug("==================================payableDetailPOS1" + payableDetailPOS1);
                logger.debug("==================================orderIds" + serviceFeeOrderIds);
                logger.debug("================================\u5b58\u5728\u672a\u7f34\u7eb3\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4fee\u6539\u6210\u4ea4\u670d\u52a1\u8d39\u72b6\u6001");
                int i = this.payableDetailMapper.updateStatusByNos(serviceFeeOrderIds, "05");
                logger.debug("================================\u521b\u5efa\u4ed8\u6b3e\u4e2d\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u4ed8\u6b3e\u5355");
                FscPayApplyOrderSubmitReqBo fscPayApplyOrderSubmitReqBo = new FscPayApplyOrderSubmitReqBo();
                BusiApplyPayReqBO busiApplyPayReqBO = new BusiApplyPayReqBO();
                ArrayList<String> serviceFeePayableNos = new ArrayList<String>();
                for (PayableDetailPO payableDetailPO : payableDetailPOS1) {
                    serviceFeePayableNos.add(payableDetailPO.getPayableNo());
                }
                busiApplyPayReqBO.setPayableNos(serviceFeePayableNos);
                BusiApplyPayRspBO submit = this.fscApplyPaySubmitService.submit(busiApplyPayReqBO);
                if (i != 1) {
                    throw new PfscExtBusinessException("18000", "\u6210\u4ea4\u670d\u52a1\u8d39\u4fee\u6539\u5931\u8d25");
                }
                return payableDetailPOS1;
            }
        }
        return null;
    }

    private void updateApplyPayInfo(FscPayApplyOrderSubmitReqBo reqBo) {
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(reqBo.getPayno());
        ArrayList<String> payableNos = new ArrayList<String>();
        for (ApplyDetail applyDetail : applyDetails) {
            payableNos.add(applyDetail.getPayableNo());
        }
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListByIds(payableNos);
        ArrayList<PayableDetailBO> payableDetailBOS = new ArrayList<PayableDetailBO>();
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            PayableDetailBO payableDetailBO = new PayableDetailBO();
            BeanUtils.copyProperties((Object)payableDetailPO, (Object)payableDetailBO);
            payableDetailBOS.add(payableDetailBO);
        }
        reqBo.setPayableDetailBOS(payableDetailBOS);
        List<PayableDetailPO> payableDetailServicePOS = null;
        if (payableDetailPOS.size() > 0 && payableDetailPOS != null) {
            payableDetailServicePOS = this.updateServiceFeePayableStatus(payableDetailPOS);
        }
        ArrayList<PayableDetailBO> payableDetailServiceBOS = new ArrayList<PayableDetailBO>();
        logger.debug("===================================payableDetailServicePOS" + payableDetailServicePOS);
        if (payableDetailServicePOS != null) {
            for (PayableDetailPO payableDetailPO : payableDetailServicePOS) {
                PayableDetailBO payableDetailBO = new PayableDetailBO();
                BeanUtils.copyProperties((Object)payableDetailPO, (Object)payableDetailBO);
                payableDetailServiceBOS.add(payableDetailBO);
            }
        }
        reqBo.setPayableDetailServiceBOS(payableDetailServiceBOS);
        String payno = reqBo.getPayno();
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayno(payno);
        String payStatus = ApplyPayStatus.APPLYING.getCode();
        applyPayInfoPO.setPayStatus(payStatus);
        logger.debug("================================\u4fee\u6539\u4ed8\u6b3e\u5355\u72b6\u6001");
        this.applyPayInfoMapper.updateStatuses(applyPayInfoPO);
        this.fscCreateDoubleLinkApplyService.createDoubleLinkApplyOrder(reqBo);
    }

    private void initParam(FscPayApplyOrderSubmitReqBo reqBo) {
        if (null == reqBo) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayno()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4ed8\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayType()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

