/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.FscPayableAdjustSubmitService;
import com.tydic.pfscext.api.busi.bo.PayableAdjustLogBo;
import com.tydic.pfscext.api.busi.bo.PayableAdjustSubmitReqBo;
import com.tydic.pfscext.api.busi.bo.PayableAdjustSubmitRspBo;
import com.tydic.pfscext.dao.PayableAdjustLogMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayableAdjustSubmitService.class)
public class FscPayableAdjustSubmitServiceImpl
implements FscPayableAdjustSubmitService {
    private static final Logger log = LoggerFactory.getLogger(FscPayableAdjustSubmitServiceImpl.class);
    @Autowired
    private PayableAdjustLogMapper payableAdjustLogMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    public PayableAdjustSubmitRspBo submitPayableAdjust(PayableAdjustSubmitReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u7ed3\u7b97\u4e2d\u5fc3\u5e94\u4ed8\u8c03\u6574\u63d0\u4ea4 \u5165\u53c2\uff1a" + JSON.toString((Object)reqBo));
        }
        if (reqBo.getPayableAdjustLogBos() != null && reqBo.getPayableAdjustLogBos().size() <= 0) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u8c03\u6574\u63d0\u4ea4\u5165\u53c2 \u5e94\u4ed8\u8c03\u6574\u65e5\u5fd7\u4fe1\u606f\u4e0d\u80fd\u672a\u7a7a");
        }
        List payableAdjustLogBos = reqBo.getPayableAdjustLogBos();
        for (PayableAdjustLogBo payableAdjustLogBo : payableAdjustLogBos) {
            payableAdjustLogBo.setAdjustId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        int i = this.payableAdjustLogMapper.insertBatch(payableAdjustLogBos);
        this.updatePayableDetail(reqBo);
        PayableAdjustSubmitRspBo payableAdjustSubmitRspBo = new PayableAdjustSubmitRspBo();
        return payableAdjustSubmitRspBo;
    }

    private void updatePayableDetail(PayableAdjustSubmitReqBo reqBo) {
        PayableDetailPO payableDetailPO;
        PayableAdjustLogBo payableAdjustLogBo = (PayableAdjustLogBo)reqBo.getPayableAdjustLogBos().get(reqBo.getPayableAdjustLogBos().size() - 1);
        BigDecimal adjustedAmt = payableAdjustLogBo.getAdjustedAmt();
        BigDecimal adjustAmt = BigDecimal.ZERO;
        for (PayableAdjustLogBo payableAdjustLogBos : reqBo.getPayableAdjustLogBos()) {
            BigDecimal adjustAmt1 = payableAdjustLogBos.getAdjustAmt();
            adjustAmt = adjustAmt.add(adjustAmt1);
        }
        if (adjustedAmt.compareTo(BigDecimal.ZERO) == -1) {
            throw new PfscExtBusinessException("18000", "\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (adjustedAmt.compareTo(BigDecimal.ZERO) == 0) {
            payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableNo(payableAdjustLogBo.getPayableNo());
            payableDetailPO.setPayableStatus(PayableStatus.SUCCESS.getCode());
            payableDetailPO.setPayableAmt(BigDecimal.ZERO);
            payableDetailPO.setAdjustedAmt(adjustAmt);
            payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
            int i = this.payableDetailMapper.updateByPayableNo(payableDetailPO);
            if (i != 1) {
                throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u5e94\u4ed8\u5355\u72b6\u6001\u5931\u8d25");
            }
        } else {
            payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableNo(payableAdjustLogBo.getPayableNo());
            payableDetailPO.setPayableAmt(adjustedAmt);
            payableDetailPO.setAdjustedAmt(adjustAmt);
            payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
            int i = this.payableDetailMapper.updateByPayableNo(payableDetailPO);
            if (i != 1) {
                throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u5e94\u4ed8\u5355\u72b6\u6001\u5931\u8d25");
            }
        }
    }
}

