/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryApplyPayInfoService;
import com.tydic.pfscext.api.busi.bo.ApplyPayInfoBO;
import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoReqBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.ApproveStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.FinancialStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.enums.WFStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryApplyPayInfoService.class)
public class QueryApplyPayInfoServiceImpl
implements QueryApplyPayInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryApplyPayInfoServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;

    public PfscExtRspPageBaseBO<ApplyPayInfoBO> queryListPage(QueryApplyPayInfoReqBO queryApplyPayInfoReqBO) {
        String orderBy;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + queryApplyPayInfoReqBO.toString());
        }
        logger.debug("=====================================starttime+" + queryApplyPayInfoReqBO.getStartDate());
        logger.debug("=====================================endTime+" + queryApplyPayInfoReqBO.getEndDate());
        logger.debug("======================================applydateend+" + queryApplyPayInfoReqBO.getApplyDateEnd());
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
        if (queryApplyPayInfoReqBO.getSource() != null && !"".equals(queryApplyPayInfoReqBO.getSource())) {
            applyPayInfoVO.setSource(queryApplyPayInfoReqBO.getSource());
        }
        if (!StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = queryApplyPayInfoReqBO.getSortName() + " " + queryApplyPayInfoReqBO.getSortOrder();
        } else {
            orderBy = " PAYNO desc";
        }
        Page page = new Page(queryApplyPayInfoReqBO.getPageNo() < 1 ? 1 : queryApplyPayInfoReqBO.getPageNo(), queryApplyPayInfoReqBO.getPageSize() < 1 ? 10 : queryApplyPayInfoReqBO.getPageSize());
        BeanUtils.copyProperties((Object)queryApplyPayInfoReqBO, (Object)applyPayInfoVO);
        if (queryApplyPayInfoReqBO.getApprovalStatusList() != null && queryApplyPayInfoReqBO.getApprovalStatusList().size() > 0) {
            List approvalStatusList = queryApplyPayInfoReqBO.getApprovalStatusList();
            applyPayInfoVO.setApprovalStatusList(approvalStatusList);
        }
        if (queryApplyPayInfoReqBO.getPayableTypes() != null && queryApplyPayInfoReqBO.getPayableTypes().size() > 0) {
            List payableTypes1 = queryApplyPayInfoReqBO.getPayableTypes();
            applyPayInfoVO.setPayableTypes(payableTypes1);
        }
        applyPayInfoVO.setPurchaseNo(queryApplyPayInfoReqBO.getPurchaseId());
        logger.debug("\u4f9b\u5e94\u5546\uff1a" + queryApplyPayInfoReqBO.getSupId());
        logger.debug("\u4f9b\u5e94\u5546\uff1a" + queryApplyPayInfoReqBO.getIsProfessionalOrgExt());
        ArrayList<Integer> payableTypes = new ArrayList<Integer>();
        ArrayList<Integer> busiModels = new ArrayList<Integer>();
        applyPayInfoVO.setCompanyId(null);
        if ("2".equals(queryApplyPayInfoReqBO.getIsProfessionalOrgExt())) {
            busiModels.add(1);
            applyPayInfoVO.setSupplierId(queryApplyPayInfoReqBO.getCompanyId());
        }
        if ("0".equals(queryApplyPayInfoReqBO.getIsProfessionalOrgExt())) {
            busiModels.add(0);
            applyPayInfoVO.setOperatorId(queryApplyPayInfoReqBO.getCompanyId());
        }
        logger.debug("\u4f9b\u5e94\u5546\uff1a" + applyPayInfoVO.getSupplierId());
        if (queryApplyPayInfoReqBO.getPayableType() != null) {
            applyPayInfoVO.setPayableTypes(null);
        }
        List<ApplyPayInfoVO> applyPayInfoVOs = this.applyPayInfoMapper.selectListPayableList(applyPayInfoVO, (Page<Map<String, Object>>)page, orderBy, payableTypes, busiModels);
        logger.info("==========applyPayInfoVOs========:{}" + JSON.toJSONString(applyPayInfoVOs));
        List<ApplyPayInfoBO> applyPayInfoBOs = new LinkedList<ApplyPayInfoBO>();
        ArrayList<String> payNos = new ArrayList<String>();
        HashMap<Long, String> purchaseMap = new HashMap<Long, String>();
        if (!applyPayInfoVOs.isEmpty()) {
            for (ApplyPayInfoVO payInfoVO : applyPayInfoVOs) {
                PayResultStatus sta;
                String s;
                String payno = payInfoVO.getPayno();
                applyPayInfoVO = payInfoVO;
                payNos.add(payInfoVO.getPayno());
                ApplyPayInfoBO applyPayInfoBO = new ApplyPayInfoBO();
                logger.info("==========\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7==========");
                logger.info("======payInfoVO.getStepId========" + payInfoVO.getStepId());
                applyPayInfoBO.setStepId(payInfoVO.getStepId());
                BeanUtils.copyProperties((Object)applyPayInfoVO, (Object)applyPayInfoBO);
                if (applyPayInfoVO.getPayableType() != null) {
                    applyPayInfoBO.setPaytableTypeStr(PayableType.getInstance(applyPayInfoVO.getPayableType() + "").getDescr());
                }
                if (payInfoVO.getApprovalStatus() != null) {
                    String approvalStatus = payInfoVO.getApprovalStatus();
                    String descr = ApproveStatus.getInstance(approvalStatus).getDescr();
                    applyPayInfoBO.setApprovalStatusDescr(descr);
                }
                if (payInfoVO.getPayType() != null) {
                    if ("1".equals(payInfoVO.getPayType())) {
                        applyPayInfoBO.setPayTypeStr("\u73b0\u6c47");
                    }
                    if ("2".equals(payInfoVO.getPayType())) {
                        applyPayInfoBO.setPayTypeStr("\u94f6\u627f");
                    }
                }
                OrderSource orderSourceEnum = OrderSource.getInstance((String)String.valueOf(applyPayInfoBO.getSource()));
                applyPayInfoBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                String supplierStr = this.organizationInfoService.querySupplierName(applyPayInfoBO.getSupplierId());
                logger.info("supplierStr:=====" + supplierStr);
                logger.info("supplierId:=====" + applyPayInfoBO.getSupplierId());
                applyPayInfoBO.setSupplierStr(supplierStr);
                if (applyPayInfoVO.getPayStatus() != null) {
                    applyPayInfoBO.setPayStatusStr(ApplyPayStatus.getInstance(applyPayInfoVO.getPayStatus().toString()).getDescr());
                }
                if (applyPayInfoVO.getRecOrgId() != null) {
                    if (applyPayInfoVO.getRecOrgId().equals(applyPayInfoVO.getSupplierId())) {
                        applyPayInfoBO.setRecOrgName(supplierStr);
                    } else if (applyPayInfoVO.getRecOrgId().equals(applyPayInfoVO.getOperatorId())) {
                        applyPayInfoBO.setRecOrgName(this.organizationInfoService.queryOrgName(applyPayInfoVO.getPurchaseNo()));
                    } else if (applyPayInfoVO.getRecOrgId().equals(applyPayInfoVO.getPurchaseNo())) {
                        s = this.organizationInfoService.queryOrgName(applyPayInfoVO.getPurchaseNo());
                        applyPayInfoBO.setRecOrgName(s);
                    }
                }
                if (applyPayInfoVO.getPayOrgId() != null) {
                    if (applyPayInfoVO.getPayOrgId().equals(applyPayInfoVO.getPurchaseNo())) {
                        s = this.organizationInfoService.queryOrgName(applyPayInfoVO.getPurchaseNo());
                        applyPayInfoBO.setPayOrgName(s);
                    } else if (applyPayInfoVO.getPayOrgId().equals(applyPayInfoVO.getSupplierId())) {
                        s = this.organizationInfoService.querySupplierName(applyPayInfoVO.getSupplierId());
                        applyPayInfoBO.setPayOrgName(s);
                    } else if (applyPayInfoVO.getPayOrgId().equals(applyPayInfoVO.getOperatorId())) {
                        applyPayInfoBO.setPayOrgName(this.organizationInfoService.queryOrgName(applyPayInfoVO.getPurchaseNo()));
                    }
                }
                String operName = this.userInfoService.queryUserNameByUserId(applyPayInfoBO.getOperatorId());
                applyPayInfoBO.setOperatorName(operName);
                applyPayInfoBO.setBranchCompanyName(this.organizationInfoService.queryOrgName(applyPayInfoVO.getBranchCompany()));
                if (payInfoVO.getPurchaseNo() != null) {
                    if (purchaseMap.get(payInfoVO.getPurchaseNo()) != null) {
                        applyPayInfoBO.setPurchaseName((String)purchaseMap.get(payInfoVO.getPurchaseNo()));
                    } else {
                        String purcahseName = this.organizationInfoService.queryOrgName(payInfoVO.getPurchaseNo());
                        purchaseMap.put(payInfoVO.getPurchaseNo(), purcahseName);
                        applyPayInfoBO.setPurchaseName(purcahseName);
                    }
                }
                if ((sta = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus())) == PayResultStatus.CANCEL || sta == PayResultStatus.SUCCESS) {
                    applyPayInfoBO.setApplyClosed("Y");
                } else {
                    applyPayInfoBO.setApplyClosed("N");
                }
                if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getFinancialStatus())) {
                    applyPayInfoBO.setFinancialStatusDescr(this.enumsService.getDescr(FinancialStatus.getInstance(applyPayInfoBO.getFinancialStatus())));
                }
                if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getApprovalStatus())) {
                    applyPayInfoBO.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(applyPayInfoBO.getApprovalStatus())));
                    if (WFStatus.APPROVAL_COMPLETE.getCode().equals(applyPayInfoBO.getApprovalStatus())) {
                        if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getFinancialStatusDescr())) {
                            applyPayInfoBO.setApprovalStatusDescr(applyPayInfoBO.getApprovalStatusDescr() + "(" + applyPayInfoBO.getFinancialStatusDescr() + ")");
                        } else {
                            applyPayInfoBO.setApprovalStatusDescr(applyPayInfoBO.getApprovalStatusDescr());
                        }
                    }
                }
                applyPayInfoBO.setLastOperator(this.userInfoService.queryUserNameByUserId(applyPayInfoVO.getLastOperator()));
                applyPayInfoBOs.add(applyPayInfoBO);
            }
        }
        if (queryApplyPayInfoReqBO.getIsQryPayableDetail().booleanValue()) {
            applyPayInfoBOs = this.qryPayableDetail(payNos, applyPayInfoBOs);
        }
        rspPageBO.setRows(applyPayInfoBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    public List<ApplyPayInfoBO> qryPayableDetail(List<String> payNos, List<ApplyPayInfoBO> applyPayInfoBOs) {
        if (CollectionUtils.isNotEmpty(payNos)) {
            for (String payno : payNos) {
                List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(payno);
                ArrayList<String> payableNos = new ArrayList<String>();
                for (ApplyDetail applyDetail : applyDetails) {
                    payableNos.add(applyDetail.getPayableNo());
                }
                List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectListByNos(payableNos);
                for (ApplyPayInfoBO applyPayInfoBO : applyPayInfoBOs) {
                    ArrayList<PayableDetailBO> payableDetailBOS = new ArrayList<PayableDetailBO>();
                    if (!payno.equals(applyPayInfoBO.getPayno())) continue;
                    for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                        PayableDetailBO payableDetailBO = new PayableDetailBO();
                        BeanUtils.copyProperties((Object)payableDetailPO, (Object)payableDetailBO);
                        String payableType = payableDetailPO.getPayableType() + "";
                        payableDetailBO.setPayableTypeStr(PayableType.getInstance(payableType).getDescr());
                        payableDetailBOS.add(payableDetailBO);
                    }
                    applyPayInfoBO.setPayableDetailBOS(payableDetailBOS);
                }
            }
        }
        return applyPayInfoBOs;
    }
}

