/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.deal.FscPayableOrderTimeoutTaskService;
import com.tydic.pfscext.api.deal.bo.FscPayableOrderTimeoutTaskReqBO;
import com.tydic.pfscext.api.deal.bo.FscPayableOrderTimeoutTaskRspBO;
import com.tydic.pfscext.dao.PayConfigDetailMapper;
import com.tydic.pfscext.dao.PayConfigMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayConfig;
import com.tydic.pfscext.dao.po.PayConfigDetail;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.LiquidatedDamagesStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayableOrderTimeoutTaskService.class)
public class FscPayableOrderTimeoutTaskServiceImpl
implements FscPayableOrderTimeoutTaskService {
    private static final Logger logger = LoggerFactory.getLogger(FscPayableOrderTimeoutTaskServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayConfigDetailMapper payConfigDetailMapper;
    @Autowired
    private PayConfigMapper payConfigMapper;

    public FscPayableOrderTimeoutTaskRspBO dealTimeoutOrder(FscPayableOrderTimeoutTaskReqBO reqBO) {
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectToBePaidList();
        FscPayableOrderTimeoutTaskRspBO rspBo = new FscPayableOrderTimeoutTaskRspBO();
        if (payableDetailPOS.size() == 0) {
            logger.debug("\u65e0\u672a\u4ed8\u6b3e\u8ba2\u5355\uff01");
            throw new PfscExtBusinessException("18000", "\u65e0\u672a\u4ed8\u6b3e\u8ba2\u5355\uff01");
        }
        logger.debug("\u672a\u4ed8\u6b3e\u8ba2\u5355\uff1a" + payableDetailPOS.toString());
        HashSet<Long> payOrgIdSet = new HashSet<Long>();
        ArrayList<Long> payOrgIdList = new ArrayList<Long>();
        for (PayableDetailPO payableDetail : payableDetailPOS) {
            payOrgIdSet.add(payableDetail.getPayOrgId());
        }
        payOrgIdList.addAll(payOrgIdSet);
        List<PayConfigDetail> payConfigDetails = this.payConfigDetailMapper.selectPayConfigDetailList(payOrgIdList);
        logger.debug("\u652f\u4ed8\u914d\u7f6e\u8be6\u60c5PAY_CONFIG_DETAIL\uff1a" + payConfigDetails.toString());
        HashMap<Long, PayConfigDetail> payConfigDetailMap = new HashMap<Long, PayConfigDetail>(16);
        if (payConfigDetails.size() != 0) {
            for (PayConfigDetail payConfigDetail : payConfigDetails) {
                payConfigDetailMap.put(payConfigDetail.getExceptId(), payConfigDetail);
            }
        }
        List<PayConfig> payConfigs = this.payConfigMapper.selectPayConfigList();
        logger.debug("\u652f\u4ed8\u914d\u7f6ePAY_CONFIG\uff1a" + payConfigs.toString());
        Date now = new Date();
        for (PayableDetailPO payableDetail : payableDetailPOS) {
            Date paidDate = payableDetail.getPaidDate();
            if (now.getTime() <= paidDate.getTime()) continue;
            try {
                PayableDetailPO payableDetailPO;
                int overdueDays = (int)((now.getTime() - paidDate.getTime()) / 86400000L);
                BigDecimal payableAmt = payableDetail.getPayableAmt();
                BigDecimal overdueRate = null;
                PayConfigDetail payConfigDetail = (PayConfigDetail)payConfigDetailMap.get(payableDetail.getPayOrgId());
                if (payConfigDetail != null) {
                    overdueRate = payConfigDetail.getOverdueRate();
                } else {
                    PayConfig payConfig = payConfigs.get(0);
                    overdueRate = payConfig.getOverdueRate();
                }
                BigDecimal interestPerDay = payableAmt.multiply(overdueRate);
                BigDecimal interest = interestPerDay.multiply(new BigDecimal(overdueDays));
                payableDetail.setOverduePenalty(interest);
                payableDetail.setOverdueDays(overdueDays);
                payableDetail.setRemarks("\u8d85\u671f\u672a\u652f\u4ed8");
                this.payableDetailMapper.updateToBePaidPayable(payableDetail);
                logger.debug("\u5e94\u4ed8\u5355[" + payableDetail.getPayableNo() + "]\u751f\u6210\u903e\u671f\u5229\u606f");
                if (overdueDays == 1) {
                    payableDetailPO = new PayableDetailPO();
                    String payAbleNo = this.getPayInfoId(this.getPayInfoId(PayableType.LAGGED.getCode()));
                    BigDecimal defaultValue = BigDecimal.ZERO;
                    payableDetailPO.setPaidAmt(defaultValue);
                    payableDetailPO.setPendingAmt(defaultValue);
                    payableDetailPO.setNeedAgainstAmt(defaultValue);
                    payableDetailPO.setOverduePenalty(defaultValue);
                    payableDetailPO.setOverdueDays(0);
                    payableDetailPO.setApproveStatus(Integer.valueOf(LiquidatedDamagesStatus.GENERATED.getCode()));
                    payableDetailPO.setEffectiveStatus(1);
                    payableDetailPO.setMemberId(reqBO.getUserId());
                    payableDetailPO.setMemberName(reqBO.getName());
                    payableDetailPO.setPayableNo(payAbleNo);
                    payableDetailPO.setPayableAmt(interest);
                    payableDetailPO.setOrderAmt(interest);
                    payableDetailPO.setOverduePenalty(interest);
                    payableDetailPO.setSupplierId(payableDetail.getSupplierId());
                    payableDetailPO.setOperatorId(payableDetail.getOperatorId());
                    payableDetailPO.setPurchaseNo(payableDetail.getPurchaseNo());
                    payableDetailPO.setRecOrgId(payableDetail.getRecOrgId());
                    payableDetailPO.setPayOrgId(payableDetail.getPayOrgId());
                    payableDetailPO.setPayableType(Integer.valueOf(PayableType.LAGGED.getCode()));
                    payableDetailPO.setPaidDate(new Date(now.getTime() + 259200000L));
                    payableDetailPO.setPayType(PayablePayType.PAY.getCode());
                    payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
                    payableDetailPO.setMobile(payableDetail.getMobile());
                    payableDetailPO.setPurchaseOrderCode(payableDetail.getPurchaseOrderCode());
                    payableDetailPO.setPurchaseOrderName(payableDetail.getPurchaseOrderName());
                    payableDetailPO.setOrderId(payableDetail.getOrderId());
                    payableDetailPO.setSource(payableDetail.getSource());
                    this.payableDetailMapper.insert(payableDetailPO);
                    logger.debug("[" + payableDetail.getPayableNo() + "] \u751f\u6210\u903e\u671f\u5e94\u4ed8\u5355" + payableDetailPO.toString());
                    continue;
                }
                payableDetailPO = this.payableDetailMapper.selectByPurchaseOrderCode(payableDetail.getPurchaseOrderCode());
                payableDetailPO.setPayableAmt(interest);
                payableDetailPO.setOrderAmt(interest);
                payableDetailPO.setPaidDate(new Date(now.getTime() + 259200000L));
                this.payableDetailMapper.updateByPayableDetail(payableDetailPO);
                logger.debug("[" + payableDetail.getPayableNo() + "] \u66f4\u65b0\u903e\u671f\u5e94\u4ed8\u5355" + payableDetailPO.toString());
            }
            catch (Exception e) {
                logger.error("[" + payableDetail.getPayableNo() + "] \u751f\u6210\u903e\u671f\u8fdd\u7ea6\u91d1\u5f02\u5e38");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String getPayInfoId(String payableType) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String prefix = "YFDH-DD";
            PayableType payAbleStatus = PayableType.getInstance(payableType);
            if (payAbleStatus != null) {
                prefix = payAbleStatus.getPayableNoPrefix();
            }
            String maxNum = this.payableDetailMapper.selectMaxPayAbleNoNum(prefix + "-" + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append("-").append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

