/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.api.trade.QueryOverduePenaltyListService;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApproveResult;
import com.tydic.pfscext.enums.LiquidatedDamagesStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryOverduePenaltyListService.class)
public class QueryOverduePenaltyListServiceImpl
implements QueryOverduePenaltyListService {
    private static final Logger logger = LoggerFactory.getLogger(QueryOverduePenaltyListServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public PfscExtRspPageBaseBO<PayableDetailBO> queryListPage(QueryPayableDetailReqBO reqBO) {
        logger.debug("--\u903e\u671f\u8fdd\u7ea6\u91d1\u5165\u53c2--" + reqBO.toString());
        PfscExtRspPageBaseBO rspPageBaseBO = new PfscExtRspPageBaseBO();
        try {
            if (reqBO.getSupId() != null && !reqBO.getSupId().equals("") && reqBO.getSupplierId() == null) {
                reqBO.setSupplierId(reqBO.getSupId());
            }
            String orderBy = null;
            if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
                if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                    logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                    throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                }
                orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
            } else {
                orderBy = " PAYABLE_NO desc";
            }
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)payableDetailPO);
            ArrayList<PayableDetailBO> payableDetailBOs = new ArrayList<PayableDetailBO>();
            List<PayableDetailPO> payableDetailPOList = this.payableDetailMapper.getOverdueListPage(payableDetailPO, (Page<Map<String, Object>>)page, orderBy);
            if (payableDetailPOList != null && payableDetailPOList.size() > 0) {
                ArrayList<String> saleCodes = new ArrayList<String>();
                HashMap<String, SaleOrderInfo> maps = new HashMap<String, SaleOrderInfo>();
                for (PayableDetailPO payableDetail : payableDetailPOList) {
                    if (payableDetail.getPurchaseOrderCode() == null || saleCodes.contains(payableDetail.getPurchaseOrderCode())) continue;
                    saleCodes.add(payableDetail.getPurchaseOrderCode());
                }
                if (saleCodes.size() > 0) {
                    SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                    saleOrderInfoVO.setSaleOrderCodeList(saleCodes);
                    List<SaleOrderInfo> saleOrderInfoVOs = this.saleOrderInfoMapper.getListJoin(saleOrderInfoVO);
                    for (SaleOrderInfo saleOrderInfo : saleOrderInfoVOs) {
                        maps.put(saleOrderInfo.getSaleOrderCode(), saleOrderInfo);
                    }
                }
                for (PayableDetailPO payableDetail : payableDetailPOList) {
                    PayableDetailBO payableDetailBO = new PayableDetailBO();
                    BeanUtils.copyProperties((Object)payableDetail, (Object)payableDetailBO);
                    String purchaseName = this.organizationInfoService.queryOrgName(payableDetail.getPurchaseNo());
                    payableDetailBO.setPurchaseName(purchaseName);
                    if (payableDetail.getOrderId() != null) {
                        payableDetailBO.setOrderId(payableDetail.getOrderId().toString());
                    }
                    if (maps.get(payableDetail.getPurchaseOrderCode()) != null) {
                        payableDetailBO.setSaleVoucherId(((SaleOrderInfo)maps.get(payableDetail.getPurchaseOrderCode())).getPurchaseOrderId());
                    }
                    if (payableDetail.getApproveStatus() != null) {
                        payableDetailBO.setApproveStatusStr(LiquidatedDamagesStatus.getInstance(payableDetail.getApproveStatus().toString()).getDescr());
                    }
                    if (payableDetail.getApproveResult() != null) {
                        payableDetailBO.setApproveResultStr(ApproveResult.getInstance(payableDetail.getApproveResult().toString()).getDescr());
                    }
                    payableDetailBOs.add(payableDetailBO);
                }
            }
            rspPageBaseBO.setRespCode("0000");
            rspPageBaseBO.setRespDesc("\u6210\u529f");
            rspPageBaseBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPageBaseBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPageBaseBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspPageBaseBO.setRows(payableDetailBOs);
        }
        catch (Exception e) {
            logger.error("\u903e\u671f\u91d1\u989d\u5217\u8868\u670d\u52a1\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u903e\u671f\u91d1\u989d\u5217\u8868\u670d\u52a1\u67e5\u8be2\u5931\u8d25");
        }
        return rspPageBaseBO;
    }
}

