/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.api.trade.UpdateOverduePenaltyService;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.LiquidatedDamagesStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.trade.impl.QueryOverduePenaltyDetailsServiceImpl;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=UpdateOverduePenaltyService.class)
public class UpdateOverduePenaltyServiceImpl
implements UpdateOverduePenaltyService {
    private static final Logger logger = LoggerFactory.getLogger(QueryOverduePenaltyDetailsServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    public PfscExtRspBaseBO updateDetails(QueryPayableDetailReqBO querypayableDetailReqBO) {
        if (querypayableDetailReqBO.getPayableNos() == null || querypayableDetailReqBO.getPayableNos().size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5e94\u4ed8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (querypayableDetailReqBO.getApproveStatus() == null) {
            throw new PfscExtBusinessException("18000", "\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        Date now = new Date();
        PayableDetailVO payableDetailPO = new PayableDetailVO();
        payableDetailPO.setApproveTime(now);
        payableDetailPO.setApproveUserId(querypayableDetailReqBO.getUserId());
        payableDetailPO.setApproveUserName(querypayableDetailReqBO.getName());
        payableDetailPO.setApproveResult(querypayableDetailReqBO.getApproveResult());
        if (3 == querypayableDetailReqBO.getApproveResult()) {
            payableDetailPO.setApproveStatus(Integer.valueOf(LiquidatedDamagesStatus.TO_BE_PROCESSED.getCode()));
        } else if (1 == querypayableDetailReqBO.getApproveResult()) {
            payableDetailPO.setApproveStatus(Integer.valueOf(LiquidatedDamagesStatus.TO_BE_PAID.getCode()));
        } else if (2 == querypayableDetailReqBO.getApproveResult()) {
            payableDetailPO.setPaidDate(new Date(now.getTime() + 259200000L));
            payableDetailPO.setApproveStatus(Integer.valueOf(LiquidatedDamagesStatus.GENERATED.getCode()));
        }
        this.payableDetailMapper.updateByNOsBatch(querypayableDetailReqBO.getPayableNos(), payableDetailPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

