/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiOrderRefundService;
import com.tydic.pfscext.api.busi.bo.BusiOrderRefundReqBO;
import com.tydic.pfscext.api.busi.bo.BusiOrderRefundRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.base.BasePayService;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.dao.TranDetailMapper;
import com.tydic.pfscext.dao.po.TranDetail;
import com.tydic.pfscext.enums.BusinessType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.AccountantEngineService;
import com.tydic.pfscext.service.atom.SubAccountService;
import com.tydic.pfscext.service.atom.bo.AccountantEngineReqBO;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiOrderRefundService.class)
public class BusiOrderRefundPayServiceImpl
extends BasePayService<BusiOrderRefundRspBO>
implements BusiOrderRefundService {
    private static final Logger logger = LoggerFactory.getLogger(BusiOrderRefundPayServiceImpl.class);
    @Autowired
    private TranDetailMapper tranDetailMapper;
    @Autowired
    private AccountantEngineService accEngineService;
    @Autowired
    private SubAccountService subAccountService;

    public BusiOrderRefundRspBO makingOrderRefund(BusiOrderRefundReqBO reqBO) {
        BusiOrderRefundRspBO rspBO = (BusiOrderRefundRspBO)this.queryRspOrSaveLog((PfscExtReqBaseBO)reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        try {
            rspBO = this.process(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((PfscExtReqBaseBO)reqBO, e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        this.updateLog((PfscExtReqBaseBO)reqBO, rspBO);
        return rspBO;
    }

    public BusiOrderRefundRspBO process(BusiOrderRefundReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getOrderNo()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u9500\u552e\u8ba2\u5355ID[orderNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderCode()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u7f16\u53f7[saleOrderCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusinessType()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u7c7b\u578b[businessType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperatingUnitNo()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u8fd0\u8425\u673a\u6784\u7f16\u53f7[operatingUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaseUnitNo()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7[purchaseUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaseBookNo()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u91c7\u8d2d\u5355\u4f4d\u5e10\u5957\u7f16\u53f7[purchaseBookNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getRefundAmt()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u9000\u6b3e\u91d1\u989d[refundAmt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTxnNo()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1-\u539f\u4ea4\u6613\u6d41\u6c34\u53f7[txnNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String serviceNo = reqBO.getSaleOrderCode();
        SubAcctInfoExt subAcctInfo = this.subAccountService.getWithMainAccount(reqBO.getOperatingUnitNo(), reqBO.getSource(), reqBO.getPurchaseUnitNo(), reqBO.getPurchaseBookNo(), null);
        if (subAcctInfo == null) {
            logger.error("\u627e\u4e0d\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u3002\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237");
        }
        BigDecimal payAmt = BigDecimal.ZERO;
        List<TranDetail> tranPayDetails = this.tranDetailMapper.selectByBusiTypeAndServiceNo(BusinessType.ORDER_PAY.getCode(), serviceNo);
        if (tranPayDetails != null) {
            for (TranDetail payDetail : tranPayDetails) {
                payAmt = payAmt.add(payDetail.getTranAmt());
            }
        }
        BigDecimal refundAmt = BigDecimal.ZERO;
        List<TranDetail> tranRefundDetails = this.tranDetailMapper.selectByBusiTypeAndServiceNo(BusinessType.REFUND.getCode(), serviceNo);
        if (tranRefundDetails != null) {
            for (TranDetail refundDetail : tranRefundDetails) {
                refundAmt = refundAmt.add(refundDetail.getTranAmt());
            }
        }
        logger.debug("\u8ba2\u5355\u9000\u6b3e\u662f\u5426\u5df2\u9000\u6821\u9a8c\uff0c\u652f\u4ed8\u603b\u91d1\u989d\uff1a" + payAmt + "\uff0c\u9000\u6b3e\u603b\u91d1\u989d\uff1a" + refundAmt);
        if (payAmt.compareTo(refundAmt) == 0) {
            logger.debug("\u8ba2\u5355\u9000\u6b3e\u5df2\u9000\uff0c\u8fd4\u56de\u6210\u529f");
            BusiOrderRefundRspBO bo = new BusiOrderRefundRspBO();
            bo.setIsSuccess(Boolean.valueOf(true));
            return bo;
        }
        BigDecimal totalPayAmt = BigDecimal.ZERO;
        BigDecimal totalRefundAmt = BigDecimal.ZERO;
        List<TranDetail> tranDetails = this.tranDetailMapper.selectByBusiTypeAndServiceNo(null, serviceNo);
        for (TranDetail tranDetail : tranDetails) {
            if (subAcctInfo.getSubAcctNo().equals(tranDetail.getPayAcctNo())) {
                totalPayAmt = totalPayAmt.add(tranDetail.getTranAmt());
                continue;
            }
            if (!subAcctInfo.getSubAcctNo().equals(tranDetail.getRecvAcctNo())) continue;
            totalRefundAmt = totalRefundAmt.add(tranDetail.getTranAmt());
        }
        if (totalPayAmt.subtract(totalRefundAmt).compareTo(reqBO.getRefundAmt()) < 0) {
            throw new PfscExtBusinessException("18000", "\u53ef\u9000\u91d1\u989d\u4e0d\u8db3\uff1a\u672c\u6b21\u9000\u6b3e\u91d1\u989d" + reqBO.getRefundAmt() + "\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u6b3e\u989d\u5ea6" + totalPayAmt.subtract(totalRefundAmt));
        }
        AccountantEngineReqBO accEngineReqBO = new AccountantEngineReqBO();
        accEngineReqBO.setBusinessType(String.valueOf(reqBO.getBusinessType()));
        accEngineReqBO.setClientAcctNo(subAcctInfo.getSubAcctNo());
        accEngineReqBO.setSource(reqBO.getSource());
        accEngineReqBO.setOperUnit(reqBO.getOperatingUnitNo());
        accEngineReqBO.setProjectId(reqBO.getProjectId());
        LinkedList<BigDecimal> amounts = new LinkedList<BigDecimal>();
        amounts.add(reqBO.getRefundAmt());
        accEngineReqBO.setAmounts(amounts);
        accEngineReqBO.setServiceNo(serviceNo);
        accEngineReqBO.setOrgId(reqBO.getPurchaseUnitNo());
        List<Long> txnNo = null;
        try {
            txnNo = this.accEngineService.executeAccountantEngine(accEngineReqBO);
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u5f02\u5e38\u3002" + e.getMessage());
        }
        BusiOrderRefundRspBO bo = new BusiOrderRefundRspBO();
        bo.setTxnNo(String.valueOf(txnNo.get(0)));
        bo.setIsSuccess(Boolean.valueOf(true));
        return bo;
    }

    @Override
    protected BusiOrderRefundRspBO fillRspBO(String respPackage) {
        BusiOrderRefundRspBO rspBO = new BusiOrderRefundRspBO();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.containsKey((Object)"respCode") ? jsonObject.getString("respCode") : null);
        rspBO.setRespDesc(jsonObject.containsKey((Object)"respDesc") ? jsonObject.getString("respDesc") : null);
        rspBO.setTxnNo(jsonObject.containsKey((Object)"txnNo") ? jsonObject.getString("txnNo") : null);
        rspBO.setIsSuccess(jsonObject.containsKey((Object)"isSuccess") ? Boolean.valueOf(jsonObject.getString("isSuccess")) : null);
        return rspBO;
    }
}

