/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.FscWfQueryAuditListBusiService;
import com.tydic.pfscext.api.busi.bo.FscWfQueryAuditListBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscWfQueryAuditListBusiRspBO;
import com.tydic.pfscext.api.busi.bo.QueryApprListRspBO;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.EntryTotalInfoMapper;
import com.tydic.pfscext.dao.OutstockTotalMapper;
import com.tydic.pfscext.dao.RecAmtConfirmMapper;
import com.tydic.pfscext.dao.WorkFlowDataMapper;
import com.tydic.pfscext.dao.WorkFlowParamMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.EntryTotalInfoPO;
import com.tydic.pfscext.dao.po.OutstockTotal;
import com.tydic.pfscext.dao.po.RecAmtConfirm;
import com.tydic.pfscext.dao.po.WorkFlowDataInfo;
import com.tydic.pfscext.dao.po.WorkFlowParamInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.EntryTotalInfoVO;
import com.tydic.pfscext.dao.vo.WorkFlowDataInfoVO;
import com.tydic.pfscext.enums.WFBillType;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import com.tydic.pfscext.utils.FscCommonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscWfQueryAuditListBusiService.class)
public class FscWfQueryAuditListBusiServiceImpl
implements FscWfQueryAuditListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfQueryAuditListBusiServiceImpl.class);
    private WorkFlowDataMapper workFlowDataMapper;
    private WorkFlowParamMapper workFlowParamMapper;
    private RecAmtConfirmMapper recAmtConfirmMapper;
    private EntryTotalInfoMapper entryTotalInfoMapper;
    private ApplyPayInfoMapper applyPayInfoMapper;
    private OrganizationInfoService organizationInfoService;
    private OutstockTotalMapper outstockTotalMapper;
    private BillApplyInfoMapper billApplyInfoMapper;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private DictionaryAtomService dictionaryAtomService;
    private UserInfoService userInfoService;

    @Autowired
    public FscWfQueryAuditListBusiServiceImpl(WorkFlowDataMapper workFlowDataMapper, WorkFlowParamMapper workFlowParamMapper, RecAmtConfirmMapper recAmtConfirmMapper, EntryTotalInfoMapper entryTotalInfoMapper, ApplyPayInfoMapper applyPayInfoMapper, OrganizationInfoService organizationInfoService, OutstockTotalMapper outstockTotalMapper, BillApplyInfoMapper billApplyInfoMapper, AdvanceReceiveMapper advanceReceiveMapper, DictionaryAtomService dictionaryAtomService, UserInfoService userInfoService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.workFlowParamMapper = workFlowParamMapper;
        this.recAmtConfirmMapper = recAmtConfirmMapper;
        this.entryTotalInfoMapper = entryTotalInfoMapper;
        this.applyPayInfoMapper = applyPayInfoMapper;
        this.organizationInfoService = organizationInfoService;
        this.outstockTotalMapper = outstockTotalMapper;
        this.billApplyInfoMapper = billApplyInfoMapper;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.dictionaryAtomService = dictionaryAtomService;
        this.userInfoService = userInfoService;
    }

    public FscWfQueryAuditListBusiRspBO queryAuditList(FscWfQueryAuditListBusiReqBO reqBO) {
        List<QueryApprListRspBO> apprListRspBOList;
        FscWfQueryAuditListBusiRspBO rspBO = new FscWfQueryAuditListBusiRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        List<String> busiCodeList = this.getBusiCodeList(reqBO);
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        WorkFlowDataInfoVO workFlowDataInfoVO = new WorkFlowDataInfoVO();
        workFlowDataInfoVO.setBillType(reqBO.getBillType());
        workFlowDataInfoVO.setLastOperator(StringUtils.hasText((String)reqBO.getLastOperator()) ? Long.valueOf(reqBO.getLastOperator()) : null);
        workFlowDataInfoVO.setStatus(reqBO.getStatus());
        workFlowDataInfoVO.setFinancialStatus(reqBO.getFinancialStatus());
        workFlowDataInfoVO.setBillNo(reqBO.getBillNo());
        workFlowDataInfoVO.setSortName(reqBO.getSortName());
        workFlowDataInfoVO.setSortOrder(reqBO.getSortOrder());
        switch (reqBO.getAuditFlag()) {
            case 0: {
                apprListRspBOList = this.qryTodoList(reqBO, workFlowDataInfoVO, busiCodeList, (Page<WorkFlowDataInfo>)page);
                break;
            }
            case 1: {
                apprListRspBOList = this.qryApprovedAndArchivedList(reqBO, workFlowDataInfoVO, busiCodeList, (Page<WorkFlowDataInfo>)page);
                break;
            }
            default: {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u672a\u77e5\u7684\u67e5\u8be2\u7c7b\u578b");
                return rspBO;
            }
        }
        rspBO.setRows(apprListRspBOList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u5217\u8868\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private List<String> getBusiCodeList(FscWfQueryAuditListBusiReqBO reqBO) {
        ArrayList<String> busiCodeList = new ArrayList<String>();
        if (StringUtils.hasText((String)reqBO.getBillType())) {
            WorkFlowParamInfo workFlowParamInfo = new WorkFlowParamInfo();
            workFlowParamInfo.setBillType(reqBO.getBillType());
            WorkFlowParamInfo paramInfo = this.workFlowParamMapper.getModelBy(workFlowParamInfo);
            if (null != paramInfo) {
                busiCodeList.add(paramInfo.getBusinessType());
            } else {
                LOGGER.info("\u83b7\u53d6\u5355\u636e\u7c7b\u578b" + reqBO.getBillType() + "\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (WFBillType.SUPPLIER_PAY_INCOME_CALC.getCode().equals(reqBO.getBillType()) || WFBillType.SUPPLIER_PAY_INCOME_RED_CALC.getCode().equals(reqBO.getBillType())) {
                workFlowParamInfo.setBillType(WFBillType.COLLECTION_CONFIRMATION.getCode());
                paramInfo = this.workFlowParamMapper.getModelBy(workFlowParamInfo);
                if (null != paramInfo) {
                    busiCodeList.add(paramInfo.getBusinessType());
                }
            }
        }
        return busiCodeList;
    }

    private List<QueryApprListRspBO> qryTodoList(FscWfQueryAuditListBusiReqBO reqBO, WorkFlowDataInfoVO obj, List<String> busiCodeList, Page<WorkFlowDataInfo> page) {
        List<WorkFlowDataInfo> todoApprovalList = this.workFlowDataMapper.qryTodoApprovalList(FscCommonUtils.long2String((Long)reqBO.getUserId()), obj, busiCodeList, page);
        return this.dealResult(reqBO, todoApprovalList);
    }

    private List<QueryApprListRspBO> qryApprovedAndArchivedList(FscWfQueryAuditListBusiReqBO reqBO, WorkFlowDataInfoVO obj, List<String> busiCodeList, Page<WorkFlowDataInfo> page) {
        List<WorkFlowDataInfo> archivedApprovalList = this.workFlowDataMapper.qryApprovedAndArchivedList(FscCommonUtils.long2String((Long)reqBO.getUserId()), reqBO.getSearchType(), obj, busiCodeList, page);
        return this.dealResult(reqBO, archivedApprovalList);
    }

    private List<QueryApprListRspBO> dealResult(FscWfQueryAuditListBusiReqBO reqBO, List<WorkFlowDataInfo> workFlowDatas) {
        ArrayList<QueryApprListRspBO> list = new ArrayList<QueryApprListRspBO>();
        for (WorkFlowDataInfo workFlowData : workFlowDatas) {
            Object orgName;
            BigDecimal applyAmt;
            List<BillApplyInfo> billApplyInfoList;
            BillApplyInfoVO billApplyInfoVO;
            String orgName2;
            RecAmtConfirm rac;
            QueryApprListRspBO listbo = new QueryApprListRspBO();
            if (workFlowData == null) continue;
            String name = this.userInfoService.queryUserNameByUserId(workFlowData.getLastOperator());
            listbo.setLastOperator(name);
            if (WFBillType.COLLECTION_CONFIRMATION.getCode().equals(workFlowData.getBillType())) {
                rac = this.recAmtConfirmMapper.selectByPrimaryKey(Long.parseLong(workFlowData.getBillNo()));
                if (null != rac) {
                    listbo.setMoney(rac.getSumAmt());
                    orgName2 = this.organizationInfoService.queryOrgName(rac.getOrgId());
                    listbo.setCompanyName(orgName2);
                } else {
                    LOGGER.info("\u672a\u627e\u5230\u8be5\u6536\u6b3e\u786e\u8ba4\u5355\u636e\u7f16\u53f7" + workFlowData.getBillNo() + "\u7684\u4fe1\u606f");
                }
            } else if (WFBillType.PAY_APPLICATION.getCode().equals(workFlowData.getBillType())) {
                ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(workFlowData.getBillNo());
                if (null != applyPayInfoPO) {
                    listbo.setMoney(applyPayInfoPO.getPayAmt());
                    orgName2 = this.organizationInfoService.queryOrgName(applyPayInfoPO.getCompanyId());
                    listbo.setCompanyName(orgName2);
                } else {
                    LOGGER.info("\u672a\u627e\u5230\u8be5\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u7f16\u53f7" + workFlowData.getBillNo() + "\u7684\u4fe1\u606f");
                }
            } else if (WFBillType.PURCHASE_STORAGE.getCode().equals(workFlowData.getBillType())) {
                EntryTotalInfoVO vo = new EntryTotalInfoVO();
                vo.setApplyNo(workFlowData.getBillNo());
                EntryTotalInfoPO entryTotalInfoPO = this.entryTotalInfoMapper.getModelById(vo);
                if (null != entryTotalInfoPO) {
                    listbo.setMoney(entryTotalInfoPO.getNotTaxAmt());
                    String orgName3 = this.organizationInfoService.queryOrgName(entryTotalInfoPO.getCompanyId());
                    listbo.setCompanyName(orgName3);
                } else {
                    LOGGER.info("\u672a\u627e\u5230\u8be5\u7269\u8d44\u6c47\u603b\u5355\u636e\u7f16\u53f7" + workFlowData.getBillNo() + "\u7684\u4fe1\u606f");
                }
            } else if (WFBillType.OUTBOUND_COLLECTION.getCode().equals(workFlowData.getBillType())) {
                OutstockTotal outstockTotal = this.outstockTotalMapper.selectByPrimaryKey(workFlowData.getBillNo());
                if (outstockTotal != null) {
                    listbo.setMoney(outstockTotal.getUntaxAmt().add(outstockTotal.getTaxAmt()));
                    orgName2 = this.organizationInfoService.queryOrgName(outstockTotal.getOrgId());
                    listbo.setCompanyName(orgName2);
                } else {
                    LOGGER.info("\u672a\u627e\u5230\u8be5\u5e93\u5b58\u6c47\u603b\u5355\u636e\u7f16\u53f7" + workFlowData.getBillNo() + "\u7684\u4fe1\u606f");
                }
            } else if (WFBillType.SUPPLIER_PAY_COLLECTION_CONFIRMATION.getCode().equals(workFlowData.getBillType())) {
                rac = this.recAmtConfirmMapper.selectByPrimaryKey(Long.parseLong(workFlowData.getBillNo()));
                if (null != rac) {
                    listbo.setMoney(rac.getSumAmt());
                    orgName2 = this.organizationInfoService.queryOrgName(rac.getOrgId());
                    listbo.setCompanyName(orgName2);
                }
            } else if (WFBillType.SUPPLIER_PAY_INCOME_CALC.getCode().equals(workFlowData.getBillType())) {
                if (workFlowData.getBillNo().startsWith("KPSQ")) {
                    BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(workFlowData.getBillNo());
                    if (null != billApplyInfo) {
                        listbo.setMoney(billApplyInfo.getAmt());
                        orgName2 = this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo());
                        listbo.setCompanyName(orgName2);
                    }
                } else if (workFlowData.getBillNo().startsWith("SRJS")) {
                    billApplyInfoVO = new BillApplyInfoVO();
                    billApplyInfoVO.setBillNo(workFlowData.getBillNo());
                    billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
                    applyAmt = BigDecimal.ZERO;
                    for (BillApplyInfo billApply : billApplyInfoList) {
                        applyAmt = applyAmt.add(billApply.getAmt());
                    }
                    listbo.setMoney(applyAmt);
                    orgName = this.organizationInfoService.queryOrgName(reqBO.getOrgId());
                    listbo.setCompanyName((String)orgName);
                }
            } else if (WFBillType.DISTRIBUTE_COLLECTION_CONFIRMATION.getCode().equals(workFlowData.getBillType())) {
                rac = this.recAmtConfirmMapper.selectByPrimaryKey(Long.parseLong(workFlowData.getBillNo()));
                if (null != rac) {
                    listbo.setMoney(rac.getSumAmt());
                    orgName2 = this.organizationInfoService.queryOrgName(rac.getOrgId());
                    listbo.setCompanyName(orgName2);
                }
            } else if (WFBillType.SUPPLIER_PAY_INCOME_RED_CALC.getCode().equals(workFlowData.getBillType())) {
                billApplyInfoVO = new BillApplyInfoVO();
                billApplyInfoVO.setBillNo(workFlowData.getBillNo());
                billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
                applyAmt = BigDecimal.ZERO;
                for (BillApplyInfo billApply : billApplyInfoList) {
                    applyAmt = applyAmt.add(billApply.getAmt());
                }
                listbo.setMoney(applyAmt);
                orgName = this.organizationInfoService.queryOrgName(reqBO.getOrgId());
                listbo.setCompanyName((String)orgName);
            } else if (WFBillType.HANDMADE_COLLECTION.getCode().equals(workFlowData.getBillType())) {
                AdvanceReceive selectByPrimaryKey = this.advanceReceiveMapper.selectByPrimaryKey(Long.valueOf(workFlowData.getBillNo()));
                listbo.setMoney(selectByPrimaryKey.getTranAmt());
                orgName2 = this.organizationInfoService.queryOrgName(selectByPrimaryKey.getRecOrgId());
                listbo.setCompanyName(orgName2);
            }
            listbo.setBillNo(workFlowData.getBillNo());
            listbo.setReceiveDate(workFlowData.getReceiveDate());
            listbo.setStatus(workFlowData.getStatus());
            listbo.setProcinstId(workFlowData.getProcInstId());
            listbo.setBillType(workFlowData.getBillType());
            listbo.setBillTypeDescr(this.getTrans("WF_BILL_TYPE", workFlowData.getBillType()));
            listbo.setApplyDate(workFlowData.getApplyDate());
            listbo.setStatusDescr(this.getTrans("D_WORKFLOW_DATA_STATUS", workFlowData.getStatus()));
            listbo.setFinancialStatusDescr(this.getTrans("D_WORKFLOW_DATA_FINANCIAL_STATUS", workFlowData.getFinancialStatus()));
            listbo.setFinancialStatus(workFlowData.getFinancialStatus());
            listbo.setResultdesc(workFlowData.getResultdesc());
            list.add(listbo);
        }
        return list;
    }

    private String getTrans(String pcode, String code) {
        if (StringUtils.hasText((String)code)) {
            DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
            dictionaryAtomReqBo.setpCode(pcode);
            dictionaryAtomReqBo.setCode(code);
            DictionaryAtomRspBo dictionaryAtomRspBo = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
            if (null != dictionaryAtomRspBo && null != dictionaryAtomRspBo.getData()) {
                return dictionaryAtomRspBo.getData().get(code);
            }
        }
        return "";
    }

    private String validateArg(FscWfQueryAuditListBusiReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getAuditFlag()) {
            return "\u67e5\u8be2\u7c7b\u578b[auditFlag]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getUserId()) {
            return "\u5f53\u524d\u7528\u6237[userId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

