/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscDealServiceFeeBillApplyService;
import com.tydic.pfscext.api.busi.bo.FscDealServiceFeeBillApplyReqBO;
import com.tydic.pfscext.api.busi.bo.FscDealServiceFeeBillApplyRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.deal.impl.AddBillApplyServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscDealServiceFeeBillApplyService.class)
public class FscDealServiceFeeBillApplyServiceImpl
implements FscDealServiceFeeBillApplyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscDealServiceFeeBillApplyServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapperl;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private AddBillApplyServiceImpl addBillApplyService;

    @Transactional(rollbackFor={Exception.class})
    public FscDealServiceFeeBillApplyRspBO makeServiceFeeBillApply(FscDealServiceFeeBillApplyReqBO fscDealServiceFeeBillApplyReqBO) {
        FscDealServiceFeeBillApplyRspBO rspBO = new FscDealServiceFeeBillApplyRspBO();
        ArrayList<SaleOrderInfo> saleOrderInfos = new ArrayList<SaleOrderInfo>();
        if (fscDealServiceFeeBillApplyReqBO == null) {
            throw new PfscExtBusinessException("0001", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fscDealServiceFeeBillApplyReqBO.getOrderaIds() != null) {
            List orderaIds = fscDealServiceFeeBillApplyReqBO.getOrderaIds();
            for (Object orderaId : orderaIds) {
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setOrderId((Long)orderaId);
                saleOrderInfos.add(saleOrderInfo);
            }
            List<SaleOrderInfo> payOrders = this.saleOrderInfoMapperl.getListOrderInfo(saleOrderInfos);
            for (SaleOrderInfo payOrder : payOrders) {
                if ("002".equals(payOrder.getOrderStatus())) {
                    throw new PfscExtBusinessException("D_SALE_ORDER_INFO_ORDER_STATUS", "\u8be5\u8ba2\u5355\u7684\u72b6\u6001\u5f02\u5e38");
                }
                PayOrderInfoPO infoPO = new PayOrderInfoPO();
                BeanUtils.copyProperties((Object)payOrder, (Object)infoPO);
                this.payOrderInfoMapper.insert(infoPO);
            }
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            if (fscDealServiceFeeBillApplyReqBO.getInvoiceInfo() != null) {
                BeanUtils.copyProperties((Object)fscDealServiceFeeBillApplyReqBO.getInvoiceInfo(), (Object)billApplyInfo);
            }
            if (fscDealServiceFeeBillApplyReqBO.getMailAddrInfo() != null) {
                BeanUtils.copyProperties((Object)fscDealServiceFeeBillApplyReqBO.getMailAddrInfo(), (Object)billApplyInfo);
            }
            String applyNo = this.addBillApplyService.getBillApplyNo();
            int result = this.billApplyInfoMapper.insert(billApplyInfo);
            if (result > 0) {
                rspBO.setApplyNo(applyNo);
                rspBO.setRespCode("0000");
            }
        } else {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u53c2\u6570\u4e3a\u7a7a\u5f02\u5e38");
        }
        return rspBO;
    }
}

