/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiAddMainAcctService;
import com.tydic.pfscext.api.busi.bo.BusiAddMainAcctReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddMainAcctRspBO;
import com.tydic.pfscext.dao.po.MainAcctInfo;
import com.tydic.pfscext.dao.po.SubAcctInfo;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.CompanyType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.SubAccountServiceType;
import com.tydic.pfscext.enums.SubAccountStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.ProjectInfoBO;
import com.tydic.pfscext.external.api.bo.UserDetailInfoBO;
import com.tydic.pfscext.service.atom.AccountAtomService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.MainAccountService;
import com.tydic.pfscext.service.atom.SubAccountService;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiAddMainAcctService.class)
public class BusiAddMainAcctServiceImpl
implements BusiAddMainAcctService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddMainAcctServiceImpl.class);
    private MainAccountService mainAccountService;
    private EnumsService enumsService;
    private SubAccountService subAcctService;
    private AccountAtomService accountAtomService;
    private UserInfoService userInfoService;

    @Autowired
    public BusiAddMainAcctServiceImpl(MainAccountService mainAccountService, EnumsService enumsService, SubAccountService subAcctService, AccountAtomService accountAtomService, UserInfoService userInfoService) {
        this.mainAccountService = mainAccountService;
        this.enumsService = enumsService;
        this.subAcctService = subAcctService;
        this.accountAtomService = accountAtomService;
        this.userInfoService = userInfoService;
    }

    public BusiAddMainAcctRspBO addMainAcct(BusiAddMainAcctReqBO reqBO) {
        UserDetailInfoBO userDetailInfoBO;
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null != (userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(reqBO.getUserId()))) {
            reqBO.setOrgId(userDetailInfoBO.getOrgId());
            reqBO.setCompanyId(userDetailInfoBO.getCompanyId());
        }
        if (null == reqBO.getSource() || !StringUtils.hasText((String)reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getMainAcctNo() || !StringUtils.hasText((String)reqBO.getMainAcctNo())) {
            throw new PfscExtBusinessException("0001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u4e3b\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getMainAcctNo().length() > 50) {
            throw new PfscExtBusinessException("0001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u4e3b\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750");
        }
        if (null == reqBO.getMainAcctName() || !StringUtils.hasText((String)reqBO.getMainAcctName())) {
            throw new PfscExtBusinessException("0001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u4e3b\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOpenBank() || !StringUtils.hasText((String)reqBO.getOpenBank())) {
            throw new PfscExtBusinessException("0001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u673a\u6784\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MainAcctInfo mainAcctInfo = new MainAcctInfo();
        mainAcctInfo.setSource(reqBO.getSource());
        mainAcctInfo.setOrgId(reqBO.getCompanyId());
        mainAcctInfo.setMainAcctNo(reqBO.getMainAcctNo());
        mainAcctInfo.setMainAcctName(reqBO.getMainAcctName());
        mainAcctInfo.setOpenBank(reqBO.getOpenBank());
        MainAcctInfo returnMainAcc = this.mainAccountService.addAccount(mainAcctInfo);
        Integer srvType = SubAccountServiceType.BANK_BUSINESS.getCode();
        Long projectId = reqBO.getPurchaserAccountUser();
        if (projectId == null) {
            List<ProjectInfoBO> projectInfoBOList = this.userInfoService.queryProjectInfoByUserId(reqBO.getUserId());
            if (!CollectionUtils.isEmpty(projectInfoBOList)) {
                projectId = projectInfoBOList.get(0).getAccountId();
            }
            if (projectId == null) {
                logger.error("\u4e13\u4e1a\u516c\u53f8\u5efa\u7acb\u8d44\u91d1\u8d26\u53f7\u5931\u8d25,\u65e0\u6548\u7684\u8d26\u5957ID=" + projectId);
                throw new PfscExtBusinessException("0001", "\u8bf7\u6c42\u4e2d\u672a\u53d1\u73b0\u6709\u6548\u7684\u8d26\u5957ID");
            }
        }
        Long acctOrgId = reqBO.getCompanyId();
        Integer companyType = CompanyType.OTHER.getCode();
        String mainAcctNo = reqBO.getMainAcctNo();
        BigDecimal overDraft = new BigDecimal("9999999999999");
        SubAcctInfo subAcct = new SubAcctInfo();
        subAcct.setLoginId(reqBO.getUserId());
        subAcct.setCreateOrgId(reqBO.getOrgId());
        subAcct.setMainAcctNo(mainAcctNo);
        subAcct.setOrgId(acctOrgId);
        String subAcctName = this.accountAtomService.obtainSubAccountName4Oper(mainAcctNo, srvType);
        subAcct.setSubAcctName(subAcctName);
        subAcct.setServiceType(srvType);
        subAcct.setProjectId(projectId);
        subAcct.setCompanyType(companyType);
        subAcct.setOverdraft(overDraft);
        subAcct.setStatus(SubAccountStatus.ACTIVED.getCode());
        subAcct = this.subAcctService.addSubAccount(subAcct);
        BusiAddMainAcctRspBO busiAddMainAcctRspBO = new BusiAddMainAcctRspBO();
        busiAddMainAcctRspBO.setCompanyId(returnMainAcc.getOrgId().longValue());
        busiAddMainAcctRspBO.setSource(returnMainAcc.getSource());
        busiAddMainAcctRspBO.setMainAcctName(returnMainAcc.getMainAcctName());
        busiAddMainAcctRspBO.setMainAcctNo(returnMainAcc.getMainAcctNo());
        busiAddMainAcctRspBO.setOpenBank(returnMainAcc.getOpenBank());
        busiAddMainAcctRspBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)returnMainAcc.getSource())));
        return busiAddMainAcctRspBO;
    }
}

