/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscBillNotificationConfirmService;
import com.tydic.pfscext.api.busi.bo.FscBillNotificationConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.FscBillNotificationConfirmRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillNotificationConfirmService.class)
public class FscBillNotificationConfirmServiceImpl
implements FscBillNotificationConfirmService {
    private static final Logger log = LoggerFactory.getLogger(FscBillNotificationConfirmServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public FscBillNotificationConfirmRspBO makeBillNoticeConfirm(FscBillNotificationConfirmReqBO reqBO) {
        this.checkParam(reqBO);
        FscBillNotificationConfirmRspBO rspBO = new FscBillNotificationConfirmRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setNotificationNo(reqBO.getNotificationNo());
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.UNCONFIRM.getCode());
        List<BillNotificationInfo> billNotificationInfoList = this.billNotificationInfoMapper.selectList(billNotificationInfo);
        if (CollectionUtils.isEmpty(billNotificationInfoList)) {
            rspBO.setRespCode("18001");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u901a\u77e5\u5355\u53f7\u4e3a[" + reqBO.getNotificationNo() + "]\u7684\u8bb0\u5f55");
            return rspBO;
        }
        if ("confirm".equals(reqBO.getOperType())) {
            BillNotificationInfo updateBillNotificationInfo = new BillNotificationInfo();
            updateBillNotificationInfo.setNotificationNo(reqBO.getNotificationNo());
            updateBillNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            if (reqBO.getInvoiceInfo() != null) {
                updateBillNotificationInfo.setAddr(reqBO.getInvoiceInfo().getAddress());
                updateBillNotificationInfo.setBankAccNo(reqBO.getInvoiceInfo().getAccount());
                updateBillNotificationInfo.setBankName(reqBO.getInvoiceInfo().getBank());
                updateBillNotificationInfo.setInvoceName(reqBO.getInvoiceInfo().getInvoiceTitle());
                updateBillNotificationInfo.setInvoceType(reqBO.getInvoiceInfo().getInvoiceType() == 0 ? InvoiceType.SPECIAL.getCode() : InvoiceType.NORMAL.getCode());
                updateBillNotificationInfo.setPhone(reqBO.getInvoiceInfo().getPhone());
                updateBillNotificationInfo.setTaxNo(reqBO.getInvoiceInfo().getTaxpayerId());
            }
            if (reqBO.getMailAddrInfo() != null) {
                updateBillNotificationInfo.setAddrDesc(reqBO.getMailAddrInfo().getAddrDesc());
                updateBillNotificationInfo.setProvince(reqBO.getMailAddrInfo().getProvince());
                updateBillNotificationInfo.setCity(reqBO.getMailAddrInfo().getCity());
                updateBillNotificationInfo.setCounty(reqBO.getMailAddrInfo().getCounty());
                updateBillNotificationInfo.setTown(reqBO.getMailAddrInfo().getTown());
                updateBillNotificationInfo.setProvId(reqBO.getMailAddrInfo().getProvId());
                updateBillNotificationInfo.setCityId(reqBO.getMailAddrInfo().getCityId());
                updateBillNotificationInfo.setCountyId(reqBO.getMailAddrInfo().getCountyId());
                updateBillNotificationInfo.setTownId(reqBO.getMailAddrInfo().getTownId());
                updateBillNotificationInfo.setCompany(reqBO.getMailAddrInfo().getCompany());
                updateBillNotificationInfo.setMobile(reqBO.getMailAddrInfo().getTel());
                updateBillNotificationInfo.setTel(reqBO.getMailAddrInfo().getSpecialPlane());
                updateBillNotificationInfo.setName(reqBO.getMailAddrInfo().getName());
                updateBillNotificationInfo.setPostCode(reqBO.getMailAddrInfo().getPostCode());
            }
            try {
                int update = this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateBillNotificationInfo);
                if (update < 1) {
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f\u5f02\u5e38");
                }
            }
            catch (Exception e) {
                log.error("\u901a\u77e5\u5355\u786e\u8ba4/\u53d6\u6d88\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f\u5f02\u5e38");
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u786e\u8ba4\u6210\u529f");
        } else if ("cancel".equals(reqBO.getOperType())) {
            int deleteNum = this.billNotificationInfoMapper.deleteByPrimaryKey(reqBO.getNotificationNo());
            if (deleteNum < 1) {
                throw new PfscExtBusinessException("18000", "\u5220\u9664\u901a\u77e5\u5355\u4fe1\u606f\u5f02\u5e38");
            }
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(reqBO.getNotificationNo());
            if (CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
                throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u5f00\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f");
            }
            for (PayPurchaseOrderInfo purchaseOrderInfo : payPurchaseOrderInfoList) {
                PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
                payOrderInfo.setOrderId((long)purchaseOrderInfo.getOrderId());
                payOrderInfo.setInspectionId((long)purchaseOrderInfo.getInspectionId());
                int update = this.payPurchaseOrderInfoMapper.updateByReset(payOrderInfo);
                if (update < 1) {
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
                }
                PayItemInfo item = new PayItemInfo();
                item.setOrderId((long)purchaseOrderInfo.getOrderId());
                item.setInspectionId((long)purchaseOrderInfo.getInspectionId());
                int update1 = this.payItemInfoMapper.updateByReset(item);
                if (update1 >= 1) continue;
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u53d6\u6d88\u6210\u529f");
        }
        return rspBO;
    }

    private void checkParam(FscBillNotificationConfirmReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getNotificationNo())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

