/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.order.extend.ability.saleorder.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.order.extend.ability.saleorder.UocExtOrderDetailsQueryAbilityService;
import com.tydic.order.extend.bo.saleorder.PebExtMainOrderDetailQueryReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtMainOrderDetailQueryRspBO;
import com.tydic.order.extend.bo.saleorder.UocExtOrderDetailsQueryReqBO;
import com.tydic.order.extend.bo.saleorder.UocExtOrderDetailsQueryRspBO;
import com.tydic.pfscext.api.busi.SynchronizationOrderDateBusiService;
import com.tydic.pfscext.api.busi.bo.SynchronizationOrderDateRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.external.api.BusiK3Service;
import com.tydic.pfscext.external.api.bo.PurPayableDetailInfoBO;
import com.tydic.pfscext.external.api.bo.PurPaybillInfoBO;
import com.tydic.pfscext.external.api.bo.QryPurPayableDetailReqBO;
import com.tydic.pfscext.external.api.bo.QryPurPayableDetailRspBO;
import com.tydic.pfscext.external.api.bo.QryTSyncPaybillReqBO;
import com.tydic.pfscext.external.api.bo.QryTSyncPaybillRspBO;
import com.tydic.pfscext.external.api.bo.UpPayableDetailReqBO;
import com.tydic.pfscext.external.api.bo.UpPaybillInfoReqBO;
import com.tydic.uac.exception.BusinessException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=SynchronizationOrderDateBusiService.class)
public class SynchronizationOrderDateBusiServiceImpl
implements SynchronizationOrderDateBusiService {
    private static final Logger log = LoggerFactory.getLogger(SynchronizationOrderDateBusiServiceImpl.class);
    @Autowired
    private BusiK3Service busiK3Service;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_DEV")
    private UocExtOrderDetailsQueryAbilityService uocExtOrderDetailsQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_DEV")
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;

    public SynchronizationOrderDateRspBO sync() {
        SynchronizationOrderDateRspBO rspBO = new SynchronizationOrderDateRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u4fdd\u5b58\u8ba2\u5355\u6570\u636e\u6210\u529f");
        String fflag = "00";
        QryPurPayableDetailReqBO qryPurPayableDetailReqBO = new QryPurPayableDetailReqBO();
        QryTSyncPaybillReqBO qryTSyncPaybillReqBO = new QryTSyncPaybillReqBO();
        qryPurPayableDetailReqBO.setFflag(fflag);
        qryTSyncPaybillReqBO.setFflag(fflag);
        try {
            QryTSyncPaybillRspBO tSyncPaybillData = this.busiK3Service.getTSyncPaybillData(qryTSyncPaybillReqBO);
            if (tSyncPaybillData.getRespCode().equals("8888")) {
                rspBO.setCode(tSyncPaybillData.getRespCode());
                rspBO.setMessage(tSyncPaybillData.getRespDesc());
                return rspBO;
            }
            QryPurPayableDetailRspBO purPayableDetailData = this.busiK3Service.getPurPayableDetailData(qryPurPayableDetailReqBO);
            if (purPayableDetailData.getRespCode().equals("8888")) {
                rspBO.setCode(tSyncPaybillData.getRespCode());
                rspBO.setMessage(tSyncPaybillData.getRespDesc());
                return rspBO;
            }
            if (tSyncPaybillData.getPurPaybillInfoBOList().isEmpty()) {
                log.info("\u672c\u6b21\u8c03\u7528\u672a\u83b7\u53d6\u5230\u6709\u6548\u6570\u636e");
                return rspBO;
            }
            List<PurPaybillInfoBO> purPaybillInfoBOList = this.editQryTSyncPaybillRspBO(tSyncPaybillData);
            List<PurPayableDetailInfoBO> purPayableDetailInfoBOList = this.editPurPayableDetailData(purPayableDetailData);
            this.addAppleDetail(tSyncPaybillData, purPayableDetailData);
            UpPaybillInfoReqBO upPaybillInfoReqBO = new UpPaybillInfoReqBO();
            upPaybillInfoReqBO.setFflag("00");
            upPaybillInfoReqBO.setPurPaybillInfoBOList(purPaybillInfoBOList);
            this.busiK3Service.updatePaybillReadStatus(upPaybillInfoReqBO);
            UpPayableDetailReqBO upPayableDetailReqBO = new UpPayableDetailReqBO();
            upPayableDetailReqBO.setFflag("00");
            upPayableDetailReqBO.setPurPayableDetailInfoBOList(purPayableDetailInfoBOList);
            this.busiK3Service.updatePayableDetailReadStatus(upPayableDetailReqBO);
        }
        catch (BusinessException e) {
            rspBO.setCode(e.getMsgCode());
            rspBO.setMessage(e.getMessage());
            return rspBO;
        }
        return rspBO;
    }

    private void addAppleDetail(QryTSyncPaybillRspBO tSyncPaybillData, QryPurPayableDetailRspBO purPayableDetailData) {
        for (PurPaybillInfoBO purPaybillInfoBO : tSyncPaybillData.getPurPaybillInfoBOList()) {
            for (PurPayableDetailInfoBO purPayableDetailInfoBO : purPayableDetailData.getPurPayableDetailInfoBOList()) {
                if (!purPaybillInfoBO.getOrderNo().equals(purPayableDetailInfoBO.getOrderNo())) continue;
                ApplyDetail applyDetail = new ApplyDetail();
                applyDetail.setPayableNo(purPayableDetailInfoBO.getPayableNo());
                applyDetail.setSupplierId(Long.valueOf(purPaybillInfoBO.getOperatorId()));
                applyDetail.setStatus(purPayableDetailInfoBO.getPayType());
                applyDetail.setAmt(purPayableDetailInfoBO.getPayableAmt());
                int insert = this.applyDetailMapper.insert(applyDetail);
                if (insert >= 0) continue;
                throw new BusinessException("8888", "\u6dfb\u52a0\u4e2d\u95f4\u8868\u6570\u636e\u5f02\u5e38");
            }
        }
    }

    private List<PurPayableDetailInfoBO> editPurPayableDetailData(QryPurPayableDetailRspBO purPayableDetailData) {
        PayableDetailPO payableDetail = new PayableDetailPO();
        List purPayableDetailInfoBOList = purPayableDetailData.getPurPayableDetailInfoBOList();
        ArrayList<PurPayableDetailInfoBO> payableDetailInfoBOList = new ArrayList<PurPayableDetailInfoBO>();
        for (PurPayableDetailInfoBO infoBO : purPayableDetailInfoBOList) {
            PurPayableDetailInfoBO purPayableDetailInfoBO = new PurPayableDetailInfoBO();
            payableDetail.setPurchaseOrderCode(infoBO.getPurchaseOrderCode());
            payableDetail.setOrderId((long)infoBO.getOrderId());
            payableDetail.setPayableNo(infoBO.getPayableNo());
            payableDetail.setPayableAmt(infoBO.getPayableAmt());
            UocExtOrderDetailsQueryReqBO reqBO = new UocExtOrderDetailsQueryReqBO();
            reqBO.setSaleVoucherNo(infoBO.getOrderNo());
            UocExtOrderDetailsQueryRspBO rspBO = this.uocExtOrderDetailsQueryAbilityService.orderDetailsQuery(reqBO);
            PebExtMainOrderDetailQueryReqBO queryReqBO = new PebExtMainOrderDetailQueryReqBO();
            queryReqBO.setOrderId(rspBO.getOrdSaleRspBO().getOrderId());
            queryReqBO.setSaleVoucherId(rspBO.getOrdSaleRspBO().getSaleVoucherId());
            PebExtMainOrderDetailQueryRspBO queryRspBO = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(queryReqBO);
            Integer payableType = Integer.valueOf(queryRspBO.getOrderRspBO().getPayMod());
            if (2 == payableType) {
                Calendar instance = Calendar.getInstance();
                Date date = null;
                try {
                    date = new SimpleDateFormat("yyyy-MM-dd").parse(infoBO.getPaidDate());
                }
                catch (ParseException e) {
                    throw new BusinessException("8888", e.getMessage());
                }
                instance.setTime(date);
                String paymentDays = rspBO.getOrdSaleRspBO().getPaymentDays();
                instance.add(5, Integer.parseInt(paymentDays));
                payableDetail.setPaidDate(instance.getTime());
            }
            payableDetail.setRecOrgId(Long.valueOf(queryRspBO.getOrdStakeholderRspBO().getSupNo()));
            payableDetail.setPayOrgId(Long.valueOf(queryRspBO.getOrdStakeholderRspBO().getPurNo()));
            payableDetail.setSupplierId(Long.valueOf(infoBO.getOperatorId()));
            payableDetail.setPurchaseNo(Long.valueOf(queryRspBO.getOrdStakeholderRspBO().getPurNo()));
            payableDetail.setPurchaseName(queryRspBO.getOrdStakeholderRspBO().getPurName());
            payableDetail.setOverdueDays(0);
            payableDetail.setApproveStatus(0);
            payableDetail.setEffectiveStatus(1);
            payableDetail.setPayType(PayablePayType.PAY.getCode());
            payableDetail.setPayableStatus(PayableStatus.PAYINGS.getCode());
            int insert = this.payableDetailMapper.insert(payableDetail);
            if (insert < 0) {
                throw new BusinessException("8888", "\u6dfb\u52a0\u5e94\u4ed8\u5355\u6570\u636e\u5931\u8d25");
            }
            purPayableDetailInfoBO.setOrderNo(infoBO.getOrderNo());
            purPayableDetailInfoBO.setOrderId(infoBO.getOrderId());
            purPayableDetailInfoBO.setPlaAgreementCode(infoBO.getPlaAgreementCode());
            purPayableDetailInfoBO.setPayableNo(infoBO.getPayableNo());
            purPayableDetailInfoBO.setOutPayOrderNo(infoBO.getOutPayOrderNo());
            purPayableDetailInfoBO.setPurchaseOrderCode(infoBO.getPurchaseOrderCode());
            purPayableDetailInfoBO.setInvoiceNo(infoBO.getInvoiceNo());
            payableDetailInfoBOList.add(purPayableDetailInfoBO);
        }
        return payableDetailInfoBOList;
    }

    private List<PurPaybillInfoBO> editQryTSyncPaybillRspBO(QryTSyncPaybillRspBO tSyncPaybillData) {
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        List infoBOList = tSyncPaybillData.getPurPaybillInfoBOList();
        ArrayList<PurPaybillInfoBO> purPaybillInfoBOList = new ArrayList<PurPaybillInfoBO>();
        for (PurPaybillInfoBO infoBO : infoBOList) {
            PurPaybillInfoBO purPaybillInfoBO = new PurPaybillInfoBO();
            applyPayInfoPO.setPayableAtm(infoBO.getPayableAmt());
            applyPayInfoPO.setPayAmt(infoBO.getPayableAmt());
            applyPayInfoPO.setPayno(infoBO.getPayNo());
            applyPayInfoPO.setSupplierId(Long.valueOf(infoBO.getOperatorId()));
            applyPayInfoPO.setApplyDate(new Date());
            applyPayInfoPO.setPayStatus(ApplyPayStatus.PENDING_PAYMENT.getCode());
            applyPayInfoPO.setSource("1");
            int insert = this.applyPayInfoMapper.insert(applyPayInfoPO);
            if (insert < 0) {
                throw new BusinessException("8888", "\u6dfb\u52a0\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e\u5931\u8d25");
            }
            purPaybillInfoBO.setOrderNo(infoBO.getOrderNo());
            purPaybillInfoBO.setOrderId(infoBO.getOrderId());
            purPaybillInfoBO.setContactNo(infoBO.getContactNo());
            purPaybillInfoBO.setPayNo(infoBO.getPayNo());
            purPaybillInfoBO.setOutPayOrderNo(infoBO.getOutPayOrderNo());
            purPaybillInfoBO.setPurchaseOrderCode(infoBO.getPurchaseOrderCode());
            purPaybillInfoBOList.add(purPaybillInfoBO);
        }
        return purPaybillInfoBOList;
    }
}

