/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.deal.AdjustClosingServiceFeeService;
import com.tydic.pfscext.api.deal.bo.PayOrderInfoDetailReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=AdjustClosingServiceFeeService.class)
public class AdjustClosingServiceFeeServiceImpl
implements AdjustClosingServiceFeeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdjustClosingServiceFeeServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    public PfscExtRspBaseBO adjustClosingService(PayOrderInfoDetailReqBO payOrderInfoDetailReqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5165\u53c2\uff1a" + payOrderInfoDetailReqBO);
        }
        if (payOrderInfoDetailReqBO.getPayOrderIds() == null || payOrderInfoDetailReqBO.getPayOrderIds().size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            if (payOrderInfoDetailReqBO.getPayOrderIds().size() > 0) {
                PayOrderInfoPO payOrderInfoPO = new PayOrderInfoPO();
                BeanUtils.copyProperties((Object)payOrderInfoDetailReqBO, (Object)payOrderInfoPO);
                if ("1".equals(payOrderInfoDetailReqBO.getPayOrderStatus())) {
                    payOrderInfoPO.setDeductionUserId(payOrderInfoDetailReqBO.getUserId());
                    payOrderInfoPO.setDeductionUserName(payOrderInfoDetailReqBO.getUsername());
                    payOrderInfoPO.setDeductionTime(new Date());
                }
                if ("2".equals(payOrderInfoDetailReqBO.getPayOrderStatus())) {
                    payOrderInfoPO.setConfirmUserId(payOrderInfoDetailReqBO.getUserId());
                    payOrderInfoPO.setConfirmUserName(payOrderInfoDetailReqBO.getUsername());
                    payOrderInfoPO.setConfirmTime(new Date());
                }
                this.payOrderInfoMapper.updateBatchInfo(payOrderInfoDetailReqBO.getPayOrderIds(), payOrderInfoPO);
                pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
                pfscExtRspBaseBO.setRespCode("0000");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u6574\u670d\u52a1\u8d39\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u8c03\u6574\u670d\u52a1\u8d39\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }

    public PfscExtRspBaseBO updatePayOrderStatus(PayOrderInfoDetailReqBO payOrderInfoDetailReqBO) {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, -3);
            Date orderTime = c.getTime();
            PayOrderInfoPO payOrderInfo = new PayOrderInfoPO();
            payOrderInfo.setPayOrderStatus("0");
            payOrderInfo.setCreateTime(orderTime);
            List<Long> list = this.payOrderInfoMapper.selectByDate(payOrderInfo);
            if (list.size() > 0) {
                PayOrderInfoPO payOrderInfoPO = new PayOrderInfoPO();
                payOrderInfoPO.setDeductionTime(new Date());
                payOrderInfoPO.setDeductionUserName("\u7cfb\u7edf\u9ed8\u8ba4");
                this.payOrderInfoMapper.updatePayOrderStatus(list, payOrderInfoPO);
                pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
                pfscExtRspBaseBO.setRespCode("0000");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d8\u66f4\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u72b6\u6001\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }
}

