/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.deal.QueryPayInvoiceDetailService;
import com.tydic.pfscext.api.deal.bo.PayInvoiceDetailBO;
import com.tydic.pfscext.api.deal.bo.PayInvoiceInfoBO;
import com.tydic.pfscext.api.deal.bo.PayItemInfoBO;
import com.tydic.pfscext.api.deal.bo.QueryPayInvoiceDetailReqBO;
import com.tydic.pfscext.api.deal.bo.QueryPayInvoiceDetailRspBO;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryPayInvoiceDetailService.class)
public class QueryPayInvoiceDetailServiceImpl
implements QueryPayInvoiceDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayInvoiceDetailService.class);
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;

    public QueryPayInvoiceDetailRspBO selectBySomeConditions(QueryPayInvoiceDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayItemInfoBO payItemInfo = reqBO.getPayItemInfo();
        PayInvoiceDetailBO payInvoiceDetailBO = new PayInvoiceDetailBO();
        PayInvoiceDetail payDetailsInfo = this.payInvoiceDetailMapper.selectBySomeConditions(payItemInfo.getItemNo(), payItemInfo.getInspectionId(), payItemInfo.getInvoiceNoSet());
        BeanUtils.copyProperties((Object)payDetailsInfo, (Object)payInvoiceDetailBO);
        QueryPayInvoiceDetailRspBO rspBO = new QueryPayInvoiceDetailRspBO();
        rspBO.setPayInvoiceDetailBO(payInvoiceDetailBO);
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public QueryPayInvoiceDetailRspBO deleteByInvoiceNo(QueryPayInvoiceDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayInvoiceInfoBO iv = reqBO.getPayInvoiceInfoBO();
        try {
            int n = this.payInvoiceDetailMapper.deleteByInvoiceNo(iv.getInvoiceCode(), iv.getInvoiceNo(), iv.getInvoiceDate());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5220\u9664\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a{}", (Object)LocalDateTime.now());
            throw new PfscExtBusinessException("0001", "\u5220\u9664\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        QueryPayInvoiceDetailRspBO rspBO = new QueryPayInvoiceDetailRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public QueryPayInvoiceDetailRspBO insertByBatch(QueryPayInvoiceDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List newIvDetails = reqBO.getNewIvDetails();
        ArrayList<PayInvoiceDetail> list = new ArrayList<PayInvoiceDetail>();
        if (null != newIvDetails && newIvDetails.size() > 0) {
            for (PayInvoiceDetailBO bo : newIvDetails) {
                PayInvoiceDetail detail = new PayInvoiceDetail();
                BeanUtils.copyProperties((Object)bo, (Object)detail);
                list.add(detail);
            }
        }
        try {
            this.payInvoiceDetailMapper.insertByBatch(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6279\u91cf\u63d2\u5165\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a{}", (Object)LocalDateTime.now());
            throw new PfscExtBusinessException("0001", "\u6279\u91cf\u63d2\u5165\u53d1\u7968\u660e\u7ec6\u5931\u8d25");
        }
        QueryPayInvoiceDetailRspBO rspBO = new QueryPayInvoiceDetailRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

