/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.BusiAddPayConfigService;
import com.tydic.pfscext.api.busi.bo.AddPayConfigFscReqBo;
import com.tydic.pfscext.api.busi.bo.AddPayConfigFscRspBo;
import com.tydic.pfscext.dao.PayConfigMapper;
import com.tydic.pfscext.dao.po.PayConfig;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiAddPayConfigService.class)
public class BusiAddPayConfigServiceImpl
implements BusiAddPayConfigService {
    private static final Logger log = LoggerFactory.getLogger(BusiAddPayConfigServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiAddPayConfigServiceImpl.class);
    @Autowired
    private PayConfigMapper payConfigMapper;

    public AddPayConfigFscRspBo addPayConfig(AddPayConfigFscReqBo addPayConfigFscReqBo) {
        AddPayConfigFscRspBo addPayConfigFscRspBo = new AddPayConfigFscRspBo();
        log.error("\u65b0\u589e\u652f\u4ed8\u7684\u5165\u53c2\u662f" + addPayConfigFscReqBo.toString());
        String validateArgsResult = this.validateArgs(addPayConfigFscReqBo);
        if (!StringUtils.isEmpty((Object)validateArgsResult)) {
            throw new PfscExtBusinessException("18000", validateArgsResult);
        }
        try {
            Long payConfigId = Sequence.getInstance().nextId();
            List dayTypes = addPayConfigFscReqBo.getDayTypes();
            PayConfig payConfig = new PayConfig();
            BeanUtils.copyProperties((Object)addPayConfigFscReqBo, (Object)payConfig);
            if (dayTypes != null) {
                payConfig.setDayTypes(dayTypes.toString());
            }
            payConfig.setPayConfigId(payConfigId);
            payConfig.setCreateUserId(addPayConfigFscReqBo.getUserId());
            payConfig.setCreateUserName(addPayConfigFscReqBo.getUsername());
            payConfig.setCreateTime(new Date());
            String replace = addPayConfigFscReqBo.getOverdueRate().replace("%", "");
            BigDecimal bigDecimal = new BigDecimal(replace);
            payConfig.setOverdueRate(bigDecimal);
            payConfig.setIsDelete(0);
            payConfig.setSupplierId(addPayConfigFscReqBo.getSupId());
            this.payConfigMapper.insertSelective(payConfig);
            addPayConfigFscRspBo.setPayConfigId(payConfigId);
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u914d\u7f6e\u65b0\u589e\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        return addPayConfigFscRspBo;
    }

    private String validateArgs(AddPayConfigFscReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2'reqBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExceptName())) {
            return "\u5165\u53c2'reqBo'\u4e2d\u5c5e\u6027'exceptName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayTypes())) {
            return "\u5165\u53c2'reqBo'\u4e2d\u5c5e\u6027'payTypes'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayChannels())) {
            return "\u5165\u53c2'reqBo'\u4e2d\u5c5e\u6027'payChannels'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

