/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.BusiBalanceSubmitService;
import com.tydic.pfscext.api.busi.FscPayableOrderCreateService;
import com.tydic.pfscext.api.busi.bo.BalanceSubmitReqBo;
import com.tydic.pfscext.api.busi.bo.BalanceSubmitRspBo;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderCreateReqBO;
import com.tydic.pfscext.dao.BalanceChngLogMapper;
import com.tydic.pfscext.dao.BalanceMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.Balance;
import com.tydic.pfscext.dao.po.BalanceChngLog;
import com.tydic.pfscext.dao.po.BalanceChngLogPo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ItemType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiBalanceSubmitService.class)
public class BusiBalanceSubmitServiceImpl
implements BusiBalanceSubmitService {
    private static final Logger logger = LoggerFactory.getLogger(BusiBalanceSubmitServiceImpl.class);
    @Autowired
    private BalanceMapper balanceMapper;
    @Autowired
    private FscPayableOrderCreateService fscPayableOrderCreateService;
    @Autowired
    private BalanceChngLogMapper balanceChngLogMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    public BalanceSubmitRspBo balanceSubmit(BalanceSubmitReqBo reqBo) {
        if (ItemType.DEPOSIT.getCode().equals(reqBo.getItemType())) {
            Balance balance = new Balance();
            balance.setObjId(reqBo.getSupId());
            balance.setObjType("00");
            Balance balance1 = this.balanceMapper.selectByBalance(balance);
            BigDecimal balances = BigDecimal.ZERO;
            balances = balance1.getBalance().add(reqBo.getItemAmt());
            BigDecimal twoHundredThousand = new BigDecimal("200000");
            if (balances.compareTo(twoHundredThousand) == 1) {
                throw new PfscExtBusinessException("18001", "\u4fdd\u8bc1\u91d1\u603b\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u4e8c\u5341\u4e07\u5143\uff0c\u8bf7\u786e\u8ba4\u7533\u8bf7\u7f34\u7eb3\u91d1\u989d");
            }
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableType(14);
            payableDetailPO.setPayOrgId(reqBo.getSupId());
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getList(payableDetailPO);
            BigDecimal allBalance = balance1.getBalance();
            for (PayableDetailPO payableDetailPO1 : payableDetailPOS) {
                allBalance = allBalance.add(payableDetailPO1.getPayableAmt());
            }
            if (allBalance.compareTo(twoHundredThousand) == 1) {
                throw new PfscExtBusinessException("18001", "\u5c1a\u6709\u672a\u4ed8\u6b3e\u5b8c\u6210\u7684\u7f34\u7eb3\u4fdd\u8bc1\u91d1\uff0c\u4e14\u603b\u989d\u5927\u4e8e\u4e8c\u5341\u4e07");
            }
            FscPayableOrderCreateReqBO fscPayableOrderCreateReqBO = new FscPayableOrderCreateReqBO();
            fscPayableOrderCreateReqBO.setSupplierId(reqBo.getSupId());
            fscPayableOrderCreateReqBO.setRecOrgId(reqBo.getSupId());
            fscPayableOrderCreateReqBO.setPayableAmt(reqBo.getItemAmt());
            fscPayableOrderCreateReqBO.setPayableType("14");
            this.fscPayableOrderCreateService.createPayableOrder(fscPayableOrderCreateReqBO);
        } else if (ItemType.REFUND_OF_DEPOSIT.getCode().equals(reqBo.getItemType())) {
            FscPayableOrderCreateReqBO fscPayableOrderCreateReqBO = new FscPayableOrderCreateReqBO();
            fscPayableOrderCreateReqBO.setSupplierId(reqBo.getSupId());
            fscPayableOrderCreateReqBO.setRecOrgId(reqBo.getSupId());
            fscPayableOrderCreateReqBO.setPayableAmt(reqBo.getItemAmt());
            fscPayableOrderCreateReqBO.setBondAmt(reqBo.getCurrentBalance());
            fscPayableOrderCreateReqBO.setPayableType("24");
            this.fscPayableOrderCreateService.createPayableOrder(fscPayableOrderCreateReqBO);
        } else if (ItemType.PROJECT_QUOTA_OCCUPATION.getCode().equals(reqBo.getItemType())) {
            BalanceChngLog balanceChngLog = new BalanceChngLog();
            BeanUtils.copyProperties((Object)reqBo, (Object)balanceChngLog);
            Long payId = reqBo.getPayId();
            Balance balance = new Balance();
            balance.setObjId(payId);
            Balance balance1 = this.balanceMapper.selectByBalance(balance);
            if (null == balance1) {
                throw new PfscExtBusinessException("18001", "\u5f53\u524d\u7528\u6237\u4fdd\u8bc1\u91d1\u6c60\u4e0d\u5b58\u5728");
            }
            BigDecimal afterBalance = BigDecimal.ZERO;
            BigDecimal balance2 = balance1.getBalance();
            if (balance2.compareTo(reqBo.getItemAmt()) == 1) {
                afterBalance = balance2.subtract(reqBo.getItemAmt());
                balance1.setBalance(afterBalance);
                balance1.setLockBalance(reqBo.getItemAmt());
                int i = this.balanceMapper.updateByPrimaryKeySelective(balance1);
                if (i != 1) {
                    throw new PfscExtBusinessException("18001", "\u5bfb\u6e90\u9879\u76ee\u51bb\u7ed3\u8d44\u91d1\u5931\u8d25");
                }
            } else {
                throw new PfscExtBusinessException("18001", "\u6263\u9664\u5bfb\u6e90\u9879\u76ee\u8d44\u91d1\u4e0d\u8db3");
            }
            balanceChngLog.setChngType("2");
            balanceChngLog.setCreateTime(new Date());
            balanceChngLog.setLogId(Sequence.getInstance().nextId());
            balanceChngLog.setCreatorId(reqBo.getCompanyId());
            this.balanceChngLogMapper.insert(balanceChngLog);
        } else {
            throw new PfscExtBusinessException("18001", "\u9879\u76ee\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        BalanceSubmitRspBo balanceSubmitRspBo = new BalanceSubmitRspBo();
        return balanceSubmitRspBo;
    }

    private void initParam(BalanceSubmitReqBo reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7f34\u7eb3\u4fdd\u8bc1\u91d1\u63d0\u4ea4\u5165\u53c2\uff1a" + reqBo.toString());
        }
        if (ItemType.DEPOSIT.getCode().equals(reqBo.getItemType()) && reqBo.getSupId() == null) {
            throw new PfscExtBusinessException("18001", "\u975e\u4f9b\u5e94\u5546\u4e0d\u80fd\u5145\u503c");
        }
        if (ItemType.REFUND_OF_DEPOSIT.getCode().equals(reqBo.getItemType())) {
            BalanceChngLogPo balanceChngLogPo = new BalanceChngLogPo();
            balanceChngLogPo.setSupId(reqBo.getSupId());
            balanceChngLogPo.setItemType("06");
            balanceChngLogPo.setProjectFlag("2");
            List<BalanceChngLog> listByTerms = this.balanceMapper.getListByTerms(balanceChngLogPo);
            if (listByTerms != null) {
                throw new PfscExtBusinessException("18001", "\u60a8\u6709\u5c65\u7ea6\u4e2d\u7684\u5408\u540c\u6216\u8ba2\u5355\uff0c\u8bf7\u5c65\u7ea6\u5b8c\u6210\u540e\u7533\u8bf7\u9000\u8fd8\u4fdd\u8bc1\u91d1\uff01");
            }
        }
    }
}

