/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.FscBillApplyListService;
import com.tydic.pfscext.api.busi.bo.FscBillApplyBO;
import com.tydic.pfscext.api.busi.bo.FscBillApplyListReqBO;
import com.tydic.pfscext.api.busi.bo.FscBillApplyListRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.vo.FscBillApplyListVo;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillApplyListService.class)
public class FscBillApplyListServiceImpl
implements FscBillApplyListService {
    private static final Logger log = LoggerFactory.getLogger(FscBillApplyListServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(FscBillApplyListServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public FscBillApplyListRspBO qryList(FscBillApplyListReqBO reqBO) {
        FscBillApplyListRspBO rspPage = new FscBillApplyListRspBO();
        if (log.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5165\u53c2\uff1a" + reqBO);
        }
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        if ("0".equals(reqBO.getIsProfessionalOrgExt()) || "2".equals(reqBO.getIsProfessionalOrgExt())) {
            List<FscBillApplyListVo> list = this.billApplyInfoMapper.getBillApplyInfoList(reqBO, (Page<Map<String, Object>>)page);
            if (CollectionUtils.isEmpty(list)) {
                rspPage.setRespCode("8888");
                rspPage.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rspPage;
            }
            ArrayList<FscBillApplyBO> list1 = new ArrayList<FscBillApplyBO>();
            for (FscBillApplyListVo fscBillApplyListVo : list) {
                FscBillApplyBO fscBillApplyBO = new FscBillApplyBO();
                BeanUtils.copyProperties((Object)fscBillApplyListVo, (Object)fscBillApplyBO);
                String codeDescr = InvoiceType.getInstance(fscBillApplyListVo.getInvoiceType()).getDescr();
                fscBillApplyBO.setInvoiceTypeStr(codeDescr);
                Long supplierNo = fscBillApplyListVo.getSupplierNo();
                String supplierName = this.organizationInfoService.querySupplierName(supplierNo);
                fscBillApplyBO.setSupplierName(supplierName);
                Long operUnitNo = fscBillApplyListVo.getOperUnitNo();
                String operUnitName = this.organizationInfoService.queryOrgName(operUnitNo);
                fscBillApplyBO.setOperUnitName(operUnitName);
                list1.add(fscBillApplyBO);
            }
            rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
            rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPage.setRows(list1);
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u6210\u529f");
            return rspPage;
        }
        throw new PfscExtBusinessException("0001", "\u975e\u8fd0\u8425\u5546\u3001\u4f9b\u8d27\u65b9");
    }
}

