/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscBillApplySignDetailQryService;
import com.tydic.pfscext.api.busi.bo.FscBillApplySignDetailQryReqBO;
import com.tydic.pfscext.api.busi.bo.FscBillApplySignDetailQryRspBO;
import com.tydic.pfscext.api.busi.bo.FscInvoiceCheckBO;
import com.tydic.pfscext.api.busi.bo.FscInvoiceCheckDetailBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.enums.PayFeeType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillApplySignDetailQryService.class)
public class FscBillApplySignDetailQryServiceImpl
implements FscBillApplySignDetailQryService {
    private static final Logger logger = LoggerFactory.getLogger(FscBillApplySignDetailQryServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    private FscBillApplySignDetailQryRspBO rspBO = new FscBillApplySignDetailQryRspBO();

    public FscBillApplySignDetailQryRspBO qryInvoiceSignDetail(FscBillApplySignDetailQryReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u7b7e\u6536\u6838\u5bf9\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getApplyNo() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u3010\u5f00\u7968\u7533\u8bf7\u5355\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getApplyNo());
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByApplyNoAndStatus(reqBO.getApplyNo());
        if (saleInvoiceInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        this.compare(billApplyInfo, saleInvoiceInfo);
        if (this.rspBO.getNameBO().getInvoiceCheckResult().equals("\u65e0\u6cd5\u5339\u914d") || this.rspBO.getTaxNoBO().getInvoiceCheckResult().equals("\u65e0\u6cd5\u5339\u914d") || this.rspBO.getInvoiceAmt().getInvoiceCheckResult().equals("\u65e0\u6cd5\u5339\u914d")) {
            this.rspBO.setCheckResult(Boolean.valueOf(false));
        } else {
            this.rspBO.setCheckResult(Boolean.valueOf(true));
        }
        List<FscInvoiceCheckDetailBO> billApplyInVoiceInfo = this.billApplyInfoMapper.getBillApplyInVoiceInfo(reqBO.getApplyNo());
        String payFeeType = billApplyInVoiceInfo.get(0).getPayFeeType();
        billApplyInVoiceInfo.get(0).setPayFeeTypeStr(PayFeeType.getInstance(payFeeType).getDescr());
        if (this.rspBO.getCheckResult().booleanValue()) {
            billApplyInVoiceInfo.get(0).setDetailCheckResultStr("\u5339\u914d");
        } else {
            billApplyInVoiceInfo.get(0).setDetailCheckResultStr("\u4e0d\u5339\u914d");
        }
        this.rspBO.setCheckList(billApplyInVoiceInfo);
        this.rspBO.setRespCode("0000");
        this.rspBO.setRespDesc("\u6210\u529f");
        return this.rspBO;
    }

    private void compare(BillApplyInfo billApplyInfo, SaleInvoiceInfo saleInvoiceInfo) {
        FscInvoiceCheckBO nameBo = new FscInvoiceCheckBO();
        nameBo.setApplyValue(billApplyInfo.getInvoceName());
        nameBo.setInvoiceValue("");
        nameBo.setItemName("\u540d\u79f0");
        if ("".equals(billApplyInfo.getInvoceName())) {
            nameBo.setInvoiceCheckResult("\u6838\u5bf9\u4e00\u81f4");
        } else {
            nameBo.setInvoiceCheckResult("\u65e0\u6cd5\u5339\u914d");
        }
        this.rspBO.setNameBO(nameBo);
        FscInvoiceCheckBO taxNoBO = new FscInvoiceCheckBO();
        taxNoBO.setItemName("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        taxNoBO.setApplyValue(billApplyInfo.getTaxNo());
        taxNoBO.setInvoiceValue(saleInvoiceInfo.getTaxNo());
        if (billApplyInfo.getTaxNo().equals(saleInvoiceInfo.getTaxNo())) {
            taxNoBO.setInvoiceCheckResult("\u6838\u5bf9\u4e00\u81f4");
        } else {
            taxNoBO.setInvoiceCheckResult("\u65e0\u6cd5\u5339\u914d");
        }
        this.rspBO.setTaxNoBO(taxNoBO);
        FscInvoiceCheckBO invoiceAmt = new FscInvoiceCheckBO();
        invoiceAmt.setItemName("\u53d1\u7968\u91d1\u989d");
        invoiceAmt.setApplyValue(billApplyInfo.getAmt() + "");
        invoiceAmt.setInvoiceValue(saleInvoiceInfo.getAmt() + "");
        if (billApplyInfo.getAmt().equals(saleInvoiceInfo.getAmt())) {
            invoiceAmt.setInvoiceCheckResult("\u6838\u5bf9\u4e00\u81f4");
        } else {
            invoiceAmt.setInvoiceCheckResult("\u65e0\u6cd5\u5339\u914d");
        }
        this.rspBO.setInvoiceAmt(invoiceAmt);
    }
}

