/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscBillApplySignService;
import com.tydic.pfscext.api.busi.bo.FscBillApplySignReqBO;
import com.tydic.pfscext.api.busi.bo.FscBillApplySignRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillApplySignService.class)
public class FscBillApplySignServiceImpl
implements FscBillApplySignService {
    private static final Logger logger = LoggerFactory.getLogger(FscBillApplySignServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public FscBillApplySignRspBO dealInvoiceSign(FscBillApplySignReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53ee\u5f53\u53d1\u7968\u7533\u8bf7\u7b7e\u6536\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getApplyNo() == null || reqBO.getApplyNo().isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u7b7e\u6536\u5355\u53f7\u4e3a\u7a7a");
        }
        if (!"2".equals(reqBO.getIsProfessionalOrgExt())) {
            throw new PfscExtBusinessException("18000", "\u53ea\u80fd\u662f\u4f9b\u5e94\u5546");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getApplyNo());
        if (billApplyInfo != null) {
            if (billApplyInfo.getBillStatus().equals(BillStatus.SEND_BILL.getCode())) {
                billApplyInfo.setSignDate(new Date());
                billApplyInfo.setBillStatus(BillStatus.SIGNED_IN.getCode());
                this.billApplyInfoMapper.updateByPrimaryKey(billApplyInfo);
                return new FscBillApplySignRspBO();
            }
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7684\u72b6\u6001\u5fc5\u987b\u662f" + (Object)((Object)BillStatus.SEND_BILL) + "\u72b6\u6001");
        }
        throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7533\u8bf7\u4fe1\u606f\u4e0d\u5b58\u5728");
    }
}

