/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.tydic.pfscext.api.busi.FscQueryPayableAdjustService;
import com.tydic.pfscext.api.busi.bo.BusiQueryPayableAdjustReqBo;
import com.tydic.pfscext.api.busi.bo.BusiQueryPayableAdjustRspBo;
import com.tydic.pfscext.api.busi.bo.PayableAdjustLogBo;
import com.tydic.pfscext.dao.PayableAdjustLogMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableAdjustLog;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.AdjustType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscQueryPayableAdjustService.class)
public class FscQueryPayableAdjustServiceImpl
implements FscQueryPayableAdjustService {
    private static final Logger log = LoggerFactory.getLogger(FscQueryPayableAdjustServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PayableAdjustLogMapper payableAdjustLogMapper;

    public BusiQueryPayableAdjustRspBo queryPayableAdjustByPayableNo(BusiQueryPayableAdjustReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u7ed3\u7b97\u4e2d\u5fc3\u5e94\u4ed8\u8c03\u6574\u67e5\u8be2 \u5165\u53c2\uff1a" + JSON.toString((Object)reqBo));
        }
        if (reqBo.getPayableNo() == null) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u8c03\u6574\u67e5\u8be2\u5165\u53c2 \u5e94\u4ed8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryPayableAdjustRspBo rspBo = new BusiQueryPayableAdjustRspBo();
        PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(reqBo.getPayableNo());
        if (!"01".equals(payableDetailPO.getPayableStatus()) && payableDetailPO.getEffectiveStatus() == 0) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u672a\u751f\u6548\u6216\u8005\u5e94\u4ed8\u5355\u4e0d\u5904\u4e8e\u5f85\u652f\u4ed8\u72b6\u6001");
        }
        if (payableDetailPO != null) {
            String recOrgName;
            reqBo.setPayableNo(reqBo.getPayableNo());
            rspBo.setOperatorName(reqBo.getName());
            rspBo.setPayableAmt(payableDetailPO.getPayableAmt());
            rspBo.setRecOrgId(payableDetailPO.getRecOrgId());
            if ("1".equals(reqBo.getIsProfessionalOrgExt())) {
                recOrgName = this.organizationInfoService.queryOrgName(payableDetailPO.getRecOrgId());
                rspBo.setRecOrgName(recOrgName);
            } else if ("2".equals(reqBo.getIsProfessionalOrgExt())) {
                recOrgName = this.organizationInfoService.querySupplierName(payableDetailPO.getRecOrgId());
                rspBo.setRecOrgName(recOrgName);
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u8c03\u6574\u67e5\u8be2 \u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
        }
        List<PayableAdjustLog> payableAdjustLogs = this.payableAdjustLogMapper.getPayableAdjustLogByPayableNo(reqBo.getPayableNo());
        ArrayList<PayableAdjustLogBo> payableAdjustLogBos = new ArrayList<PayableAdjustLogBo>();
        if (payableAdjustLogs != null && payableAdjustLogs.size() > 0) {
            for (PayableAdjustLog payableAdjustLog : payableAdjustLogs) {
                PayableAdjustLogBo payableAdjustLogBo = new PayableAdjustLogBo();
                BeanUtils.copyProperties((Object)payableAdjustLog, (Object)payableAdjustLogBo);
                log.debug("========================test" + payableAdjustLog);
                String adjustTypeStr = AdjustType.getInstance(payableAdjustLog.getAdjustType()).getDescr();
                payableAdjustLogBo.setAdjustTypeStr(adjustTypeStr);
                payableAdjustLogBos.add(payableAdjustLogBo);
            }
        }
        rspBo.setPayableAdjustLogBos(payableAdjustLogBos);
        return rspBo;
    }
}

