/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.PayUpdatePayConfigDetailService;
import com.tydic.pfscext.api.busi.bo.PayConfigDetailReqBo;
import com.tydic.pfscext.api.busi.bo.PayConfigDetailRspBo;
import com.tydic.pfscext.dao.PayConfigDetailMapper;
import com.tydic.pfscext.dao.po.PayConfigDetail;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayUpdatePayConfigDetailServiceImpl
implements PayUpdatePayConfigDetailService {
    private static final Logger logger = LoggerFactory.getLogger(PayUpdatePayConfigDetailServiceImpl.class);
    @Autowired
    private PayConfigDetailMapper payConfigDetailMapper;

    public PayConfigDetailRspBo payUpdatePayConfigDetail(PayConfigDetailReqBo reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u548c\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u670d\u52a1\u5165\u53c2\uff1a" + reqBo);
        }
        if (null == reqBo) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayConfigDetailId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u3010\u652f\u4ed8\u914d\u7f6e\u8be6\u60c5id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOverAtm()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u3010\u6539\u53d8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u767d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayConfigDetail payConfigDetail = this.payConfigDetailMapper.selectByPrimaryKey(reqBo.getPayConfigDetailId());
        if (null != payConfigDetail) {
            if (payConfigDetail.getBalance().compareTo(reqBo.getOverAtm()) == -1) {
                throw new PfscExtBusinessException("18000", "\u5269\u4f59\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3");
            }
            BigDecimal overAtm = reqBo.getOverAtm();
            BeanUtils.copyProperties((Object)payConfigDetail, (Object)reqBo);
            reqBo.setOverAtm(overAtm);
            reqBo.setBalance(payConfigDetail.getBalance().subtract(overAtm));
            reqBo.setUsedQuota(payConfigDetail.getUsedQuota().add(overAtm));
            this.payConfigDetailMapper.updateByPrimaryKeyByQuota(reqBo);
        }
        return new PayConfigDetailRspBo();
    }
}

