/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.ability.saleorder.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.order.extend.ability.saleorder.UocExtOrderDetailsQueryAbilityService;
import com.tydic.order.extend.bo.saleorder.PebExtMainOrderDetailQueryReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtMainOrderDetailQueryRspBO;
import com.tydic.order.extend.bo.saleorder.UocExtOrderDetailsQueryReqBO;
import com.tydic.order.extend.bo.saleorder.UocExtOrderDetailsQueryRspBO;
import com.tydic.pfscext.api.busi.SynchronizationOrderDateBusiService;
import com.tydic.pfscext.api.busi.bo.SynchronizationOrderDateRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiK3Service;
import com.tydic.pfscext.external.api.bo.PurPayableDetailInfoBO;
import com.tydic.pfscext.external.api.bo.PurPaybillInfoBO;
import com.tydic.pfscext.external.api.bo.QryPurPayableDetailReqBO;
import com.tydic.pfscext.external.api.bo.QryPurPayableDetailRspBO;
import com.tydic.pfscext.external.api.bo.QryTSyncPaybillReqBO;
import com.tydic.pfscext.external.api.bo.QryTSyncPaybillRspBO;
import com.tydic.pfscext.external.api.bo.UpPayableDetailReqBO;
import com.tydic.pfscext.external.api.bo.UpPaybillInfoReqBO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=SynchronizationOrderDateBusiService.class)
public class SynchronizationOrderDateBusiServiceImpl
implements SynchronizationOrderDateBusiService {
    private static final Logger log = LoggerFactory.getLogger(SynchronizationOrderDateBusiServiceImpl.class);
    @Autowired
    private BusiK3Service busiK3Service;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_TEST")
    private UocExtOrderDetailsQueryAbilityService uocExtOrderDetailsQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_TEST")
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;

    @Transactional
    public SynchronizationOrderDateRspBO insertK3OrderDate() {
        SynchronizationOrderDateRspBO rspBO = new SynchronizationOrderDateRspBO();
        String fflag = "00";
        QryPurPayableDetailReqBO qryPurPayableDetailReqBO = new QryPurPayableDetailReqBO();
        QryTSyncPaybillReqBO qryTSyncPaybillReqBO = new QryTSyncPaybillReqBO();
        qryPurPayableDetailReqBO.setFflag(fflag);
        qryTSyncPaybillReqBO.setFflag(fflag);
        try {
            QryTSyncPaybillRspBO tSyncPaybillData = this.busiK3Service.getTSyncPaybillData(qryTSyncPaybillReqBO);
            log.info("\u83b7\u53d6\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e" + JSON.toJSONString((Object)tSyncPaybillData));
            if (tSyncPaybillData.getRespCode().equals("8888")) {
                rspBO.setRespCode(tSyncPaybillData.getRespCode());
                rspBO.setRespDesc(tSyncPaybillData.getRespDesc());
                log.info(JSON.toJSONString((Object)rspBO));
                return rspBO;
            }
            QryPurPayableDetailRspBO purPayableDetailData = this.busiK3Service.getPurPayableDetailData(qryPurPayableDetailReqBO);
            log.info("\u91c7\u8d2d\u5e94\u4ed8\u5355\u6570\u636e:{}" + JSON.toJSONString((Object)purPayableDetailData));
            if (purPayableDetailData.getRespCode().equals("8888")) {
                rspBO.setRespCode(tSyncPaybillData.getRespCode());
                rspBO.setRespDesc(tSyncPaybillData.getRespDesc());
                log.info(JSON.toJSONString((Object)rspBO));
                return rspBO;
            }
            if (tSyncPaybillData.getPurPaybillInfoBOList().isEmpty()) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u672c\u6b21\u8c03\u7528\u672a\u83b7\u53d6\u5230\u6709\u6548\u6570\u636e");
                log.info(JSON.toJSONString((Object)rspBO));
                return rspBO;
            }
            List<PurPaybillInfoBO> purPaybillInfoBOList = this.insertQryTSyncPaybillRspBO(tSyncPaybillData);
            List<PurPayableDetailInfoBO> purPayableDetailInfoBOList = this.insertPurPayableDetailData(purPayableDetailData);
            this.insertAppleDetail(purPaybillInfoBOList, purPayableDetailInfoBOList);
            UpPaybillInfoReqBO upPaybillInfoReqBO = new UpPaybillInfoReqBO();
            upPaybillInfoReqBO.setFflag("00");
            upPaybillInfoReqBO.setPurPaybillInfoBOList(purPaybillInfoBOList);
            this.busiK3Service.updatePaybillReadStatus(upPaybillInfoReqBO);
            UpPayableDetailReqBO upPayableDetailReqBO = new UpPayableDetailReqBO();
            upPayableDetailReqBO.setFflag("00");
            upPayableDetailReqBO.setPurPayableDetailInfoBOList(purPayableDetailInfoBOList);
            this.busiK3Service.updatePayableDetailReadStatus(upPayableDetailReqBO);
        }
        catch (PfscExtBusinessException e) {
            rspBO.setRespCode(e.getMsgCode());
            rspBO.setRespDesc("\u6dfb\u52a0\u6570\u636e\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fdd\u5b58\u8ba2\u5355\u6570\u636e\u6210\u529f");
        log.info(JSON.toJSONString((Object)rspBO));
        return rspBO;
    }

    private void insertAppleDetail(List<PurPaybillInfoBO> purPaybillInfoBOList, List<PurPayableDetailInfoBO> purPayableDetailInfoBOList) {
        for (PurPaybillInfoBO purPaybillInfoBO : purPaybillInfoBOList) {
            for (PurPayableDetailInfoBO purPayableDetailInfoBO : purPayableDetailInfoBOList) {
                if (!purPaybillInfoBO.getOrderNo().equals(purPayableDetailInfoBO.getOrderNo())) continue;
                ApplyDetail applyDetail = new ApplyDetail();
                applyDetail.setPayableNo(purPayableDetailInfoBO.getPayableNo());
                applyDetail.setSupplierId(Long.valueOf(purPaybillInfoBO.getSupplierId()));
                applyDetail.setStatus(purPayableDetailInfoBO.getPayType());
                applyDetail.setAmt(purPayableDetailInfoBO.getPayableAmt());
                applyDetail.setApplyNo(purPaybillInfoBO.getPayNo());
                log.info("\u6dfb\u52a0\u4e2d\u95f4\u8868\u6570\u636e\uff1a{}" + JSON.toJSONString((Object)applyDetail));
                try {
                    this.applyDetailMapper.insert(applyDetail);
                }
                catch (Exception e) {
                    log.info("\u6dfb\u52a0\u4e2d\u95f4\u8868\u6570\u636e\uff1a{}" + JSON.toJSONString((Object)e));
                    throw new PfscExtBusinessException("8888", "\u6dfb\u52a0\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e\u5931\u8d25:" + e.getLocalizedMessage());
                }
            }
        }
    }

    private List<PurPayableDetailInfoBO> insertPurPayableDetailData(QryPurPayableDetailRspBO purPayableDetailData) {
        List purPayableDetailInfoBOList = purPayableDetailData.getPurPayableDetailInfoBOList();
        ArrayList<PurPayableDetailInfoBO> payableDetailInfoBOList = new ArrayList<PurPayableDetailInfoBO>();
        for (PurPayableDetailInfoBO infoBO : purPayableDetailInfoBOList) {
            PayableDetailPO payableDetail = new PayableDetailPO();
            PurPayableDetailInfoBO purPayableDetailInfoBO = new PurPayableDetailInfoBO();
            payableDetail.setPurchaseOrderCode(infoBO.getPurchaseOrderCode());
            payableDetail.setPayableNo(infoBO.getPayableNo());
            payableDetail.setPayableAmt(infoBO.getPayableAmt());
            UocExtOrderDetailsQueryReqBO reqBO = new UocExtOrderDetailsQueryReqBO();
            reqBO.setSaleVoucherNo(infoBO.getOrderNo());
            log.info("\u9500\u552e\u5355\u8be6\u60c5\u2014\u2014------\u300b:{}" + JSON.toJSONString((Object)reqBO));
            UocExtOrderDetailsQueryRspBO rspBO = this.uocExtOrderDetailsQueryAbilityService.orderDetailsQuery(reqBO);
            log.info("\u9500\u552e\u5355\u8be6\u60c5\u2014\u2014\u300a\u300a\u300a\u300a\u300a:{}" + JSON.toJSONString((Object)rspBO));
            PebExtMainOrderDetailQueryReqBO queryReqBO = new PebExtMainOrderDetailQueryReqBO();
            queryReqBO.setOrderId(rspBO.getOrdSaleRspBO().getOrderId());
            queryReqBO.setSaleVoucherId(rspBO.getOrdSaleRspBO().getSaleVoucherId());
            PebExtMainOrderDetailQueryRspBO queryRspBO = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(queryReqBO);
            log.info("\u4e3b\u8ba2\u5355\u8be6\u60c5\u2014\u2014-------\u300b:{}" + JSON.toJSONString((Object)queryRspBO));
            payableDetail.setOrderId(rspBO.getOrdSaleRspBO().getOrderId());
            Integer payableType = Integer.valueOf(queryRspBO.getOrderRspBO().getPayType());
            if (2 == payableType) {
                Calendar instance = Calendar.getInstance();
                instance.setTime(queryRspBO.getOrderRspBO().getUpdateTime());
                String paymentDays = rspBO.getOrdSaleRspBO().getPaymentDays();
                instance.add(5, Integer.parseInt("3"));
                payableDetail.setPaidDate(instance.getTime());
            }
            payableDetail.setRecOrgId(Long.valueOf(queryRspBO.getOrdStakeholderRspBO().getSupNo()));
            payableDetail.setPayOrgId(Long.valueOf(queryRspBO.getOrdStakeholderRspBO().getPurNo()));
            payableDetail.setSupplierId(Long.valueOf(infoBO.getBillNotificationInfoBO().getSupplierId()));
            log.info(" ----\u2014\u2014-------\u300b:{}");
            payableDetail.setPurchaseNo(Long.valueOf(queryRspBO.getOrdStakeholderRspBO().getPurNo()));
            log.info(" ----\u2014\u2014-------\u300b:{}");
            payableDetail.setPurchaseName(queryRspBO.getOrdStakeholderRspBO().getPurName());
            log.info(" ----\u2014\u2014-------\u300b:{}");
            payableDetail.setOverdueDays(0);
            payableDetail.setApproveStatus(0);
            payableDetail.setEffectiveStatus(1);
            payableDetail.setPayType(PayablePayType.PAY.getCode());
            payableDetail.setPayableStatus(PayableStatus.PAYINGS.getCode());
            log.info("\u6dfb\u52a0\u5e94\u4ed8\u5355\u6570\u636e\uff1a{}" + JSON.toJSONString((Object)payableDetail));
            try {
                this.payableDetailMapper.insert(payableDetail);
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("8888", "\u6dfb\u52a0\u91c7\u8d2d\u5e94\u4ed8\u5355\u6570\u636e\u5931\u8d25:" + e.getLocalizedMessage());
            }
            purPayableDetailInfoBO.setOrderNo(infoBO.getOrderNo());
            purPayableDetailInfoBO.setOrderId(infoBO.getOrderId());
            purPayableDetailInfoBO.setPlaAgreementCode(infoBO.getPlaAgreementCode());
            purPayableDetailInfoBO.setPayableNo(infoBO.getPayableNo());
            purPayableDetailInfoBO.setOutPayOrderNo(infoBO.getOutPayOrderNo());
            purPayableDetailInfoBO.setPurchaseOrderCode(infoBO.getPurchaseOrderCode());
            purPayableDetailInfoBO.setInvoiceNo(infoBO.getInvoiceNo());
            payableDetailInfoBOList.add(purPayableDetailInfoBO);
        }
        return payableDetailInfoBOList;
    }

    private List<PurPaybillInfoBO> insertQryTSyncPaybillRspBO(QryTSyncPaybillRspBO tSyncPaybillData) {
        List infoBOList = tSyncPaybillData.getPurPaybillInfoBOList();
        ArrayList<PurPaybillInfoBO> purPaybillInfoBOList = new ArrayList<PurPaybillInfoBO>();
        log.info("\u5904\u7406\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e:{}" + JSON.toJSONString((Object)tSyncPaybillData));
        for (PurPaybillInfoBO infoBO : infoBOList) {
            PurPaybillInfoBO purPaybillInfoBO = new PurPaybillInfoBO();
            ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
            applyPayInfoPO.setPayableAtm(infoBO.getPayableAmt());
            applyPayInfoPO.setPayAmt(infoBO.getPayableAmt());
            applyPayInfoPO.setPayno(infoBO.getPayNo());
            applyPayInfoPO.setSupplierId(Long.valueOf(infoBO.getSupplierId()));
            applyPayInfoPO.setApplyDate(new Date());
            applyPayInfoPO.setPayStatus(ApplyPayStatus.PENDING_PAYMENT.getCode());
            applyPayInfoPO.setSource("1");
            log.info("\u6dfb\u52a0\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e\uff1a{}" + JSON.toJSONString((Object)applyPayInfoPO));
            try {
                this.applyPayInfoMapper.insert(applyPayInfoPO);
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("8888", "\u6dfb\u52a0\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e\u5931\u8d25:" + e.getLocalizedMessage());
            }
            purPaybillInfoBO.setOrderNo(infoBO.getOrderNo());
            purPaybillInfoBO.setOrderId(infoBO.getOrderId());
            purPaybillInfoBO.setContactNo(infoBO.getContactNo());
            purPaybillInfoBO.setPayNo(infoBO.getPayNo());
            purPaybillInfoBO.setOutPayOrderNo(infoBO.getOutPayOrderNo());
            purPaybillInfoBO.setPurchaseOrderCode(infoBO.getPurchaseOrderCode());
            purPaybillInfoBOList.add(purPaybillInfoBO);
        }
        return purPaybillInfoBOList;
    }
}

