/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfscext.api.pay.ReturnPayOrderService;
import com.tydic.pfscext.api.pay.bo.ReturnPayOrderReqBO;
import com.tydic.pfscext.api.pay.bo.ReturnPayOrderRspBO;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=ReturnPayOrderService.class)
public class ReturnPayOrderServiceImpl
implements ReturnPayOrderService {
    private static final Logger logger = LoggerFactory.getLogger(ReturnPayOrderServiceImpl.class);
    private String service_url;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    public ReturnPayOrderRspBO returnPayOrder(ReturnPayOrderReqBO reqBO) {
        ReturnPayOrderRspBO rspBO = new ReturnPayOrderRspBO();
        if (null == reqBO.getOriOrderId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[oriOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderNo = reqBO.getOriOrderId();
        try {
            PaymentFlowInfo paymentFlowInfo = this.paymentFlowInfoMapper.selectByOutOrderId(orderNo);
            if (null == paymentFlowInfo) {
                logger.error("\u652f\u4ed8\u8ba2\u5355" + orderNo + "\u4e0d\u5b58\u5728");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u652f\u4ed8\u8ba2\u5355" + orderNo + "\u4e0d\u5b58\u5728");
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            this.savelog("CreatePayOrderService-170", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\uff1a" + e);
            this.savelog("CreatePayOrderService-174", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25" + e);
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

