/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.external.api.BusiK3Service;
import com.tydic.pfscext.external.api.bo.PurPaybillInfoBO;
import com.tydic.pfscext.external.api.bo.QryPurPayableDetailReqBO;
import com.tydic.pfscext.external.api.bo.QryPurPayableDetailRspBO;
import com.tydic.pfscext.external.api.bo.QryTSyncPaybillReqBO;
import com.tydic.pfscext.external.api.bo.QryTSyncPaybillRspBO;
import com.tydic.pfscext.external.api.bo.UpPayableDetailReqBO;
import com.tydic.pfscext.external.api.bo.UpPaybillInfoReqBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class BusiK3ServiceImpl
implements BusiK3Service {
    private static final Logger log = LoggerFactory.getLogger(BusiK3ServiceImpl.class);
    @Autowired
    private Environment prop;
    @Value(value="${TSYNCPAYBILL_URL}")
    private String tSyncPaybillUrl;
    @Value(value="${PURPAYABLEDETAIL_URL}")
    private String purPayableDetailUrl;
    @Value(value="${UPDATE_PAYBILLREAD_STATUS_URL}")
    private String updatePaybillReadStatusUrl;
    @Value(value="${UPDAT_EPAYABLEDETAILREAD_STATUS_URL}")
    private String updatePayableDetailReadStatusUrl;

    @Override
    public QryTSyncPaybillRspBO getTSyncPaybillData(QryTSyncPaybillReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO);
        QryTSyncPaybillRspBO qryTSyncPaybillRspBO = null;
        String s = this.sendRequest(this.tSyncPaybillUrl, jsonString);
        log.info("tSyncPaybillUrl-->:{}" + this.tSyncPaybillUrl);
        String respDesc = StringUtils.substring((String)s, (int)0, (int)StringUtils.indexOf((CharSequence)s, (CharSequence)"respDesc"));
        boolean contains = StringUtils.contains((CharSequence)respDesc, (CharSequence)"8888");
        if (contains) {
            qryTSyncPaybillRspBO.setRespCode("8888");
            qryTSyncPaybillRspBO.setRespDesc("\u83b7\u53d6\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e\u5931\u8d25");
            qryTSyncPaybillRspBO.setPurPaybillInfoBOList(null);
            return qryTSyncPaybillRspBO;
        }
        int i = StringUtils.indexOf((CharSequence)s, (CharSequence)"{\"respCode");
        String substring = StringUtils.substring((String)s, (int)i, (int)(s.length() - 1));
        qryTSyncPaybillRspBO = (QryTSyncPaybillRspBO)JSON.parseObject((String)substring, QryTSyncPaybillRspBO.class);
        int j = StringUtils.indexOf((CharSequence)s, (CharSequence)"purPaybillInfoBOList");
        String listStr = StringUtils.substring((String)s, (int)j, (int)(j + 26));
        log.info("listStr-->:{}" + listStr);
        if (listStr.contains("null")) {
            qryTSyncPaybillRspBO.setPurPaybillInfoBOList(new ArrayList<PurPaybillInfoBO>());
        }
        return qryTSyncPaybillRspBO;
    }

    @Override
    public QryPurPayableDetailRspBO getPurPayableDetailData(QryPurPayableDetailReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO);
        QryPurPayableDetailRspBO qryPurPayableDetailRspBO = null;
        String s = this.sendRequest(this.purPayableDetailUrl, jsonString);
        log.info("purPayableDetailUrl-->:{}" + this.purPayableDetailUrl);
        boolean contains = StringUtils.contains((CharSequence)s, (CharSequence)"8888");
        if (contains) {
            qryPurPayableDetailRspBO.setRespCode("8888");
            qryPurPayableDetailRspBO.setRespDesc("\u83b7\u53d6\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e\u5931\u8d25");
            qryPurPayableDetailRspBO.setPurPayableDetailInfoBOList(null);
            return qryPurPayableDetailRspBO;
        }
        String substring = StringUtils.substring((String)s, (int)StringUtils.indexOf((CharSequence)s, (CharSequence)"{\"respCode"), (int)(s.length() - 1));
        return (QryPurPayableDetailRspBO)JSON.parseObject((String)substring, QryPurPayableDetailRspBO.class);
    }

    @Override
    public void updatePaybillReadStatus(UpPaybillInfoReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO);
        String result = this.sendRequest(this.updatePaybillReadStatusUrl, jsonString);
        log.info("updatePaybillReadStatusUrl-->:{}" + this.updatePaybillReadStatusUrl);
        if (StringUtils.contains((CharSequence)result, (CharSequence)"8888")) {
            throw new PfscExternalBusinessException("8888", "\u66f4\u65b0\u91c7\u8d2d\u4ed8\u6b3e\u5355\u6570\u636e\u4e3a\u5df2\u8bfb\u72b6\u6001\u5931\u8d25");
        }
    }

    @Override
    public void updatePayableDetailReadStatus(UpPayableDetailReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO);
        String result = this.sendRequest(this.updatePayableDetailReadStatusUrl, jsonString);
        log.info("updatePayableDetailReadStatusUrl-->:{}" + this.updatePayableDetailReadStatusUrl);
        if (StringUtils.contains((CharSequence)result, (CharSequence)"8888")) {
            throw new PfscExternalBusinessException("8888", "\u66f4\u65b0\u5e94\u4ed8\u5355\u6570\u636e\u4e3a\u5df2\u8bfb\u72b6\u6001\u5931\u8d25");
        }
    }

    private String sendRequest(String url, String jsonString) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(jsonString, "UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        httpPost.setHeader("Content-Type", "application/json;charset=utf8");
        log.info("\u521b\u5efa\u8bf7\u6c42\u5b8c\u6210:{}" + url);
        CloseableHttpResponse response = null;
        try {
            log.info("1");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            log.info("// \u7531\u5ba2\u6237\u7aef\u6267\u884c(\u53d1\u9001)Get\u8bf7\u6c42----\u300b:{sendRequest}" + url);
            response = httpClient.execute((HttpUriRequest)httpPost);
            log.info("1");
            HttpEntity responseEntity = response.getEntity();
            String jsonStr = "";
            log.info("\u54cd\u5e94\u72b6\u6001\u4e3a:" + response.getStatusLine());
            if (responseEntity != null) {
                jsonStr = EntityUtils.toString((HttpEntity)responseEntity);
                log.info("\u54cd\u5e94\u5185\u5bb9\u957f\u5ea6\u4e3a:" + responseEntity.getContentLength());
                log.info(jsonString + "  \u54cd\u5e94\u5185\u5bb9\u4e3a:" + jsonStr);
            }
            String string = jsonStr;
            return string;
        }
        catch (Exception e) {
            throw new PfscExternalBusinessException("8888", e.getMessage());
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception e) {
                throw new PfscExternalBusinessException("8888", e.getMessage());
            }
        }
    }
}

