/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.tydic.pfscext.external.api.BusiApplyPayInfoService;
import com.tydic.pfscext.external.api.bo.BusiApplyPayInfoPayee;
import com.tydic.pfscext.external.api.bo.BusiApplyPayInfoReqBo;
import com.tydic.pfscext.external.api.bo.BusiApplyPayInfoRspBo;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiApplyPayInfoServiceImpl
implements BusiApplyPayInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiApplyPayInfoServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private Environment prop;
    @Value(value="${DOUBLE_LINK_CREATE_PAY}")
    private String DOUBLE_LINK_CREATE_PAY;

    @Override
    public BusiApplyPayInfoRspBo createApplyPayInfo(BusiApplyPayInfoReqBo reqBo) {
        HttpRetBean httpRetBean;
        if (this.isDebugEnabled) {
            log.debug("\u5411\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u5165\u53c2\uff1a" + reqBo.toString());
        }
        this.initParam(reqBo);
        String reqStr = this.initReqStr(reqBo);
        log.debug("\u53cc\u94fe\u901a\u4e32\u8bb2\u4ed8\u6b3e\u7533\u8bf7\u5355\u7533\u8bf7\u62a5\u6587" + reqStr);
        log.debug("============================applydoublelink" + this.DOUBLE_LINK_CREATE_PAY);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.DOUBLE_LINK_CREATE_PAY), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25,\u552f\u4e00\u6807\u793a\u4e3a" + reqBo.getProductCode(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25,\u552f\u4e00\u6807\u793a\u4e3a" + reqBo.getProductCode());
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_OUTSTOTOTAL_SEND_YUANGUANG_URL") + "]");
            throw new RuntimeException("\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        log.info("\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4fe1\u606f\u4f20\u8f93\u63a5\u53e3\u670d\u52a1--->\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        BusiApplyPayInfoRspBo busiApplyPayInfoRspBo = this.resolveRsp(returnString);
        return busiApplyPayInfoRspBo;
    }

    private BusiApplyPayInfoRspBo resolveRsp(String returnString) {
        BusiApplyPayInfoRspBo rspBO = null;
        try {
            com.alibaba.fastjson.JSONObject rspJsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)returnString);
            String encoded_result_obj1 = rspJsonObject.getString("encoded_result_obj");
            JSONObject jsonObject = JSONObject.fromObject((Object)encoded_result_obj1);
            rspBO = (BusiApplyPayInfoRspBo)JSONObject.toBean((JSONObject)jsonObject, BusiApplyPayInfoRspBo.class);
            log.debug("=====================\u7533\u8bf7\u53c2\u6570\u5bf9\u8c61" + rspBO);
            rspBO.setCode(rspJsonObject.getString("code"));
            rspBO.setMsg(rspJsonObject.getString("msg"));
            rspBO.setSuccess(rspJsonObject.getBoolean("success"));
            rspBO.setError_code(rspJsonObject.getString("error_code"));
            rspBO.setError_msg(rspJsonObject.getString("error_msg"));
            rspBO.setError_view_msg(rspJsonObject.getString("error_view_msg"));
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u8c03\u7528\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u8c03\u7528\u53cc\u94fe\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return rspBO;
    }

    private String initReqStr(BusiApplyPayInfoReqBo reqBo) {
        StringBuffer payer = new StringBuffer();
        payer.append("{").append("\"acct_id\":").append("\"" + reqBo.getPayer().getAcctId() + "\"").append("}");
        StringBuffer payee = new StringBuffer();
        payee.append("[");
        for (int i = 0; i < reqBo.getPayeeList().size(); ++i) {
            payee.append("{").append("\"acct_id\":").append("\"" + reqBo.getPayeeList().get(i).getAcctId() + "\",").append("\"amount\":").append("\"" + reqBo.getPayeeList().get(i).getAmount() + "\",").append("\"main_payee\":").append("\"" + reqBo.getPayeeList().get(i).getMainPayee() + "\"").append("}");
            if (i != reqBo.getPayeeList().size() - 1) {
                payee.append(",");
                continue;
            }
            payee.append("]");
        }
        StringBuffer applyPayInfoReqSb = new StringBuffer();
        applyPayInfoReqSb.append("{").append("\"product_code\":").append("\"" + reqBo.getProductCode() + "\",").append("\"payer\":").append(payer + ",").append("\"payee_list\":").append(payee + ",").append("\"out_order_no\":").append("\"" + reqBo.getOutOrderNo() + "\",").append("\"amount\":").append("\"" + reqBo.getAmount() + "\",").append("\"pay_date\":").append("\"" + reqBo.getPayDate() + "\",").append("\"memo\":").append("\"" + reqBo.getMemo() + "\",").append("\"allow_holiday\":").append("\"" + reqBo.getAllowHoliday() + "\",").append("\"expired_auto_close\":").append("\"" + reqBo.getExpiredAutoClose() + "\"").append("}");
        return applyPayInfoReqSb.toString();
    }

    private void initParam(BusiApplyPayInfoReqBo reqBo) {
        if (null == reqBo.getProductCode()) {
            throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ea7\u54c1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayer()) {
            throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ed8\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayer().getAcctId()) {
            throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ed8\u6b3e\u4eba\u8d26\u53f7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayeeList()) {
            throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ed8\u6b3e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (BusiApplyPayInfoPayee payee : reqBo.getPayeeList()) {
            if (null == payee.getAcctId()) {
                throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ed8\u6b3e\u5217\u8868\u8d26\u53f7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == payee.getAmount()) {
                throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ed8\u6b3e\u5217\u8868\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != payee.getMainPayee()) continue;
            throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ed8\u6b3e\u5217\u8868\u4e3b\u4ed8\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAmount()) {
            throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u4ed8\u6b3e\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayDate()) {
            throw new PfscExternalBusinessException("0001", "\u53cc\u8fde\u901a\u521b\u5efa\u4ed8\u6b3e\u5355\u7533\u8bf7\u4e1a\u52a1 \u6700\u665a\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

