/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.enums;

import com.tydic.pfscext.enums.BaseEnums;

public enum CompanyType implements BaseEnums
{
    OTHER(0, "-"),
    PURCHASER(1, "\u91c7\u8d2d\u5546"),
    SUPPLIER(2, "\u4f9b\u5e94\u5546");

    private String groupName = "COMPANY_TYPE";
    private Integer code;
    private String codeDescr;

    private CompanyType(Integer code, String codeDescr) {
        this.code = code;
        this.codeDescr = codeDescr;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getCodeAsString() {
        return String.valueOf(this.code);
    }

    @Override
    public String getDescr() {
        return this.codeDescr;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getCodeDescr() {
        return this.codeDescr;
    }

    public static CompanyType convert(Integer code) {
        if (code == null) {
            return null;
        }
        CompanyType[] companyTypeArray = CompanyType.values();
        int n = companyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompanyType o = companyTypeArray[n2];
            if (o.getCode().equals(code)) {
                return o;
            }
            ++n2;
        }
        return null;
    }
}

